/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLlamaFollow;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCarpet;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class EntityLlama
extends EntityHorseChestedAbstract
implements VariantHolder<Variant>,
IRangedEntity {
    private static final int MAX_STRENGTH = 5;
    private static final DataWatcherObject<Integer> DATA_STRENGTH_ID = DataWatcher.defineId(EntityLlama.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_VARIANT_ID = DataWatcher.defineId(EntityLlama.class, DataWatcherRegistry.INT);
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.LLAMA.getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityTypes.LLAMA.getHeight() - 0.8125f, -0.3f)).scale(0.5f);
    boolean didSpit;
    @Nullable
    private EntityLlama caravanHead;
    @Nullable
    private EntityLlama caravanTail;

    public EntityLlama(EntityTypes<? extends EntityLlama> var0, World var1) {
        super((EntityTypes<? extends EntityHorseChestedAbstract>)var0, var1);
    }

    public boolean isTraderLlama() {
        return false;
    }

    private void setStrength(int var0) {
        this.entityData.set(DATA_STRENGTH_ID, Math.max(1, Math.min(5, var0)));
    }

    private void setRandomStrength(RandomSource var0) {
        int var1 = var0.nextFloat() < 0.04f ? 5 : 3;
        this.setStrength(1 + var0.nextInt(var1));
    }

    public int getStrength() {
        return this.entityData.get(DATA_STRENGTH_ID);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Variant", this.getVariant().id);
        var0.putInt("Strength", this.getStrength());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        this.setStrength(var0.getInt("Strength"));
        super.readAdditionalSaveData(var0);
        this.setVariant(Variant.byId(var0.getInt("Variant")));
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new PathfinderGoalTame(this, 1.2));
        this.goalSelector.addGoal(2, new PathfinderGoalLlamaFollow(this, 2.1f));
        this.goalSelector.addGoal(3, new PathfinderGoalArrowAttack(this, 1.25, 40, 20.0f));
        this.goalSelector.addGoal(3, new PathfinderGoalPanic(this, 1.2));
        this.goalSelector.addGoal(4, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.addGoal(5, new PathfinderGoalTempt(this, 1.25, var0 -> var0.is(TagsItem.LLAMA_TEMPT_ITEMS), false));
        this.goalSelector.addGoal(6, new PathfinderGoalFollowParent(this, 1.0));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.goalSelector.addGoal(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(9, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new c(this));
        this.targetSelector.addGoal(2, new a(this));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityLlama.createBaseChestedHorseAttributes().add(GenericAttributes.FOLLOW_RANGE, 40.0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_STRENGTH_ID, 0);
        var0.define(DATA_VARIANT_ID, 0);
    }

    @Override
    public Variant getVariant() {
        return Variant.byId(this.entityData.get(DATA_VARIANT_ID));
    }

    @Override
    public void setVariant(Variant var0) {
        this.entityData.set(DATA_VARIANT_ID, var0.id);
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.LLAMA_FOOD);
    }

    @Override
    protected boolean handleEating(EntityHuman var0, ItemStack var1) {
        SoundEffect var6;
        int var2 = 0;
        int var3 = 0;
        float var4 = 0.0f;
        boolean var5 = false;
        if (var1.is(Items.WHEAT)) {
            var2 = 10;
            var3 = 3;
            var4 = 2.0f;
        } else if (var1.is(Blocks.HAY_BLOCK.asItem())) {
            var2 = 90;
            var3 = 6;
            var4 = 10.0f;
            if (this.isTamed() && this.getAge() == 0 && this.canFallInLove()) {
                var5 = true;
                this.setInLove(var0);
            }
        }
        if (this.getHealth() < this.getMaxHealth() && var4 > 0.0f) {
            this.heal(var4);
            var5 = true;
        }
        if (this.isBaby() && var2 > 0) {
            ((World)this.level()).addParticle(Particles.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            if (!((World)this.level()).isClientSide) {
                this.ageUp(var2);
            }
            var5 = true;
        }
        if (var3 > 0 && (var5 || !this.isTamed()) && this.getTemper() < this.getMaxTemper()) {
            var5 = true;
            if (!((World)this.level()).isClientSide) {
                this.modifyTemper(var3);
            }
        }
        if (var5 && !this.isSilent() && (var6 = this.getEatingSound()) != null) {
            ((World)this.level()).playSound(null, this.getX(), this.getY(), this.getZ(), this.getEatingSound(), this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        return var5;
    }

    @Override
    public boolean isImmobile() {
        return this.isDeadOrDying() || this.isEating();
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3) {
        Variant var5;
        RandomSource var4 = var0.getRandom();
        this.setRandomStrength(var4);
        if (var3 instanceof b) {
            var5 = ((b)var3).variant;
        } else {
            var5 = SystemUtils.getRandom(Variant.values(), var4);
            var3 = new b(var5);
        }
        this.setVariant(var5);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    protected boolean canPerformRearing() {
        return false;
    }

    @Override
    protected SoundEffect getAngrySound() {
        return SoundEffects.LLAMA_ANGRY;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.LLAMA_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.LLAMA_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.LLAMA_DEATH;
    }

    @Override
    @Nullable
    protected SoundEffect getEatingSound() {
        return SoundEffects.LLAMA_EAT;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.LLAMA_STEP, 0.15f, 1.0f);
    }

    @Override
    protected void playChestEquipsSound() {
        this.playSound(SoundEffects.LLAMA_CHEST, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public int getInventoryColumns() {
        return this.hasChest() ? this.getStrength() : 0;
    }

    @Override
    public boolean canUseSlot(EnumItemSlot var0) {
        return true;
    }

    @Override
    public boolean isBodyArmorItem(ItemStack var0) {
        return var0.is(TagsItem.WOOL_CARPETS);
    }

    @Override
    public boolean isSaddleable() {
        return false;
    }

    @Nullable
    private static EnumColor getDyeColor(ItemStack var0) {
        Block var1 = Block.byItem(var0.getItem());
        if (var1 instanceof BlockCarpet) {
            return ((BlockCarpet)var1).getColor();
        }
        return null;
    }

    @Nullable
    public EnumColor getSwag() {
        return EntityLlama.getDyeColor(this.getItemBySlot(EnumItemSlot.BODY));
    }

    @Override
    public int getMaxTemper() {
        return 30;
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        return var0 != this && var0 instanceof EntityLlama && this.canParent() && ((EntityLlama)var0).canParent();
    }

    @Override
    @Nullable
    public EntityLlama getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityLlama var2 = this.makeNewLlama();
        if (var2 != null) {
            this.setOffspringAttributes(var1, var2);
            EntityLlama var3 = (EntityLlama)var1;
            int var4 = this.random.nextInt(Math.max(this.getStrength(), var3.getStrength())) + 1;
            if (this.random.nextFloat() < 0.03f) {
                ++var4;
            }
            var2.setStrength(var4);
            var2.setVariant(this.random.nextBoolean() ? this.getVariant() : var3.getVariant());
        }
        return var2;
    }

    @Nullable
    protected EntityLlama makeNewLlama() {
        return EntityTypes.LLAMA.create((World)this.level());
    }

    private void spit(EntityLiving var0) {
        EntityLlamaSpit var1 = new EntityLlamaSpit((World)this.level(), this);
        double var2 = var0.getX() - this.getX();
        double var4 = var0.getY(0.3333333333333333) - var1.getY();
        double var6 = var0.getZ() - this.getZ();
        double var8 = Math.sqrt(var2 * var2 + var6 * var6) * (double)0.2f;
        var1.shoot(var2, var4 + var8, var6, 1.5f, 10.0f);
        if (!this.isSilent()) {
            ((World)this.level()).playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.LLAMA_SPIT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        this.level().addFreshEntity(var1);
        this.didSpit = true;
    }

    void setDidSpit(boolean var0) {
        this.didSpit = var0;
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        int var3 = this.calculateFallDamage(var0, var1);
        if (var3 <= 0) {
            return false;
        }
        if (var0 >= 6.0f) {
            this.hurt(var2, var3);
            if (this.isVehicle()) {
                for (Entity var5 : this.getIndirectPassengers()) {
                    var5.hurt(var2, var3);
                }
            }
        }
        this.playBlockFallSound();
        return true;
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(EntityLlama var0) {
        this.caravanHead = var0;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public EntityLlama getCaravanHead() {
        return this.caravanHead;
    }

    @Override
    protected double followLeashSpeed() {
        return 2.0;
    }

    @Override
    protected void followMommy() {
        if (!this.inCaravan() && this.isBaby()) {
            super.followMommy();
        }
    }

    @Override
    public boolean canEatGrass() {
        return false;
    }

    @Override
    public void performRangedAttack(EntityLiving var0, float var1) {
        this.spit(var0);
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.75 * (double)this.getEyeHeight(), (double)this.getBbWidth() * 0.5);
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(var0);
    }

    @Override
    protected Vec3D getPassengerAttachmentPoint(Entity var0, EntitySize var1, float var2) {
        return EntityLlama.getDefaultPassengerAttachmentPoint(this, var0, var1.attachments());
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant CREAMY = new Variant(0, "creamy");
        public static final /* enum */ Variant WHITE = new Variant(1, "white");
        public static final /* enum */ Variant BROWN = new Variant(2, "brown");
        public static final /* enum */ Variant GRAY = new Variant(3, "gray");
        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;
        private static final /* synthetic */ Variant[] i;

        public static Variant[] values() {
            return (Variant[])i.clone();
        }

        public static Variant valueOf(String var0) {
            return Enum.valueOf(Variant.class, var0);
        }

        private Variant(int var2, String var3) {
            this.id = var2;
            this.name = var3;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int var0) {
            return BY_ID.apply(var0);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Variant[] b() {
            return new Variant[]{CREAMY, WHITE, BROWN, GRAY};
        }

        static {
            i = Variant.b();
            CODEC = INamable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::getId, Variant.values(), ByIdMap.a.CLAMP);
        }
    }

    static class c
    extends PathfinderGoalHurtByTarget {
        public c(EntityLlama var0) {
            super(var0, new Class[0]);
        }

        @Override
        public boolean canContinueToUse() {
            EntityInsentient entityInsentient = this.mob;
            if (entityInsentient instanceof EntityLlama) {
                EntityLlama var0 = (EntityLlama)entityInsentient;
                if (var0.didSpit) {
                    var0.setDidSpit(false);
                    return false;
                }
            }
            return super.canContinueToUse();
        }
    }

    static class a
    extends PathfinderGoalNearestAttackableTarget<EntityWolf> {
        public a(EntityLlama var02) {
            super(var02, EntityWolf.class, 16, false, true, var0 -> !((EntityWolf)var0).isTame());
        }

        @Override
        protected double getFollowDistance() {
            return super.getFollowDistance() * 0.25;
        }
    }

    static class b
    extends EntityAgeable.a {
        public final Variant variant;

        b(Variant var0) {
            super(true);
            this.variant = var0;
        }
    }
}

