/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;

public class PathfinderGoalOcelotAttack
extends PathfinderGoal {
    private final EntityInsentient mob;
    private EntityLiving target;
    private int attackTime;

    public PathfinderGoalOcelotAttack(EntityInsentient var0) {
        this.mob = var0;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
    }

    @Override
    public boolean canUse() {
        EntityLiving var0 = this.mob.getTarget();
        if (var0 == null) {
            return false;
        }
        this.target = var0;
        return true;
    }

    @Override
    public boolean canContinueToUse() {
        if (!this.target.isAlive()) {
            return false;
        }
        if (this.mob.distanceToSqr(this.target) > 225.0) {
            return false;
        }
        return !this.mob.getNavigation().isDone() || this.canUse();
    }

    @Override
    public void stop() {
        this.target = null;
        this.mob.getNavigation().stop();
    }

    @Override
    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public void tick() {
        this.mob.getLookControl().setLookAt(this.target, 30.0f, 30.0f);
        double var0 = this.mob.getBbWidth() * 2.0f * (this.mob.getBbWidth() * 2.0f);
        double var2 = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        double var4 = 0.8;
        if (var2 > var0 && var2 < 16.0) {
            var4 = 1.33;
        } else if (var2 < 225.0) {
            var4 = 0.6;
        }
        this.mob.getNavigation().moveTo(this.target, var4);
        this.attackTime = Math.max(this.attackTime - 1, 0);
        if (var2 > var0) {
            return;
        }
        if (this.attackTime > 0) {
            return;
        }
        this.attackTime = 20;
        this.mob.doHurtTarget(this.target);
    }
}

