/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;

public abstract class PathfinderGoalDoorInteract
extends PathfinderGoal {
    protected EntityInsentient mob;
    protected BlockPosition doorPos = BlockPosition.ZERO;
    protected boolean hasDoor;
    private boolean passed;
    private float doorOpenDirX;
    private float doorOpenDirZ;

    public PathfinderGoalDoorInteract(EntityInsentient var0) {
        this.mob = var0;
        if (!PathfinderGoalUtil.hasGroundPathNavigation(var0)) {
            throw new IllegalArgumentException("Unsupported mob type for DoorInteractGoal");
        }
    }

    protected boolean isOpen() {
        if (!this.hasDoor) {
            return false;
        }
        IBlockData var0 = this.mob.level().getBlockState(this.doorPos);
        if (!(var0.getBlock() instanceof BlockDoor)) {
            this.hasDoor = false;
            return false;
        }
        return var0.getValue(BlockDoor.OPEN);
    }

    protected void setOpen(boolean var0) {
        IBlockData var1;
        if (this.hasDoor && (var1 = this.mob.level().getBlockState(this.doorPos)).getBlock() instanceof BlockDoor) {
            ((BlockDoor)var1.getBlock()).setOpen(this.mob, this.mob.level(), var1, this.doorPos, var0);
        }
    }

    @Override
    public boolean canUse() {
        if (!PathfinderGoalUtil.hasGroundPathNavigation(this.mob)) {
            return false;
        }
        if (!this.mob.horizontalCollision) {
            return false;
        }
        Navigation var0 = (Navigation)this.mob.getNavigation();
        PathEntity var1 = var0.getPath();
        if (var1 == null || var1.isDone() || !var0.canOpenDoors()) {
            return false;
        }
        for (int var2 = 0; var2 < Math.min(var1.getNextNodeIndex() + 2, var1.getNodeCount()); ++var2) {
            PathPoint var3 = var1.getNode(var2);
            this.doorPos = new BlockPosition(var3.x, var3.y + 1, var3.z);
            if (this.mob.distanceToSqr(this.doorPos.getX(), this.mob.getY(), this.doorPos.getZ()) > 2.25) continue;
            this.hasDoor = BlockDoor.isWoodenDoor(this.mob.level(), this.doorPos);
            if (!this.hasDoor) continue;
            return true;
        }
        this.doorPos = this.mob.blockPosition().above();
        this.hasDoor = BlockDoor.isWoodenDoor(this.mob.level(), this.doorPos);
        return this.hasDoor;
    }

    @Override
    public boolean canContinueToUse() {
        return !this.passed;
    }

    @Override
    public void start() {
        this.passed = false;
        this.doorOpenDirX = (float)((double)this.doorPos.getX() + 0.5 - this.mob.getX());
        this.doorOpenDirZ = (float)((double)this.doorPos.getZ() + 0.5 - this.mob.getZ());
    }

    @Override
    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public void tick() {
        float var1;
        float var0 = (float)((double)this.doorPos.getX() + 0.5 - this.mob.getX());
        float var2 = this.doorOpenDirX * var0 + this.doorOpenDirZ * (var1 = (float)((double)this.doorPos.getZ() + 0.5 - this.mob.getZ()));
        if (var2 < 0.0f) {
            this.passed = true;
        }
    }
}

