/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class BehaviorTradeVillager
extends Behavior<EntityVillager> {
    private Set<Item> trades = ImmutableSet.of();

    public BehaviorTradeVillager() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.INTERACTION_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        return BehaviorUtil.targetIsValid(var1.getBrain(), MemoryModuleType.INTERACTION_TARGET, EntityTypes.VILLAGER);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityVillager var1, long var2) {
        return this.checkExtraStartConditions(var0, var1);
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var2) {
        EntityVillager var4 = (EntityVillager)var1.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get();
        BehaviorUtil.lockGazeAndWalkToEachOther(var1, var4, 0.5f, 2);
        this.trades = BehaviorTradeVillager.figureOutWhatIAmWillingToTrade(var1, var4);
    }

    @Override
    protected void tick(WorldServer var0, EntityVillager var1, long var2) {
        EntityVillager var4 = (EntityVillager)var1.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get();
        if (var1.distanceToSqr(var4) > 5.0) {
            return;
        }
        BehaviorUtil.lockGazeAndWalkToEachOther(var1, var4, 0.5f, 2);
        var1.gossip(var0, var4, var2);
        if (var1.hasExcessFood() && (var1.getVillagerData().getProfession() == VillagerProfession.FARMER || var4.wantsMoreFood())) {
            BehaviorTradeVillager.throwHalfStack(var1, EntityVillager.FOOD_POINTS.keySet(), var4);
        }
        if (var4.getVillagerData().getProfession() == VillagerProfession.FARMER && var1.getInventory().countItem(Items.WHEAT) > Items.WHEAT.getDefaultMaxStackSize() / 2) {
            BehaviorTradeVillager.throwHalfStack(var1, (Set<Item>)ImmutableSet.of((Object)Items.WHEAT), var4);
        }
        if (!this.trades.isEmpty() && var1.getInventory().hasAnyOf(this.trades)) {
            BehaviorTradeVillager.throwHalfStack(var1, this.trades, var4);
        }
    }

    @Override
    protected void stop(WorldServer var0, EntityVillager var1, long var2) {
        var1.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
    }

    private static Set<Item> figureOutWhatIAmWillingToTrade(EntityVillager var0, EntityVillager var12) {
        ImmutableSet<Item> var2 = var12.getVillagerData().getProfession().requestedItems();
        ImmutableSet<Item> var3 = var0.getVillagerData().getProfession().requestedItems();
        return var2.stream().filter(var1 -> !var3.contains(var1)).collect(Collectors.toSet());
    }

    private static void throwHalfStack(EntityVillager var0, Set<Item> var1, EntityLiving var2) {
        InventorySubcontainer var3 = var0.getInventory();
        ItemStack var4 = ItemStack.EMPTY;
        for (int var5 = 0; var5 < var3.getContainerSize(); ++var5) {
            int var8;
            Item var7;
            ItemStack var6 = var3.getItem(var5);
            if (var6.isEmpty() || !var1.contains(var7 = var6.getItem())) continue;
            if (var6.getCount() > var6.getMaxStackSize() / 2) {
                var8 = var6.getCount() / 2;
            } else {
                if (var6.getCount() <= 24) continue;
                var8 = var6.getCount() - 24;
            }
            var6.shrink(var8);
            var4 = new ItemStack(var7, var8);
            break;
        }
        if (!var4.isEmpty()) {
            BehaviorUtil.throwItem(var0, var4, var2.position());
        }
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityVillager)entityLiving, l2);
    }
}

