/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityCreature
extends EntityInsentient {
    protected static final float DEFAULT_WALK_TARGET_VALUE = 0.0f;

    protected EntityCreature(EntityTypes<? extends EntityCreature> var0, World var1) {
        super((EntityTypes<? extends EntityInsentient>)var0, var1);
    }

    public float getWalkTargetValue(BlockPosition var0) {
        return this.getWalkTargetValue(var0, this.level());
    }

    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        return 0.0f;
    }

    @Override
    public boolean checkSpawnRules(GeneratorAccess var0, EnumMobSpawn var1) {
        return this.getWalkTargetValue(this.blockPosition(), var0) >= 0.0f;
    }

    public boolean isPathFinding() {
        return !this.getNavigation().isDone();
    }

    public boolean isPanicking() {
        if (this.brain.hasMemoryValue(MemoryModuleType.IS_PANICKING)) {
            return this.brain.getMemory(MemoryModuleType.IS_PANICKING).isPresent();
        }
        for (PathfinderGoalWrapped var1 : this.goalSelector.getAvailableGoals()) {
            if (!var1.isRunning() || !(var1.getGoal() instanceof PathfinderGoalPanic)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldStayCloseToLeashHolder() {
        return true;
    }

    @Override
    public void closeRangeLeashBehaviour(Entity var0) {
        super.closeRangeLeashBehaviour(var0);
        if (this.shouldStayCloseToLeashHolder() && !this.isPanicking()) {
            this.goalSelector.enableControlFlag(PathfinderGoal.Type.MOVE);
            float var1 = 2.0f;
            float var2 = this.distanceTo(var0);
            Vec3D var3 = new Vec3D(var0.getX() - this.getX(), var0.getY() - this.getY(), var0.getZ() - this.getZ()).normalize().scale(Math.max(var2 - 2.0f, 0.0f));
            this.getNavigation().moveTo(this.getX() + var3.x, this.getY() + var3.y, this.getZ() + var3.z, this.followLeashSpeed());
        }
    }

    @Override
    public boolean handleLeashAtDistance(Entity var0, float var1) {
        this.restrictTo(var0.blockPosition(), 5);
        return true;
    }

    protected double followLeashSpeed() {
        return 1.0;
    }
}

