/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.util.VisibleForDebug;
import org.slf4j.Logger;

public abstract class ServerCommonPacketListenerImpl
implements ServerCommonPacketListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int LATENCY_CHECK_INTERVAL = 15000;
    private static final int CLOSED_LISTENER_TIMEOUT = 15000;
    private static final IChatBaseComponent TIMEOUT_DISCONNECTION_MESSAGE = IChatBaseComponent.translatable("disconnect.timeout");
    static final IChatBaseComponent DISCONNECT_UNEXPECTED_QUERY = IChatBaseComponent.translatable("multiplayer.disconnect.unexpected_query_response");
    protected final MinecraftServer server;
    protected final NetworkManager connection;
    private final boolean transferred;
    private long keepAliveTime;
    private boolean keepAlivePending;
    private long keepAliveChallenge;
    private long closedListenerTime;
    private boolean closed = false;
    private int latency;
    private volatile boolean suspendFlushingOnServerThread = false;

    public ServerCommonPacketListenerImpl(MinecraftServer var0, NetworkManager var1, CommonListenerCookie var2) {
        this.server = var0;
        this.connection = var1;
        this.keepAliveTime = SystemUtils.getMillis();
        this.latency = var2.latency();
        this.transferred = var2.transferred();
    }

    private void close() {
        if (!this.closed) {
            this.closedListenerTime = SystemUtils.getMillis();
            this.closed = true;
        }
    }

    @Override
    public void onDisconnect(DisconnectionDetails var0) {
        if (this.isSingleplayerOwner()) {
            LOGGER.info("Stopping singleplayer server as player logged out");
            this.server.halt(false);
        }
    }

    @Override
    public void handleKeepAlive(ServerboundKeepAlivePacket var0) {
        if (this.keepAlivePending && var0.getId() == this.keepAliveChallenge) {
            int var1 = (int)(SystemUtils.getMillis() - this.keepAliveTime);
            this.latency = (this.latency * 3 + var1) / 4;
            this.keepAlivePending = false;
        } else if (!this.isSingleplayerOwner()) {
            this.disconnect(TIMEOUT_DISCONNECTION_MESSAGE);
        }
    }

    @Override
    public void handlePong(ServerboundPongPacket var0) {
    }

    @Override
    public void handleCustomPayload(ServerboundCustomPayloadPacket var0) {
    }

    @Override
    public void handleResourcePackResponse(ServerboundResourcePackPacket var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.server);
        if (var0.action() == ServerboundResourcePackPacket.a.DECLINED && this.server.isResourcePackRequired()) {
            LOGGER.info("Disconnecting {} due to resource pack {} rejection", (Object)this.playerProfile().getName(), (Object)var0.id());
            this.disconnect(IChatBaseComponent.translatable("multiplayer.requiredTexturePrompt.disconnect"));
        }
    }

    @Override
    public void handleCookieResponse(ServerboundCookieResponsePacket var0) {
        this.disconnect(DISCONNECT_UNEXPECTED_QUERY);
    }

    protected void keepConnectionAlive() {
        this.server.getProfiler().push("keepAlive");
        long var0 = SystemUtils.getMillis();
        if (!this.isSingleplayerOwner() && var0 - this.keepAliveTime >= 15000L) {
            if (this.keepAlivePending) {
                this.disconnect(TIMEOUT_DISCONNECTION_MESSAGE);
            } else if (this.checkIfClosed(var0)) {
                this.keepAlivePending = true;
                this.keepAliveTime = var0;
                this.keepAliveChallenge = var0;
                this.send(new ClientboundKeepAlivePacket(this.keepAliveChallenge));
            }
        }
        this.server.getProfiler().pop();
    }

    private boolean checkIfClosed(long var0) {
        if (this.closed) {
            if (var0 - this.closedListenerTime >= 15000L) {
                this.disconnect(TIMEOUT_DISCONNECTION_MESSAGE);
            }
            return false;
        }
        return true;
    }

    public void suspendFlushing() {
        this.suspendFlushingOnServerThread = true;
    }

    public void resumeFlushing() {
        this.suspendFlushingOnServerThread = false;
        this.connection.flushChannel();
    }

    public void send(Packet<?> var0) {
        this.send(var0, null);
    }

    public void send(Packet<?> var0, @Nullable PacketSendListener var1) {
        if (var0.isTerminal()) {
            this.close();
        }
        boolean var2 = !this.suspendFlushingOnServerThread || !this.server.isSameThread();
        try {
            this.connection.send(var0, var1, var2);
        }
        catch (Throwable var3) {
            CrashReport var4 = CrashReport.forThrowable(var3, "Sending packet");
            CrashReportSystemDetails var5 = var4.addCategory("Packet being sent");
            var5.setDetail("Packet class", () -> var0.getClass().getCanonicalName());
            throw new ReportedException(var4);
        }
    }

    public void disconnect(IChatBaseComponent var0) {
        this.disconnect(new DisconnectionDetails(var0));
    }

    public void disconnect(DisconnectionDetails var0) {
        this.connection.send(new ClientboundDisconnectPacket(var0.reason()), PacketSendListener.thenRun(() -> this.connection.disconnect(var0)));
        this.connection.setReadOnly();
        this.server.executeBlocking(this.connection::handleDisconnection);
    }

    protected boolean isSingleplayerOwner() {
        return this.server.isSingleplayerOwner(this.playerProfile());
    }

    protected abstract GameProfile playerProfile();

    @VisibleForDebug
    public GameProfile getOwner() {
        return this.playerProfile();
    }

    public int latency() {
        return this.latency;
    }

    protected CommonListenerCookie createCookie(ClientInformation var0) {
        return new CommonListenerCookie(this.playerProfile(), this.latency, var0, this.transferred);
    }
}

