/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.World;

public class SpawnArmorTrimsCommand {
    private static final Map<Pair<Holder<ArmorMaterial>, EnumItemSlot>, Item> MATERIAL_AND_SLOT_TO_ITEM = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put(Pair.of(EnumArmorMaterial.CHAIN, (Object)EnumItemSlot.HEAD), Items.CHAINMAIL_HELMET);
        var0.put(Pair.of(EnumArmorMaterial.CHAIN, (Object)EnumItemSlot.CHEST), Items.CHAINMAIL_CHESTPLATE);
        var0.put(Pair.of(EnumArmorMaterial.CHAIN, (Object)EnumItemSlot.LEGS), Items.CHAINMAIL_LEGGINGS);
        var0.put(Pair.of(EnumArmorMaterial.CHAIN, (Object)EnumItemSlot.FEET), Items.CHAINMAIL_BOOTS);
        var0.put(Pair.of(EnumArmorMaterial.IRON, (Object)EnumItemSlot.HEAD), Items.IRON_HELMET);
        var0.put(Pair.of(EnumArmorMaterial.IRON, (Object)EnumItemSlot.CHEST), Items.IRON_CHESTPLATE);
        var0.put(Pair.of(EnumArmorMaterial.IRON, (Object)EnumItemSlot.LEGS), Items.IRON_LEGGINGS);
        var0.put(Pair.of(EnumArmorMaterial.IRON, (Object)EnumItemSlot.FEET), Items.IRON_BOOTS);
        var0.put(Pair.of(EnumArmorMaterial.GOLD, (Object)EnumItemSlot.HEAD), Items.GOLDEN_HELMET);
        var0.put(Pair.of(EnumArmorMaterial.GOLD, (Object)EnumItemSlot.CHEST), Items.GOLDEN_CHESTPLATE);
        var0.put(Pair.of(EnumArmorMaterial.GOLD, (Object)EnumItemSlot.LEGS), Items.GOLDEN_LEGGINGS);
        var0.put(Pair.of(EnumArmorMaterial.GOLD, (Object)EnumItemSlot.FEET), Items.GOLDEN_BOOTS);
        var0.put(Pair.of(EnumArmorMaterial.NETHERITE, (Object)EnumItemSlot.HEAD), Items.NETHERITE_HELMET);
        var0.put(Pair.of(EnumArmorMaterial.NETHERITE, (Object)EnumItemSlot.CHEST), Items.NETHERITE_CHESTPLATE);
        var0.put(Pair.of(EnumArmorMaterial.NETHERITE, (Object)EnumItemSlot.LEGS), Items.NETHERITE_LEGGINGS);
        var0.put(Pair.of(EnumArmorMaterial.NETHERITE, (Object)EnumItemSlot.FEET), Items.NETHERITE_BOOTS);
        var0.put(Pair.of(EnumArmorMaterial.DIAMOND, (Object)EnumItemSlot.HEAD), Items.DIAMOND_HELMET);
        var0.put(Pair.of(EnumArmorMaterial.DIAMOND, (Object)EnumItemSlot.CHEST), Items.DIAMOND_CHESTPLATE);
        var0.put(Pair.of(EnumArmorMaterial.DIAMOND, (Object)EnumItemSlot.LEGS), Items.DIAMOND_LEGGINGS);
        var0.put(Pair.of(EnumArmorMaterial.DIAMOND, (Object)EnumItemSlot.FEET), Items.DIAMOND_BOOTS);
        var0.put(Pair.of(EnumArmorMaterial.TURTLE, (Object)EnumItemSlot.HEAD), Items.TURTLE_HELMET);
    });
    private static final List<ResourceKey<TrimPattern>> VANILLA_TRIM_PATTERNS = List.of(TrimPatterns.SENTRY, TrimPatterns.DUNE, TrimPatterns.COAST, TrimPatterns.WILD, TrimPatterns.WARD, TrimPatterns.EYE, TrimPatterns.VEX, TrimPatterns.TIDE, TrimPatterns.SNOUT, TrimPatterns.RIB, TrimPatterns.SPIRE, TrimPatterns.WAYFINDER, TrimPatterns.SHAPER, TrimPatterns.SILENCE, TrimPatterns.RAISER, TrimPatterns.HOST, TrimPatterns.FLOW, TrimPatterns.BOLT);
    private static final List<ResourceKey<TrimMaterial>> VANILLA_TRIM_MATERIALS = List.of(TrimMaterials.QUARTZ, TrimMaterials.IRON, TrimMaterials.NETHERITE, TrimMaterials.REDSTONE, TrimMaterials.COPPER, TrimMaterials.GOLD, TrimMaterials.EMERALD, TrimMaterials.DIAMOND, TrimMaterials.LAPIS, TrimMaterials.AMETHYST);
    private static final ToIntFunction<ResourceKey<TrimPattern>> TRIM_PATTERN_ORDER = SystemUtils.createIndexLookup(VANILLA_TRIM_PATTERNS);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> TRIM_MATERIAL_ORDER = SystemUtils.createIndexLookup(VANILLA_TRIM_MATERIALS);

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("spawn_armor_trims").requires(var0 -> var0.hasPermission(2))).executes(var0 -> SpawnArmorTrimsCommand.spawnArmorTrims((CommandListenerWrapper)var0.getSource(), ((CommandListenerWrapper)var0.getSource()).getPlayerOrException())));
    }

    private static int spawnArmorTrims(CommandListenerWrapper var0, EntityHuman var12) {
        World var2 = var12.level();
        NonNullList<ArmorTrim> var32 = NonNullList.create();
        IRegistry<TrimPattern> var4 = var2.registryAccess().registryOrThrow(Registries.TRIM_PATTERN);
        IRegistry<TrimMaterial> var5 = var2.registryAccess().registryOrThrow(Registries.TRIM_MATERIAL);
        var4.stream().sorted(Comparator.comparing(var1 -> TRIM_PATTERN_ORDER.applyAsInt(var4.getResourceKey((TrimPattern)var1).orElse(null)))).forEachOrdered(var3 -> var5.stream().sorted(Comparator.comparing(var1 -> TRIM_MATERIAL_ORDER.applyAsInt(var5.getResourceKey((TrimMaterial)var1).orElse(null)))).forEachOrdered(var4 -> var32.add(new ArmorTrim(var5.wrapAsHolder((TrimMaterial)var4), var4.wrapAsHolder((TrimPattern)var3)))));
        BlockPosition var6 = var12.blockPosition().relative(var12.getDirection(), 5);
        IRegistry<ArmorMaterial> var7 = var0.registryAccess().registryOrThrow(Registries.ARMOR_MATERIAL);
        int var8 = var7.size() - 1;
        double var9 = 3.0;
        int var11 = 0;
        int var122 = 0;
        for (ArmorTrim var14 : var32) {
            for (ArmorMaterial var16 : var7) {
                if (var16 == EnumArmorMaterial.LEATHER.value()) continue;
                double var17 = (double)var6.getX() + 0.5 - (double)(var11 % var5.size()) * 3.0;
                double var19 = (double)var6.getY() + 0.5 + (double)(var122 % var8) * 3.0;
                double var21 = (double)var6.getZ() + 0.5 + (double)(var11 / var5.size() * 10);
                EntityArmorStand var23 = new EntityArmorStand(var2, var17, var19, var21);
                var23.setYRot(180.0f);
                var23.setNoGravity(true);
                for (EnumItemSlot var27 : EnumItemSlot.values()) {
                    ItemArmor var30;
                    Item var28 = MATERIAL_AND_SLOT_TO_ITEM.get(Pair.of((Object)var16, (Object)var27));
                    if (var28 == null) continue;
                    ItemStack var29 = new ItemStack(var28);
                    var29.set(DataComponents.TRIM, var14);
                    var23.setItemSlot(var27, var29);
                    if (var28 instanceof ItemArmor && (var30 = (ItemArmor)var28).getMaterial().is(EnumArmorMaterial.TURTLE)) {
                        var23.setCustomName(var14.pattern().value().copyWithStyle(var14.material()).copy().append(" ").append(var14.material().value().description()));
                        var23.setCustomNameVisible(true);
                        continue;
                    }
                    var23.setInvisible(true);
                }
                var2.addFreshEntity(var23);
                ++var122;
            }
            ++var11;
        }
        var0.sendSuccess(() -> IChatBaseComponent.literal("Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }
}

