/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutWorldParticles
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutWorldParticles> STREAM_CODEC = Packet.codec(PacketPlayOutWorldParticles::write, PacketPlayOutWorldParticles::new);
    private final double x;
    private final double y;
    private final double z;
    private final float xDist;
    private final float yDist;
    private final float zDist;
    private final float maxSpeed;
    private final int count;
    private final boolean overrideLimiter;
    private final ParticleParam particle;

    public <T extends ParticleParam> PacketPlayOutWorldParticles(T var0, boolean var1, double var2, double var4, double var6, float var8, float var9, float var10, float var11, int var12) {
        this.particle = var0;
        this.overrideLimiter = var1;
        this.x = var2;
        this.y = var4;
        this.z = var6;
        this.xDist = var8;
        this.yDist = var9;
        this.zDist = var10;
        this.maxSpeed = var11;
        this.count = var12;
    }

    private PacketPlayOutWorldParticles(RegistryFriendlyByteBuf var0) {
        this.overrideLimiter = var0.readBoolean();
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.xDist = var0.readFloat();
        this.yDist = var0.readFloat();
        this.zDist = var0.readFloat();
        this.maxSpeed = var0.readFloat();
        this.count = var0.readInt();
        this.particle = (ParticleParam)Particles.STREAM_CODEC.decode(var0);
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeBoolean(this.overrideLimiter);
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeFloat(this.xDist);
        var0.writeFloat(this.yDist);
        var0.writeFloat(this.zDist);
        var0.writeFloat(this.maxSpeed);
        var0.writeInt(this.count);
        Particles.STREAM_CODEC.encode(var0, this.particle);
    }

    @Override
    public PacketType<PacketPlayOutWorldParticles> type() {
        return GamePacketTypes.CLIENTBOUND_LEVEL_PARTICLES;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleParticleEvent(this);
    }

    public boolean isOverrideLimiter() {
        return this.overrideLimiter;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getXDist() {
        return this.xDist;
    }

    public float getYDist() {
        return this.yDist;
    }

    public float getZDist() {
        return this.zDist;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public int getCount() {
        return this.count;
    }

    public ParticleParam getParticle() {
        return this.particle;
    }
}

