/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.EnumDifficulty;

public class PacketPlayOutServerDifficulty
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutServerDifficulty> STREAM_CODEC = Packet.codec(PacketPlayOutServerDifficulty::write, PacketPlayOutServerDifficulty::new);
    private final EnumDifficulty difficulty;
    private final boolean locked;

    public PacketPlayOutServerDifficulty(EnumDifficulty var0, boolean var1) {
        this.difficulty = var0;
        this.locked = var1;
    }

    private PacketPlayOutServerDifficulty(PacketDataSerializer var0) {
        this.difficulty = EnumDifficulty.byId(var0.readUnsignedByte());
        this.locked = var0.readBoolean();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeByte(this.difficulty.getId());
        var0.writeBoolean(this.locked);
    }

    @Override
    public PacketType<PacketPlayOutServerDifficulty> type() {
        return GamePacketTypes.CLIENTBOUND_CHANGE_DIFFICULTY;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleChangeDifficulty(this);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public EnumDifficulty getDifficulty() {
        return this.difficulty;
    }
}

