/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class NbtContents
implements ComponentContents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<NbtContents> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("nbt").forGetter(NbtContents::getNbtPath), (App)Codec.BOOL.lenientOptionalFieldOf("interpret", (Object)false).forGetter(NbtContents::isInterpreting), (App)ComponentSerialization.CODEC.lenientOptionalFieldOf("separator").forGetter(NbtContents::getSeparator), (App)DataSource.CODEC.forGetter(NbtContents::getDataSource)).apply((Applicative)var0, NbtContents::new));
    public static final ComponentContents.a<NbtContents> TYPE = new ComponentContents.a<NbtContents>(CODEC, "nbt");
    private final boolean interpreting;
    private final Optional<IChatBaseComponent> separator;
    private final String nbtPathPattern;
    private final DataSource dataSource;
    @Nullable
    protected final ArgumentNBTKey.g compiledNbtPath;

    public NbtContents(String var0, boolean var1, Optional<IChatBaseComponent> var2, DataSource var3) {
        this(var0, NbtContents.compileNbtPath(var0), var1, var2, var3);
    }

    private NbtContents(String var0, @Nullable ArgumentNBTKey.g var1, boolean var2, Optional<IChatBaseComponent> var3, DataSource var4) {
        this.nbtPathPattern = var0;
        this.compiledNbtPath = var1;
        this.interpreting = var2;
        this.separator = var3;
        this.dataSource = var4;
    }

    @Nullable
    private static ArgumentNBTKey.g compileNbtPath(String var0) {
        try {
            return new ArgumentNBTKey().parse(new StringReader(var0));
        }
        catch (CommandSyntaxException var1) {
            return null;
        }
    }

    public String getNbtPath() {
        return this.nbtPathPattern;
    }

    public boolean isInterpreting() {
        return this.interpreting;
    }

    public Optional<IChatBaseComponent> getSeparator() {
        return this.separator;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof NbtContents)) return false;
        NbtContents var1 = (NbtContents)var0;
        if (!this.dataSource.equals(var1.dataSource)) return false;
        if (!this.separator.equals(var1.separator)) return false;
        if (this.interpreting != var1.interpreting) return false;
        if (!this.nbtPathPattern.equals(var1.nbtPathPattern)) return false;
        return true;
    }

    public int hashCode() {
        int var0 = this.interpreting ? 1 : 0;
        var0 = 31 * var0 + this.separator.hashCode();
        var0 = 31 * var0 + this.nbtPathPattern.hashCode();
        var0 = 31 * var0 + this.dataSource.hashCode();
        return var0;
    }

    public String toString() {
        return "nbt{" + String.valueOf(this.dataSource) + ", interpreting=" + this.interpreting + ", separator=" + String.valueOf(this.separator) + "}";
    }

    @Override
    public IChatMutableComponent resolve(@Nullable CommandListenerWrapper var02, @Nullable Entity var13, int var22) throws CommandSyntaxException {
        if (var02 == null || this.compiledNbtPath == null) {
            return IChatBaseComponent.empty();
        }
        Stream<String> var32 = this.dataSource.getData(var02).flatMap(var0 -> {
            try {
                return this.compiledNbtPath.get((NBTBase)var0).stream();
            }
            catch (CommandSyntaxException var1) {
                return Stream.empty();
            }
        }).map(NBTBase::getAsString);
        if (this.interpreting) {
            IChatBaseComponent var4 = (IChatBaseComponent)DataFixUtils.orElse(ChatComponentUtils.updateForEntity(var02, this.separator, var13, var22), (Object)ChatComponentUtils.DEFAULT_NO_STYLE_SEPARATOR);
            return var32.flatMap(var3 -> {
                try {
                    IChatMutableComponent var4 = IChatBaseComponent.ChatSerializer.fromJson(var3, (HolderLookup.a)var02.registryAccess());
                    return Stream.of(ChatComponentUtils.updateForEntity(var02, var4, var13, var22));
                }
                catch (Exception var4) {
                    LOGGER.warn("Failed to parse component: {}", var3, (Object)var4);
                    return Stream.of(new IChatMutableComponent[0]);
                }
            }).reduce((var1, var2) -> var1.append(var4).append((IChatBaseComponent)var2)).orElseGet(IChatBaseComponent::empty);
        }
        return ChatComponentUtils.updateForEntity(var02, this.separator, var13, var22).map(var12 -> var32.map(IChatBaseComponent::literal).reduce((var1, var2) -> var1.append((IChatBaseComponent)var12).append((IChatBaseComponent)var2)).orElseGet(IChatBaseComponent::empty)).orElseGet(() -> IChatBaseComponent.literal(var32.collect(Collectors.joining(", "))));
    }

    @Override
    public ComponentContents.a<?> type() {
        return TYPE;
    }
}

