/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;

public class ComponentSerialization {
    public static final Codec<IChatBaseComponent> CODEC = Codec.recursive((String)"Component", ComponentSerialization::createCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, IChatBaseComponent> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<IChatBaseComponent>> OPTIONAL_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs::optional);
    public static final StreamCodec<RegistryFriendlyByteBuf, IChatBaseComponent> TRUSTED_STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistriesTrusted(CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<IChatBaseComponent>> TRUSTED_OPTIONAL_STREAM_CODEC = TRUSTED_STREAM_CODEC.apply(ByteBufCodecs::optional);
    public static final StreamCodec<ByteBuf, IChatBaseComponent> TRUSTED_CONTEXT_FREE_STREAM_CODEC = ByteBufCodecs.fromCodecTrusted(CODEC);
    public static final Codec<IChatBaseComponent> FLAT_CODEC = ComponentSerialization.flatCodec(Integer.MAX_VALUE);

    public static Codec<IChatBaseComponent> flatCodec(int var0) {
        final Codec var1 = Codec.string((int)0, (int)var0);
        return new Codec<IChatBaseComponent>(){

            public <T> DataResult<Pair<IChatBaseComponent, T>> decode(DynamicOps<T> var0, T var12) {
                DynamicOps<JsonElement> var2 = 1.asJsonOps(var0);
                return var1.decode(var0, var12).flatMap(var12 -> {
                    try {
                        JsonElement var2 = JsonParser.parseString((String)((String)var12.getFirst()));
                        return CODEC.parse(var2, (Object)var2).map(var1 -> Pair.of((Object)var1, (Object)var12.getSecond()));
                    }
                    catch (JsonParseException var2) {
                        return DataResult.error(var2::getMessage);
                    }
                });
            }

            public <T> DataResult<T> encode(IChatBaseComponent var0, DynamicOps<T> var12, T var22) {
                DynamicOps<JsonElement> var3 = 1.asJsonOps(var12);
                return CODEC.encodeStart(var3, (Object)var0).flatMap(var2 -> {
                    try {
                        return var1.encodeStart(var12, (Object)ChatDeserializer.toStableString(var2));
                    }
                    catch (IllegalArgumentException var3) {
                        return DataResult.error(var3::getMessage);
                    }
                });
            }

            private static <T> DynamicOps<JsonElement> asJsonOps(DynamicOps<T> var0) {
                if (var0 instanceof RegistryOps) {
                    RegistryOps var12 = (RegistryOps)var0;
                    return var12.withParent(JsonOps.INSTANCE);
                }
                return JsonOps.INSTANCE;
            }

            public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                return this.encode((IChatBaseComponent)object, dynamicOps, object2);
            }
        };
    }

    private static IChatMutableComponent createFromList(List<IChatBaseComponent> var0) {
        IChatMutableComponent var1 = var0.get(0).copy();
        for (int var2 = 1; var2 < var0.size(); ++var2) {
            var1.append(var0.get(var2));
        }
        return var1;
    }

    public static <T extends INamable, E> MapCodec<E> createLegacyComponentMatcher(T[] var0, Function<T, MapCodec<? extends E>> var1, Function<E, T> var22, String var3) {
        a<Object> var4 = new a<Object>(Stream.of(var0).map(var1).toList(), var2 -> (MapEncoder)var1.apply((INamable)var22.apply(var2)));
        Codec var5 = INamable.fromValues(() -> var0);
        MapCodec var6 = var5.dispatchMap(var3, var22, var1);
        b<Object> var7 = new b<Object>(var3, var6, var4);
        return ExtraCodecs.orCompressed(var7, var6);
    }

    private static Codec<IChatBaseComponent> createCodec(Codec<IChatBaseComponent> var03) {
        INamable[] var1 = new ComponentContents.a[]{LiteralContents.TYPE, TranslatableContents.TYPE, KeybindContents.TYPE, ScoreContents.TYPE, SelectorContents.TYPE, NbtContents.TYPE};
        MapCodec var22 = ComponentSerialization.createLegacyComponentMatcher((INamable[])var1, ComponentContents.a::codec, ComponentContents::type, (String)"type");
        Codec var3 = RecordCodecBuilder.create(var2 -> var2.group((App)var22.forGetter(IChatBaseComponent::getContents), (App)ExtraCodecs.nonEmptyList(var03.listOf()).optionalFieldOf("extra", List.of()).forGetter(IChatBaseComponent::getSiblings), (App)ChatModifier.ChatModifierSerializer.MAP_CODEC.forGetter(IChatBaseComponent::getStyle)).apply((Applicative)var2, IChatMutableComponent::new));
        return Codec.either((Codec)Codec.either((Codec)Codec.STRING, ExtraCodecs.nonEmptyList(var03.listOf())), (Codec)var3).xmap(var02 -> (IChatBaseComponent)var02.map(var0 -> (IChatBaseComponent)var0.map(IChatBaseComponent::literal, ComponentSerialization::createFromList), var0 -> var0), var0 -> {
            String var1 = var0.tryCollapseToString();
            return var1 != null ? Either.left((Object)Either.left((Object)var1)) : Either.right((Object)var0);
        });
    }

    static class a<T>
    extends MapCodec<T> {
        private final List<MapCodec<? extends T>> codecs;
        private final Function<T, MapEncoder<? extends T>> encoderGetter;

        public a(List<MapCodec<? extends T>> var0, Function<T, MapEncoder<? extends T>> var1) {
            this.codecs = var0;
            this.encoderGetter = var1;
        }

        public <S> DataResult<T> decode(DynamicOps<S> var0, MapLike<S> var1) {
            for (MapDecoder mapDecoder : this.codecs) {
                DataResult var4 = mapDecoder.decode(var0, var1);
                if (!var4.result().isPresent()) continue;
                return var4;
            }
            return DataResult.error(() -> "No matching codec found");
        }

        public <S> RecordBuilder<S> encode(T var0, DynamicOps<S> var1, RecordBuilder<S> var2) {
            MapEncoder<? extends T> var3 = this.encoderGetter.apply(var0);
            return var3.encode(var0, var1, var2);
        }

        public <S> Stream<S> keys(DynamicOps<S> var0) {
            return this.codecs.stream().flatMap(var1 -> var1.keys(var0)).distinct();
        }

        public String toString() {
            return "FuzzyCodec[" + String.valueOf(this.codecs) + "]";
        }
    }

    static class b<T>
    extends MapCodec<T> {
        private final String typeFieldName;
        private final MapCodec<T> typed;
        private final MapCodec<T> fuzzy;

        public b(String var0, MapCodec<T> var1, MapCodec<T> var2) {
            this.typeFieldName = var0;
            this.typed = var1;
            this.fuzzy = var2;
        }

        public <O> DataResult<T> decode(DynamicOps<O> var0, MapLike<O> var1) {
            if (var1.get(this.typeFieldName) != null) {
                return this.typed.decode(var0, var1);
            }
            return this.fuzzy.decode(var0, var1);
        }

        public <O> RecordBuilder<O> encode(T var0, DynamicOps<O> var1, RecordBuilder<O> var2) {
            return this.fuzzy.encode(var0, var1, var2);
        }

        public <T1> Stream<T1> keys(DynamicOps<T1> var0) {
            return Stream.concat(this.typed.keys(var0), this.fuzzy.keys(var0)).distinct();
        }
    }
}

