/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.block.BlockDispenser;

public class DispenseBehaviorProjectile
extends DispenseBehaviorItem {
    private final ProjectileItem projectileItem;
    private final ProjectileItem.a dispenseConfig;

    public DispenseBehaviorProjectile(Item var0) {
        if (!(var0 instanceof ProjectileItem)) {
            throw new IllegalArgumentException(String.valueOf(var0) + " not instance of " + ProjectileItem.class.getSimpleName());
        }
        ProjectileItem var1 = (ProjectileItem)((Object)var0);
        this.projectileItem = var1;
        this.dispenseConfig = var1.createDispenseConfig();
    }

    @Override
    public ItemStack execute(SourceBlock var0, ItemStack var1) {
        WorldServer var2 = var0.level();
        EnumDirection var3 = var0.state().getValue(BlockDispenser.FACING);
        IPosition var4 = this.dispenseConfig.positionFunction().getDispensePosition(var0, var3);
        IProjectile var5 = this.projectileItem.asProjectile(var2, var4, var1, var3);
        this.projectileItem.shoot(var5, var3.getStepX(), var3.getStepY(), var3.getStepZ(), this.dispenseConfig.power(), this.dispenseConfig.uncertainty());
        var2.addFreshEntity(var5);
        var1.shrink(1);
        return var1;
    }

    @Override
    protected void playSound(SourceBlock var0) {
        var0.level().levelEvent(this.dispenseConfig.overrideDispenseEvent().orElse(1002), var0.pos(), 0);
    }
}

