/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;

public class Vector3f {
    public static final StreamCodec<ByteBuf, Vector3f> STREAM_CODEC = new StreamCodec<ByteBuf, Vector3f>(){

        @Override
        public Vector3f decode(ByteBuf var0) {
            return new Vector3f(var0.readFloat(), var0.readFloat(), var0.readFloat());
        }

        @Override
        public void encode(ByteBuf var0, Vector3f var1) {
            var0.writeFloat(var1.x);
            var0.writeFloat(var1.y);
            var0.writeFloat(var1.z);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Vector3f)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    protected final float x;
    protected final float y;
    protected final float z;

    public Vector3f(float var0, float var1, float var2) {
        this.x = Float.isInfinite(var0) || Float.isNaN(var0) ? 0.0f : var0 % 360.0f;
        this.y = Float.isInfinite(var1) || Float.isNaN(var1) ? 0.0f : var1 % 360.0f;
        this.z = Float.isInfinite(var2) || Float.isNaN(var2) ? 0.0f : var2 % 360.0f;
    }

    public Vector3f(NBTTagList var0) {
        this(var0.getFloat(0), var0.getFloat(1), var0.getFloat(2));
    }

    public NBTTagList save() {
        NBTTagList var0 = new NBTTagList();
        var0.add(NBTTagFloat.valueOf(this.x));
        var0.add(NBTTagFloat.valueOf(this.y));
        var0.add(NBTTagFloat.valueOf(this.z));
        return var0;
    }

    public boolean equals(Object var0) {
        if (!(var0 instanceof Vector3f)) {
            return false;
        }
        Vector3f var1 = (Vector3f)var0;
        return this.x == var1.x && this.y == var1.y && this.z == var1.z;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getWrappedX() {
        return MathHelper.wrapDegrees(this.x);
    }

    public float getWrappedY() {
        return MathHelper.wrapDegrees(this.y);
    }

    public float getWrappedZ() {
        return MathHelper.wrapDegrees(this.z);
    }
}

