/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.CollectionContentsPredicate;
import net.minecraft.advancements.critereon.CollectionCountsPredicate;
import net.minecraft.advancements.critereon.CriterionConditionValue;

public record CollectionPredicate<T, P extends Predicate<T>>(Optional<CollectionContentsPredicate<T, P>> contains, Optional<CollectionCountsPredicate<T, P>> counts, Optional<CriterionConditionValue.IntegerRange> size) implements Predicate<Iterable<T>>
{
    public static <T, P extends Predicate<T>> Codec<CollectionPredicate<T, P>> codec(Codec<P> var0) {
        return RecordCodecBuilder.create(var1 -> var1.group((App)CollectionContentsPredicate.codec(var0).optionalFieldOf("contains").forGetter(CollectionPredicate::contains), (App)CollectionCountsPredicate.codec(var0).optionalFieldOf("count").forGetter(CollectionPredicate::counts), (App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("size").forGetter(CollectionPredicate::size)).apply((Applicative)var1, CollectionPredicate::new));
    }

    @Override
    public boolean test(Iterable<T> var0) {
        if (this.contains.isPresent() && !this.contains.get().test(var0)) {
            return false;
        }
        if (this.counts.isPresent() && !this.counts.get().test(var0)) {
            return false;
        }
        return !this.size.isPresent() || this.size.get().matches(Iterables.size(var0));
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((Iterable)object);
    }
}

