/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.ContainerComponentManipulator;
import net.minecraft.world.level.storage.loot.ContainerComponentManipulators;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ModifyContainerContents
extends LootItemFunctionConditional {
    public static final MapCodec<ModifyContainerContents> CODEC = RecordCodecBuilder.mapCodec(var02 -> ModifyContainerContents.commonFields(var02).and(var02.group((App)ContainerComponentManipulators.CODEC.fieldOf("component").forGetter(var0 -> var0.component), (App)LootItemFunctions.ROOT_CODEC.fieldOf("modifier").forGetter(var0 -> var0.modifier))).apply((Applicative)var02, ModifyContainerContents::new));
    private final ContainerComponentManipulator<?> component;
    private final LootItemFunction modifier;

    private ModifyContainerContents(List<LootItemCondition> var0, ContainerComponentManipulator<?> var1, LootItemFunction var2) {
        super(var0);
        this.component = var1;
        this.modifier = var2;
    }

    public LootItemFunctionType<ModifyContainerContents> getType() {
        return LootItemFunctions.MODIFY_CONTENTS;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var12) {
        if (var0.isEmpty()) {
            return var0;
        }
        this.component.modifyItems(var0, var1 -> (ItemStack)this.modifier.apply(var1, var12));
        return var0;
    }

    @Override
    public void validate(LootCollector var0) {
        super.validate(var0);
        this.modifier.validate(var0.forChild(".modifier"));
    }
}

