/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionExplosionDecay
extends LootItemFunctionConditional {
    public static final MapCodec<LootItemFunctionExplosionDecay> CODEC = RecordCodecBuilder.mapCodec(var0 -> LootItemFunctionExplosionDecay.commonFields(var0).apply((Applicative)var0, LootItemFunctionExplosionDecay::new));

    private LootItemFunctionExplosionDecay(List<LootItemCondition> var0) {
        super(var0);
    }

    public LootItemFunctionType<LootItemFunctionExplosionDecay> getType() {
        return LootItemFunctions.EXPLOSION_DECAY;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        Float var2 = var1.getParamOrNull(LootContextParameters.EXPLOSION_RADIUS);
        if (var2 != null) {
            RandomSource var3 = var1.getRandom();
            float var4 = 1.0f / var2.floatValue();
            int var5 = var0.getCount();
            int var6 = 0;
            for (int var7 = 0; var7 < var5; ++var7) {
                if (!(var3.nextFloat() <= var4)) continue;
                ++var6;
            }
            var0.setCount(var6);
        }
        return var0;
    }

    public static LootItemFunctionConditional.a<?> explosionDecay() {
        return LootItemFunctionExplosionDecay.simpleBuilder(LootItemFunctionExplosionDecay::new);
    }
}

