/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;

public class LootItemFunctionExplorationMap
extends LootItemFunctionConditional {
    public static final TagKey<Structure> DEFAULT_DESTINATION = StructureTags.ON_TREASURE_MAPS;
    public static final Holder<MapDecorationType> DEFAULT_DECORATION = MapDecorationTypes.WOODLAND_MANSION;
    public static final byte DEFAULT_ZOOM = 2;
    public static final int DEFAULT_SEARCH_RADIUS = 50;
    public static final boolean DEFAULT_SKIP_EXISTING = true;
    public static final MapCodec<LootItemFunctionExplorationMap> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootItemFunctionExplorationMap.commonFields(var02).and(var02.group((App)TagKey.codec(Registries.STRUCTURE).optionalFieldOf("destination", DEFAULT_DESTINATION).forGetter(var0 -> var0.destination), (App)MapDecorationType.CODEC.optionalFieldOf("decoration", DEFAULT_DECORATION).forGetter(var0 -> var0.mapDecoration), (App)Codec.BYTE.optionalFieldOf("zoom", (Object)2).forGetter(var0 -> var0.zoom), (App)Codec.INT.optionalFieldOf("search_radius", (Object)50).forGetter(var0 -> var0.searchRadius), (App)Codec.BOOL.optionalFieldOf("skip_existing_chunks", (Object)true).forGetter(var0 -> var0.skipKnownStructures))).apply((Applicative)var02, LootItemFunctionExplorationMap::new));
    private final TagKey<Structure> destination;
    private final Holder<MapDecorationType> mapDecoration;
    private final byte zoom;
    private final int searchRadius;
    private final boolean skipKnownStructures;

    LootItemFunctionExplorationMap(List<LootItemCondition> var0, TagKey<Structure> var1, Holder<MapDecorationType> var2, byte var3, int var4, boolean var5) {
        super(var0);
        this.destination = var1;
        this.mapDecoration = var2;
        this.zoom = var3;
        this.searchRadius = var4;
        this.skipKnownStructures = var5;
    }

    public LootItemFunctionType<LootItemFunctionExplorationMap> getType() {
        return LootItemFunctions.EXPLORATION_MAP;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.ORIGIN);
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        WorldServer var3;
        BlockPosition var4;
        if (!var0.is(Items.MAP)) {
            return var0;
        }
        Vec3D var2 = var1.getParamOrNull(LootContextParameters.ORIGIN);
        if (var2 != null && (var4 = (var3 = var1.getLevel()).findNearestMapStructure(this.destination, BlockPosition.containing(var2), this.searchRadius, this.skipKnownStructures)) != null) {
            ItemStack var5 = ItemWorldMap.create(var3, var4.getX(), var4.getZ(), this.zoom, true, true);
            ItemWorldMap.renderBiomePreviewMap(var3, var5);
            WorldMap.addTargetDecoration(var5, var4, "+", this.mapDecoration);
            return var5;
        }
        return var0;
    }

    public static a makeExplorationMap() {
        return new a();
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private TagKey<Structure> destination = DEFAULT_DESTINATION;
        private Holder<MapDecorationType> mapDecoration = DEFAULT_DECORATION;
        private byte zoom = (byte)2;
        private int searchRadius = 50;
        private boolean skipKnownStructures = true;

        @Override
        protected a getThis() {
            return this;
        }

        public a setDestination(TagKey<Structure> var0) {
            this.destination = var0;
            return this;
        }

        public a setMapDecoration(Holder<MapDecorationType> var0) {
            this.mapDecoration = var0;
            return this;
        }

        public a setZoom(byte var0) {
            this.zoom = var0;
            return this;
        }

        public a setSearchRadius(int var0) {
            this.searchRadius = var0;
            return this;
        }

        public a setSkipKnownStructures(boolean var0) {
            this.skipKnownStructures = var0;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionExplorationMap(this.getConditions(), this.destination, this.mapDecoration, this.zoom, this.searchRadius, this.skipKnownStructures);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

