/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapIconBanner;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMapFrame;
import org.slf4j.Logger;

public class WorldMap
extends PersistentBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAP_SIZE = 128;
    private static final int HALF_MAP_SIZE = 64;
    public static final int MAX_SCALE = 4;
    public static final int TRACKED_DECORATION_LIMIT = 256;
    private static final String FRAME_PREFIX = "frame-";
    public int centerX;
    public int centerZ;
    public ResourceKey<World> dimension;
    public boolean trackingPosition;
    public boolean unlimitedTracking;
    public byte scale;
    public byte[] colors = new byte[16384];
    public boolean locked;
    public final List<WorldMapHumanTracker> carriedBy = Lists.newArrayList();
    public final Map<EntityHuman, WorldMapHumanTracker> carriedByPlayers = Maps.newHashMap();
    private final Map<String, MapIconBanner> bannerMarkers = Maps.newHashMap();
    public final Map<String, MapIcon> decorations = Maps.newLinkedHashMap();
    private final Map<String, WorldMapFrame> frameMarkers = Maps.newHashMap();
    private int trackedDecorationCount;

    public static PersistentBase.a<WorldMap> factory() {
        return new PersistentBase.a<WorldMap>(() -> {
            throw new IllegalStateException("Should never create an empty map saved data");
        }, WorldMap::load, DataFixTypes.SAVED_DATA_MAP_DATA);
    }

    private WorldMap(int var0, int var1, byte var2, boolean var3, boolean var4, boolean var5, ResourceKey<World> var6) {
        this.scale = var2;
        this.centerX = var0;
        this.centerZ = var1;
        this.dimension = var6;
        this.trackingPosition = var3;
        this.unlimitedTracking = var4;
        this.locked = var5;
        this.setDirty();
    }

    public static WorldMap createFresh(double var0, double var2, byte var4, boolean var5, boolean var6, ResourceKey<World> var7) {
        int var8 = 128 * (1 << var4);
        int var9 = MathHelper.floor((var0 + 64.0) / (double)var8);
        int var10 = MathHelper.floor((var2 + 64.0) / (double)var8);
        int var11 = var9 * var8 + var8 / 2 - 64;
        int var12 = var10 * var8 + var8 / 2 - 64;
        return new WorldMap(var11, var12, var4, var5, var6, false, var7);
    }

    public static WorldMap createForClient(byte var0, boolean var1, ResourceKey<World> var2) {
        return new WorldMap(0, 0, var0, false, false, var1, var2);
    }

    public static WorldMap load(NBTTagCompound var02, HolderLookup.a var1) {
        ResourceKey var2 = (ResourceKey)DimensionManager.parseLegacy(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get("dimension"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow(() -> new IllegalArgumentException("Invalid map dimension: " + String.valueOf(var02.get("dimension"))));
        int var3 = var02.getInt("xCenter");
        int var4 = var02.getInt("zCenter");
        byte var5 = (byte)MathHelper.clamp(var02.getByte("scale"), 0, 4);
        boolean var6 = !var02.contains("trackingPosition", 1) || var02.getBoolean("trackingPosition");
        boolean var7 = var02.getBoolean("unlimitedTracking");
        boolean var8 = var02.getBoolean("locked");
        WorldMap var9 = new WorldMap(var3, var4, var5, var6, var7, var8, var2);
        byte[] var10 = var02.getByteArray("colors");
        if (var10.length == 16384) {
            var9.colors = var10;
        }
        RegistryOps<NBTBase> var11 = var1.createSerializationContext(DynamicOpsNBT.INSTANCE);
        List var12 = MapIconBanner.LIST_CODEC.parse(var11, (Object)var02.get("banners")).resultOrPartial(var0 -> LOGGER.warn("Failed to parse map banner: '{}'", var0)).orElse(List.of());
        for (MapIconBanner var14 : var12) {
            var9.bannerMarkers.put(var14.getId(), var14);
            var9.addDecoration(var14.getDecoration(), null, var14.getId(), var14.pos().getX(), var14.pos().getZ(), 180.0, var14.name().orElse(null));
        }
        NBTTagList var13 = var02.getList("frames", 10);
        for (int var14 = 0; var14 < var13.size(); ++var14) {
            WorldMapFrame var15 = WorldMapFrame.load(var13.getCompound(var14));
            if (var15 == null) continue;
            var9.frameMarkers.put(var15.getId(), var15);
            var9.addDecoration(MapDecorationTypes.FRAME, null, WorldMap.getFrameKey(var15.getEntityId()), var15.getPos().getX(), var15.getPos().getZ(), var15.getRotation(), null);
        }
        return var9;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound var0, HolderLookup.a var12) {
        MinecraftKey.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.dimension.location()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("dimension", (NBTBase)var1));
        var0.putInt("xCenter", this.centerX);
        var0.putInt("zCenter", this.centerZ);
        var0.putByte("scale", this.scale);
        var0.putByteArray("colors", this.colors);
        var0.putBoolean("trackingPosition", this.trackingPosition);
        var0.putBoolean("unlimitedTracking", this.unlimitedTracking);
        var0.putBoolean("locked", this.locked);
        RegistryOps<NBTBase> var2 = var12.createSerializationContext(DynamicOpsNBT.INSTANCE);
        var0.put("banners", (NBTBase)MapIconBanner.LIST_CODEC.encodeStart(var2, List.copyOf(this.bannerMarkers.values())).getOrThrow());
        NBTTagList var3 = new NBTTagList();
        for (WorldMapFrame var5 : this.frameMarkers.values()) {
            var3.add(var5.save());
        }
        var0.put("frames", var3);
        return var0;
    }

    public WorldMap locked() {
        WorldMap var0 = new WorldMap(this.centerX, this.centerZ, this.scale, this.trackingPosition, this.unlimitedTracking, true, this.dimension);
        var0.bannerMarkers.putAll(this.bannerMarkers);
        var0.decorations.putAll(this.decorations);
        var0.trackedDecorationCount = this.trackedDecorationCount;
        System.arraycopy(this.colors, 0, var0.colors, 0, this.colors.length);
        var0.setDirty();
        return var0;
    }

    public WorldMap scaled() {
        return WorldMap.createFresh(this.centerX, this.centerZ, (byte)MathHelper.clamp(this.scale + 1, 0, 4), this.trackingPosition, this.unlimitedTracking, this.dimension);
    }

    private static Predicate<ItemStack> mapMatcher(ItemStack var0) {
        MapId var1 = var0.get(DataComponents.MAP_ID);
        return var2 -> {
            if (var2 == var0) {
                return true;
            }
            return var2.is(var0.getItem()) && Objects.equals(var1, var2.get(DataComponents.MAP_ID));
        };
    }

    public void tickCarriedBy(EntityHuman var0, ItemStack var12) {
        Object var5;
        Object var4;
        Object var22;
        if (!this.carriedByPlayers.containsKey(var0)) {
            var22 = new WorldMapHumanTracker(var0);
            this.carriedByPlayers.put(var0, (WorldMapHumanTracker)var22);
            this.carriedBy.add((WorldMapHumanTracker)var22);
        }
        var22 = WorldMap.mapMatcher(var12);
        if (!var0.getInventory().contains((Predicate<ItemStack>)var22)) {
            this.removeDecoration(var0.getName().getString());
        }
        for (int var3 = 0; var3 < this.carriedBy.size(); ++var3) {
            var4 = this.carriedBy.get(var3);
            var5 = ((WorldMapHumanTracker)var4).player.getName().getString();
            if (((WorldMapHumanTracker)var4).player.isRemoved() || !((WorldMapHumanTracker)var4).player.getInventory().contains((Predicate<ItemStack>)var22) && !var12.isFramed()) {
                this.carriedByPlayers.remove(((WorldMapHumanTracker)var4).player);
                this.carriedBy.remove(var4);
                this.removeDecoration((String)var5);
                continue;
            }
            if (var12.isFramed() || ((WorldMapHumanTracker)var4).player.level().dimension() != this.dimension || !this.trackingPosition) continue;
            this.addDecoration(MapDecorationTypes.PLAYER, ((WorldMapHumanTracker)var4).player.level(), (String)var5, ((WorldMapHumanTracker)var4).player.getX(), ((WorldMapHumanTracker)var4).player.getZ(), ((WorldMapHumanTracker)var4).player.getYRot(), null);
        }
        if (var12.isFramed() && this.trackingPosition) {
            EntityItemFrame var3 = var12.getFrame();
            var4 = var3.getPos();
            var5 = this.frameMarkers.get(WorldMapFrame.frameId((BlockPosition)var4));
            if (var5 != null && var3.getId() != ((WorldMapFrame)var5).getEntityId() && this.frameMarkers.containsKey(((WorldMapFrame)var5).getId())) {
                this.removeDecoration(WorldMap.getFrameKey(((WorldMapFrame)var5).getEntityId()));
            }
            WorldMapFrame var6 = new WorldMapFrame((BlockPosition)var4, var3.getDirection().get2DDataValue() * 90, var3.getId());
            this.addDecoration(MapDecorationTypes.FRAME, var0.level(), WorldMap.getFrameKey(var3.getId()), ((BaseBlockPosition)var4).getX(), ((BaseBlockPosition)var4).getZ(), var3.getDirection().get2DDataValue() * 90, null);
            this.frameMarkers.put(var6.getId(), var6);
        }
        MapDecorations var3 = var12.getOrDefault(DataComponents.MAP_DECORATIONS, MapDecorations.EMPTY);
        if (!this.decorations.keySet().containsAll(var3.decorations().keySet())) {
            var3.decorations().forEach((var1, var2) -> {
                if (!this.decorations.containsKey(var1)) {
                    this.addDecoration(var2.type(), var0.level(), (String)var1, var2.x(), var2.z(), var2.rotation(), null);
                }
            });
        }
    }

    private void removeDecoration(String var0) {
        MapIcon var1 = this.decorations.remove(var0);
        if (var1 != null && var1.type().value().trackCount()) {
            --this.trackedDecorationCount;
        }
        this.setDecorationsDirty();
    }

    public static void addTargetDecoration(ItemStack var0, BlockPosition var1, String var22, Holder<MapDecorationType> var3) {
        MapDecorations.a var4 = new MapDecorations.a(var3, var1.getX(), var1.getZ(), 180.0f);
        var0.update(DataComponents.MAP_DECORATIONS, MapDecorations.EMPTY, var2 -> var2.withDecoration(var22, var4));
        if (var3.value().hasMapColor()) {
            var0.set(DataComponents.MAP_COLOR, new MapItemColor(var3.value().mapColor()));
        }
    }

    private void addDecoration(Holder<MapDecorationType> var0, @Nullable GeneratorAccess var1, String var2, double var3, double var5, double var7, @Nullable IChatBaseComponent var9) {
        MapIcon var18;
        MapIcon var17;
        byte var15;
        int var10 = 1 << this.scale;
        float var11 = (float)(var3 - (double)this.centerX) / (float)var10;
        float var12 = (float)(var5 - (double)this.centerZ) / (float)var10;
        byte var13 = (byte)((double)(var11 * 2.0f) + 0.5);
        byte var14 = (byte)((double)(var12 * 2.0f) + 0.5);
        int var16 = 63;
        if (var11 >= -63.0f && var12 >= -63.0f && var11 <= 63.0f && var12 <= 63.0f) {
            var15 = (byte)((var7 += var7 < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.dimension == World.NETHER && var1 != null) {
                var17 = (int)(var1.getLevelData().getDayTime() / 10L);
                var15 = (byte)(var17 * var17 * 34187121 + var17 * 121 >> 15 & 0xF);
            }
        } else if (var0.is(MapDecorationTypes.PLAYER)) {
            var17 = 320;
            if (Math.abs(var11) < 320.0f && Math.abs(var12) < 320.0f) {
                var0 = MapDecorationTypes.PLAYER_OFF_MAP;
            } else if (this.unlimitedTracking) {
                var0 = MapDecorationTypes.PLAYER_OFF_LIMITS;
            } else {
                this.removeDecoration(var2);
                return;
            }
            var15 = 0;
            if (var11 <= -63.0f) {
                var13 = -128;
            }
            if (var12 <= -63.0f) {
                var14 = -128;
            }
            if (var11 >= 63.0f) {
                var13 = 127;
            }
            if (var12 >= 63.0f) {
                var14 = 127;
            }
        } else {
            this.removeDecoration(var2);
            return;
        }
        if (!(var17 = new MapIcon(var0, var13, var14, var15, Optional.ofNullable(var9))).equals(var18 = this.decorations.put(var2, var17))) {
            if (var18 != null && var18.type().value().trackCount()) {
                --this.trackedDecorationCount;
            }
            if (var0.value().trackCount()) {
                ++this.trackedDecorationCount;
            }
            this.setDecorationsDirty();
        }
    }

    @Nullable
    public Packet<?> getUpdatePacket(MapId var0, EntityHuman var1) {
        WorldMapHumanTracker var2 = this.carriedByPlayers.get(var1);
        if (var2 == null) {
            return null;
        }
        return var2.nextUpdatePacket(var0);
    }

    public void setColorsDirty(int var0, int var1) {
        this.setDirty();
        for (WorldMapHumanTracker var3 : this.carriedBy) {
            var3.markColorsDirty(var0, var1);
        }
    }

    public void setDecorationsDirty() {
        this.setDirty();
        this.carriedBy.forEach(WorldMapHumanTracker::markDecorationsDirty);
    }

    public WorldMapHumanTracker getHoldingPlayer(EntityHuman var0) {
        WorldMapHumanTracker var1 = this.carriedByPlayers.get(var0);
        if (var1 == null) {
            var1 = new WorldMapHumanTracker(var0);
            this.carriedByPlayers.put(var0, var1);
            this.carriedBy.add(var1);
        }
        return var1;
    }

    public boolean toggleBanner(GeneratorAccess var0, BlockPosition var1) {
        double var2 = (double)var1.getX() + 0.5;
        double var4 = (double)var1.getZ() + 0.5;
        int var6 = 1 << this.scale;
        double var7 = (var2 - (double)this.centerX) / (double)var6;
        double var9 = (var4 - (double)this.centerZ) / (double)var6;
        int var11 = 63;
        if (var7 >= -63.0 && var9 >= -63.0 && var7 <= 63.0 && var9 <= 63.0) {
            MapIconBanner var12 = MapIconBanner.fromWorld(var0, var1);
            if (var12 == null) {
                return false;
            }
            if (this.bannerMarkers.remove(var12.getId(), var12)) {
                this.removeDecoration(var12.getId());
                return true;
            }
            if (!this.isTrackedCountOverLimit(256)) {
                this.bannerMarkers.put(var12.getId(), var12);
                this.addDecoration(var12.getDecoration(), var0, var12.getId(), var2, var4, 180.0, var12.name().orElse(null));
                return true;
            }
        }
        return false;
    }

    public void checkBanners(IBlockAccess var0, int var1, int var2) {
        Iterator<MapIconBanner> var3 = this.bannerMarkers.values().iterator();
        while (var3.hasNext()) {
            MapIconBanner var5;
            MapIconBanner var4 = var3.next();
            if (var4.pos().getX() != var1 || var4.pos().getZ() != var2 || var4.equals(var5 = MapIconBanner.fromWorld(var0, var4.pos()))) continue;
            var3.remove();
            this.removeDecoration(var4.getId());
        }
    }

    public Collection<MapIconBanner> getBanners() {
        return this.bannerMarkers.values();
    }

    public void removedFromFrame(BlockPosition var0, int var1) {
        this.removeDecoration(WorldMap.getFrameKey(var1));
        this.frameMarkers.remove(WorldMapFrame.frameId(var0));
    }

    public boolean updateColor(int var0, int var1, byte var2) {
        byte var3 = this.colors[var0 + var1 * 128];
        if (var3 != var2) {
            this.setColor(var0, var1, var2);
            return true;
        }
        return false;
    }

    public void setColor(int var0, int var1, byte var2) {
        this.colors[var0 + var1 * 128] = var2;
        this.setColorsDirty(var0, var1);
    }

    public boolean isExplorationMap() {
        for (MapIcon var1 : this.decorations.values()) {
            if (!var1.type().value().explorationMapElement()) continue;
            return true;
        }
        return false;
    }

    public void addClientSideDecorations(List<MapIcon> var0) {
        this.decorations.clear();
        this.trackedDecorationCount = 0;
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            MapIcon var2 = var0.get(var1);
            this.decorations.put("icon-" + var1, var2);
            if (!var2.type().value().trackCount()) continue;
            ++this.trackedDecorationCount;
        }
    }

    public Iterable<MapIcon> getDecorations() {
        return this.decorations.values();
    }

    public boolean isTrackedCountOverLimit(int var0) {
        return this.trackedDecorationCount >= var0;
    }

    private static String getFrameKey(int var0) {
        return FRAME_PREFIX + var0;
    }

    public class WorldMapHumanTracker {
        public final EntityHuman player;
        private boolean dirtyData = true;
        private int minDirtyX;
        private int minDirtyY;
        private int maxDirtyX = 127;
        private int maxDirtyY = 127;
        private boolean dirtyDecorations = true;
        private int tick;
        public int step;

        WorldMapHumanTracker(EntityHuman var1) {
            this.player = var1;
        }

        private b createPatch() {
            int var0 = this.minDirtyX;
            int var1 = this.minDirtyY;
            int var2 = this.maxDirtyX + 1 - this.minDirtyX;
            int var3 = this.maxDirtyY + 1 - this.minDirtyY;
            byte[] var4 = new byte[var2 * var3];
            for (int var5 = 0; var5 < var2; ++var5) {
                for (int var6 = 0; var6 < var3; ++var6) {
                    var4[var5 + var6 * var2] = WorldMap.this.colors[var0 + var5 + (var1 + var6) * 128];
                }
            }
            return new b(var0, var1, var2, var3, var4);
        }

        @Nullable
        Packet<?> nextUpdatePacket(MapId var0) {
            Collection<MapIcon> var2;
            b var1;
            if (this.dirtyData) {
                this.dirtyData = false;
                var1 = this.createPatch();
            } else {
                var1 = null;
            }
            if (this.dirtyDecorations && this.tick++ % 5 == 0) {
                this.dirtyDecorations = false;
                var2 = WorldMap.this.decorations.values();
            } else {
                var2 = null;
            }
            if (var2 != null || var1 != null) {
                return new PacketPlayOutMap(var0, WorldMap.this.scale, WorldMap.this.locked, var2, var1);
            }
            return null;
        }

        void markColorsDirty(int var0, int var1) {
            if (this.dirtyData) {
                this.minDirtyX = Math.min(this.minDirtyX, var0);
                this.minDirtyY = Math.min(this.minDirtyY, var1);
                this.maxDirtyX = Math.max(this.maxDirtyX, var0);
                this.maxDirtyY = Math.max(this.maxDirtyY, var1);
            } else {
                this.dirtyData = true;
                this.minDirtyX = var0;
                this.minDirtyY = var1;
                this.maxDirtyX = var0;
                this.maxDirtyY = var1;
            }
        }

        private void markDecorationsDirty() {
            this.dirtyDecorations = true;
        }
    }

    public record b(int startX, int startY, int width, int height, byte[] mapColors) {
        public static final StreamCodec<ByteBuf, Optional<b>> STREAM_CODEC = StreamCodec.of(b::write, b::read);

        private static void write(ByteBuf var0, Optional<b> var1) {
            if (var1.isPresent()) {
                b var2 = var1.get();
                var0.writeByte(var2.width);
                var0.writeByte(var2.height);
                var0.writeByte(var2.startX);
                var0.writeByte(var2.startY);
                PacketDataSerializer.writeByteArray(var0, var2.mapColors);
            } else {
                var0.writeByte(0);
            }
        }

        private static Optional<b> read(ByteBuf var0) {
            short var1 = var0.readUnsignedByte();
            if (var1 > 0) {
                short var2 = var0.readUnsignedByte();
                short var3 = var0.readUnsignedByte();
                short var4 = var0.readUnsignedByte();
                byte[] var5 = PacketDataSerializer.readByteArray(var0);
                return Optional.of(new b(var3, var4, var1, var2, var5));
            }
            return Optional.empty();
        }

        public void applyToMap(WorldMap var0) {
            for (int var1 = 0; var1 < this.width; ++var1) {
                for (int var2 = 0; var2 < this.height; ++var2) {
                    var0.setColor(this.startX + var1, this.startY + var2, this.mapColors[var1 + var2 * this.width]);
                }
            }
        }
    }
}

