/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.HashCommon;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import org.jetbrains.annotations.Nullable;

public class PathTypeCache {
    private static final int SIZE = 4096;
    private static final int MASK = 4095;
    private final long[] positions = new long[4096];
    private final PathType[] pathTypes = new PathType[4096];

    public PathType getOrCompute(IBlockAccess var0, BlockPosition var1) {
        long var2 = var1.asLong();
        int var4 = PathTypeCache.index(var2);
        PathType var5 = this.get(var4, var2);
        if (var5 != null) {
            return var5;
        }
        return this.compute(var0, var1, var4, var2);
    }

    @Nullable
    private PathType get(int var0, long var1) {
        if (this.positions[var0] == var1) {
            return this.pathTypes[var0];
        }
        return null;
    }

    private PathType compute(IBlockAccess var0, BlockPosition var1, int var2, long var3) {
        PathType var5 = PathfinderNormal.getPathTypeFromState(var0, var1);
        this.positions[var2] = var3;
        this.pathTypes[var2] = var5;
        return var5;
    }

    public void invalidate(BlockPosition var0) {
        long var1 = var0.asLong();
        int var3 = PathTypeCache.index(var1);
        if (this.positions[var3] == var1) {
            this.pathTypes[var3] = null;
        }
    }

    private static int index(long var0) {
        return (int)HashCommon.mix((long)var0) & 0xFFF;
    }
}

