/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public final class JigsawStructure
extends Structure {
    public static final DimensionPadding DEFAULT_DIMENSION_PADDING = DimensionPadding.ZERO;
    public static final LiquidSettings DEFAULT_LIQUID_SETTINGS = LiquidSettings.APPLY_WATERLOGGING;
    public static final int MAX_TOTAL_STRUCTURE_RANGE = 128;
    public static final int MIN_DEPTH = 0;
    public static final int MAX_DEPTH = 20;
    public static final MapCodec<JigsawStructure> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group(JigsawStructure.settingsCodec(var02), (App)WorldGenFeatureDefinedStructurePoolTemplate.CODEC.fieldOf("start_pool").forGetter(var0 -> var0.startPool), (App)MinecraftKey.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(var0 -> var0.startJigsawName), (App)Codec.intRange((int)0, (int)20).fieldOf("size").forGetter(var0 -> var0.maxDepth), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(var0 -> var0.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(var0 -> var0.useExpansionHack), (App)HeightMap.Type.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(var0 -> var0.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(var0 -> var0.maxDistanceFromCenter), (App)Codec.list(PoolAliasBinding.CODEC).optionalFieldOf("pool_aliases", List.of()).forGetter(var0 -> var0.poolAliases), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)DEFAULT_DIMENSION_PADDING).forGetter(var0 -> var0.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)DEFAULT_LIQUID_SETTINGS).forGetter(var0 -> var0.liquidSettings)).apply((Applicative)var02, JigsawStructure::new)).validate(JigsawStructure::verifyRange);
    private final Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool;
    private final Optional<MinecraftKey> startJigsawName;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final boolean useExpansionHack;
    private final Optional<HeightMap.Type> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final List<PoolAliasBinding> poolAliases;
    private final DimensionPadding dimensionPadding;
    private final LiquidSettings liquidSettings;

    private static DataResult<JigsawStructure> verifyRange(JigsawStructure var0) {
        int var1;
        switch (var0.terrainAdaptation()) {
            default: {
                throw new MatchException(null, null);
            }
            case NONE: {
                int n2 = 0;
                break;
            }
            case BURY: 
            case BEARD_THIN: 
            case BEARD_BOX: 
            case ENCAPSULATE: {
                int n2 = var1 = 12;
            }
        }
        if (var0.maxDistanceFromCenter + var1 > 128) {
            return DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128");
        }
        return DataResult.success((Object)var0);
    }

    public JigsawStructure(Structure.c var0, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, Optional<MinecraftKey> var2, int var3, HeightProvider var4, boolean var5, Optional<HeightMap.Type> var6, int var7, List<PoolAliasBinding> var8, DimensionPadding var9, LiquidSettings var10) {
        super(var0);
        this.startPool = var1;
        this.startJigsawName = var2;
        this.maxDepth = var3;
        this.startHeight = var4;
        this.useExpansionHack = var5;
        this.projectStartToHeightmap = var6;
        this.maxDistanceFromCenter = var7;
        this.poolAliases = var8;
        this.dimensionPadding = var9;
        this.liquidSettings = var10;
    }

    public JigsawStructure(Structure.c var0, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, int var2, HeightProvider var3, boolean var4, HeightMap.Type var5) {
        this(var0, var1, Optional.empty(), var2, var3, var4, Optional.of(var5), 80, List.of(), DEFAULT_DIMENSION_PADDING, DEFAULT_LIQUID_SETTINGS);
    }

    public JigsawStructure(Structure.c var0, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, int var2, HeightProvider var3, boolean var4) {
        this(var0, var1, Optional.empty(), var2, var3, var4, Optional.empty(), 80, List.of(), DEFAULT_DIMENSION_PADDING, DEFAULT_LIQUID_SETTINGS);
    }

    @Override
    public Optional<Structure.b> findGenerationPoint(Structure.a var0) {
        ChunkCoordIntPair var1 = var0.chunkPos();
        int var2 = this.startHeight.sample(var0.random(), new WorldGenerationContext(var0.chunkGenerator(), var0.heightAccessor()));
        BlockPosition var3 = new BlockPosition(var1.getMinBlockX(), var2, var1.getMinBlockZ());
        return WorldGenFeatureDefinedStructureJigsawPlacement.addPieces(var0, this.startPool, this.startJigsawName, this.maxDepth, var3, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter, PoolAliasLookup.create(this.poolAliases, var3, var0.seed()), this.dimensionPadding, this.liquidSettings);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.JIGSAW;
    }
}

