/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public final class RandomState {
    final PositionalRandomFactory random;
    private final HolderGetter<NoiseGeneratorNormal.a> noises;
    private final NoiseRouter router;
    private final Climate.Sampler sampler;
    private final SurfaceSystem surfaceSystem;
    private final PositionalRandomFactory aquiferRandom;
    private final PositionalRandomFactory oreRandom;
    private final Map<ResourceKey<NoiseGeneratorNormal.a>, NoiseGeneratorNormal> noiseIntances;
    private final Map<MinecraftKey, PositionalRandomFactory> positionalRandoms;

    public static RandomState create(HolderGetter.a var0, ResourceKey<GeneratorSettingBase> var1, long var2) {
        return RandomState.create(var0.lookupOrThrow(Registries.NOISE_SETTINGS).getOrThrow(var1).value(), var0.lookupOrThrow(Registries.NOISE), var2);
    }

    public static RandomState create(GeneratorSettingBase var0, HolderGetter<NoiseGeneratorNormal.a> var1, long var2) {
        return new RandomState(var0, var1, var2);
    }

    private RandomState(GeneratorSettingBase var0, HolderGetter<NoiseGeneratorNormal.a> var1, long var2) {
        this.random = var0.getRandomSource().newInstance(var2).forkPositional();
        this.noises = var1;
        this.aquiferRandom = this.random.fromHashOf(MinecraftKey.withDefaultNamespace("aquifer")).forkPositional();
        this.oreRandom = this.random.fromHashOf(MinecraftKey.withDefaultNamespace("ore")).forkPositional();
        this.noiseIntances = new ConcurrentHashMap<ResourceKey<NoiseGeneratorNormal.a>, NoiseGeneratorNormal>();
        this.positionalRandoms = new ConcurrentHashMap<MinecraftKey, PositionalRandomFactory>();
        this.surfaceSystem = new SurfaceSystem(this, var0.defaultBlock(), var0.seaLevel(), this.random);
        boolean var4 = var0.useLegacyRandomSource();
        class A
        implements DensityFunction.f {
            private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();
            final /* synthetic */ long a;
            final /* synthetic */ boolean b;

            A(long l2, boolean bl) {
                this.a = l2;
                this.b = bl;
            }

            private RandomSource newLegacyInstance(long var0) {
                return new LegacyRandomSource(this.a + var0);
            }

            @Override
            public DensityFunction.c visitNoise(DensityFunction.c var0) {
                Holder<NoiseGeneratorNormal.a> var1 = var0.noiseData();
                if (this.b) {
                    if (var1.is(Noises.TEMPERATURE)) {
                        NoiseGeneratorNormal var2 = NoiseGeneratorNormal.createLegacyNetherBiome(this.newLegacyInstance(0L), new NoiseGeneratorNormal.a(-7, 1.0, 1.0));
                        return new DensityFunction.c(var1, var2);
                    }
                    if (var1.is(Noises.VEGETATION)) {
                        NoiseGeneratorNormal var2 = NoiseGeneratorNormal.createLegacyNetherBiome(this.newLegacyInstance(1L), new NoiseGeneratorNormal.a(-7, 1.0, 1.0));
                        return new DensityFunction.c(var1, var2);
                    }
                    if (var1.is(Noises.SHIFT)) {
                        NoiseGeneratorNormal var2 = NoiseGeneratorNormal.create(RandomState.this.random.fromHashOf(Noises.SHIFT.location()), new NoiseGeneratorNormal.a(0, 0.0, new double[0]));
                        return new DensityFunction.c(var1, var2);
                    }
                }
                NoiseGeneratorNormal var2 = RandomState.this.getOrCreateNoise(var1.unwrapKey().orElseThrow());
                return new DensityFunction.c(var1, var2);
            }

            private DensityFunction wrapNew(DensityFunction var0) {
                if (var0 instanceof BlendedNoise) {
                    BlendedNoise var1 = (BlendedNoise)var0;
                    RandomSource var2 = this.b ? this.newLegacyInstance(0L) : RandomState.this.random.fromHashOf(MinecraftKey.withDefaultNamespace("terrain"));
                    return var1.withNewRandom(var2);
                }
                if (var0 instanceof DensityFunctions.i) {
                    return new DensityFunctions.i(this.a);
                }
                return var0;
            }

            @Override
            public DensityFunction apply(DensityFunction var0) {
                return this.wrapped.computeIfAbsent(var0, this::wrapNew);
            }
        }
        this.router = var0.noiseRouter().mapAll(new A(var2, var4));
        DensityFunction.f var5 = new DensityFunction.f(this){
            private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();

            private DensityFunction wrapNew(DensityFunction var0) {
                if (var0 instanceof DensityFunctions.j) {
                    DensityFunctions.j var1 = (DensityFunctions.j)var0;
                    return var1.function().value();
                }
                if (var0 instanceof DensityFunctions.l) {
                    DensityFunctions.l var1 = (DensityFunctions.l)var0;
                    return var1.wrapped();
                }
                return var0;
            }

            @Override
            public DensityFunction apply(DensityFunction var0) {
                return this.wrapped.computeIfAbsent(var0, this::wrapNew);
            }
        };
        this.sampler = new Climate.Sampler(this.router.temperature().mapAll(var5), this.router.vegetation().mapAll(var5), this.router.continents().mapAll(var5), this.router.erosion().mapAll(var5), this.router.depth().mapAll(var5), this.router.ridges().mapAll(var5), var0.spawnTarget());
    }

    public NoiseGeneratorNormal getOrCreateNoise(ResourceKey<NoiseGeneratorNormal.a> var0) {
        return this.noiseIntances.computeIfAbsent(var0, var1 -> Noises.instantiate(this.noises, this.random, var0));
    }

    public PositionalRandomFactory getOrCreateRandomFactory(MinecraftKey var0) {
        return this.positionalRandoms.computeIfAbsent(var0, var1 -> this.random.fromHashOf(var0).forkPositional());
    }

    public NoiseRouter router() {
        return this.router;
    }

    public Climate.Sampler sampler() {
        return this.sampler;
    }

    public SurfaceSystem surfaceSystem() {
        return this.surfaceSystem;
    }

    public PositionalRandomFactory aquiferRandom() {
        return this.aquiferRandom;
    }

    public PositionalRandomFactory oreRandom() {
        return this.oreRandom;
    }
}

