/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.WorldChunkManagerHell;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;

public class ChunkProviderDebug
extends ChunkGenerator {
    public static final MapCodec<ChunkProviderDebug> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group(RegistryOps.retrieveElement(Biomes.PLAINS)).apply((Applicative)var0, var0.stable(ChunkProviderDebug::new)));
    private static final int BLOCK_MARGIN = 2;
    private static final List<IBlockData> ALL_BLOCKS = StreamSupport.stream(BuiltInRegistries.BLOCK.spliterator(), false).flatMap(var0 -> var0.getStateDefinition().getPossibleStates().stream()).collect(Collectors.toList());
    private static final int GRID_WIDTH = MathHelper.ceil(MathHelper.sqrt(ALL_BLOCKS.size()));
    private static final int GRID_HEIGHT = MathHelper.ceil((float)ALL_BLOCKS.size() / (float)GRID_WIDTH);
    protected static final IBlockData AIR = Blocks.AIR.defaultBlockState();
    protected static final IBlockData BARRIER = Blocks.BARRIER.defaultBlockState();
    public static final int HEIGHT = 70;
    public static final int BARRIER_HEIGHT = 60;

    public ChunkProviderDebug(Holder.c<BiomeBase> var0) {
        super(new WorldChunkManagerHell(var0));
    }

    @Override
    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    @Override
    public void buildSurface(RegionLimitedWorldAccess var0, StructureManager var1, RandomState var2, IChunkAccess var3) {
    }

    @Override
    public void applyBiomeDecoration(GeneratorAccessSeed var0, IChunkAccess var1, StructureManager var2) {
        BlockPosition.MutableBlockPosition var3 = new BlockPosition.MutableBlockPosition();
        ChunkCoordIntPair var4 = var1.getPos();
        int var5 = var4.x;
        int var6 = var4.z;
        for (int var7 = 0; var7 < 16; ++var7) {
            for (int var8 = 0; var8 < 16; ++var8) {
                int var9 = SectionPosition.sectionToBlockCoord(var5, var7);
                int var10 = SectionPosition.sectionToBlockCoord(var6, var8);
                var0.setBlock(var3.set(var9, 60, var10), BARRIER, 2);
                IBlockData var11 = ChunkProviderDebug.getBlockStateFor(var9, var10);
                var0.setBlock(var3.set(var9, 70, var10), var11, 2);
            }
        }
    }

    @Override
    public CompletableFuture<IChunkAccess> fillFromNoise(Blender var0, RandomState var1, StructureManager var2, IChunkAccess var3) {
        return CompletableFuture.completedFuture(var3);
    }

    @Override
    public int getBaseHeight(int var0, int var1, HeightMap.Type var2, LevelHeightAccessor var3, RandomState var4) {
        return 0;
    }

    @Override
    public BlockColumn getBaseColumn(int var0, int var1, LevelHeightAccessor var2, RandomState var3) {
        return new BlockColumn(0, new IBlockData[0]);
    }

    @Override
    public void addDebugScreenInfo(List<String> var0, RandomState var1, BlockPosition var2) {
    }

    public static IBlockData getBlockStateFor(int var0, int var1) {
        int var3;
        IBlockData var2 = AIR;
        if (var0 > 0 && var1 > 0 && var0 % 2 != 0 && var1 % 2 != 0 && (var0 /= 2) <= GRID_WIDTH && (var1 /= 2) <= GRID_HEIGHT && (var3 = MathHelper.abs(var0 * GRID_WIDTH + var1)) < ALL_BLOCKS.size()) {
            var2 = ALL_BLOCKS.get(var3);
        }
        return var2;
    }

    @Override
    public void applyCarvers(RegionLimitedWorldAccess var0, long var1, RandomState var3, BiomeManager var4, StructureManager var5, IChunkAccess var6, WorldGenStage.Features var7) {
    }

    @Override
    public void spawnOriginalMobs(RegionLimitedWorldAccess var0) {
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getGenDepth() {
        return 384;
    }

    @Override
    public int getSeaLevel() {
        return 63;
    }
}

