/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;

public class TrialSpawnerData {
    public static final String TAG_SPAWN_DATA = "spawn_data";
    private static final String TAG_NEXT_MOB_SPAWNS_AT = "next_mob_spawns_at";
    private static final int DELAY_BETWEEN_PLAYER_SCANS = 20;
    private static final int TRIAL_OMEN_PER_BAD_OMEN_LEVEL = 18000;
    public static MapCodec<TrialSpawnerData> MAP_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)UUIDUtil.CODEC_SET.lenientOptionalFieldOf("registered_players", (Object)Sets.newHashSet()).forGetter(var0 -> var0.detectedPlayers), (App)UUIDUtil.CODEC_SET.lenientOptionalFieldOf("current_mobs", (Object)Sets.newHashSet()).forGetter(var0 -> var0.currentMobs), (App)Codec.LONG.lenientOptionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(var0 -> var0.cooldownEndsAt), (App)Codec.LONG.lenientOptionalFieldOf(TAG_NEXT_MOB_SPAWNS_AT, (Object)0L).forGetter(var0 -> var0.nextMobSpawnsAt), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("total_mobs_spawned", (Object)0).forGetter(var0 -> var0.totalMobsSpawned), (App)MobSpawnerData.CODEC.lenientOptionalFieldOf(TAG_SPAWN_DATA).forGetter(var0 -> var0.nextSpawnData), (App)ResourceKey.codec(Registries.LOOT_TABLE).lenientOptionalFieldOf("ejecting_loot_table").forGetter(var0 -> var0.ejectingLootTable)).apply((Applicative)var02, TrialSpawnerData::new));
    public final Set<UUID> detectedPlayers = new HashSet<UUID>();
    public final Set<UUID> currentMobs = new HashSet<UUID>();
    protected long cooldownEndsAt;
    protected long nextMobSpawnsAt;
    protected int totalMobsSpawned;
    public Optional<MobSpawnerData> nextSpawnData;
    protected Optional<ResourceKey<LootTable>> ejectingLootTable;
    @Nullable
    protected Entity displayEntity;
    @Nullable
    private SimpleWeightedRandomList<ItemStack> dispensing;
    protected double spin;
    protected double oSpin;

    public TrialSpawnerData() {
        this(Collections.emptySet(), Collections.emptySet(), 0L, 0L, 0, Optional.empty(), Optional.empty());
    }

    public TrialSpawnerData(Set<UUID> var0, Set<UUID> var1, long var2, long var4, int var6, Optional<MobSpawnerData> var7, Optional<ResourceKey<LootTable>> var8) {
        this.detectedPlayers.addAll(var0);
        this.currentMobs.addAll(var1);
        this.cooldownEndsAt = var2;
        this.nextMobSpawnsAt = var4;
        this.totalMobsSpawned = var6;
        this.nextSpawnData = var7;
        this.ejectingLootTable = var8;
    }

    public void reset() {
        this.detectedPlayers.clear();
        this.totalMobsSpawned = 0;
        this.nextMobSpawnsAt = 0L;
        this.cooldownEndsAt = 0L;
        this.currentMobs.clear();
        this.nextSpawnData = Optional.empty();
    }

    public boolean hasMobToSpawn(TrialSpawner var0, RandomSource var1) {
        boolean var2 = this.getOrCreateNextSpawnData(var0, var1).getEntityToSpawn().contains("id", 8);
        return var2 || !var0.getConfig().spawnPotentialsDefinition().isEmpty();
    }

    public boolean hasFinishedSpawningAllMobs(TrialSpawnerConfig var0, int var1) {
        return this.totalMobsSpawned >= var0.calculateTargetTotalMobs(var1);
    }

    public boolean haveAllCurrentMobsDied() {
        return this.currentMobs.isEmpty();
    }

    public boolean isReadyToSpawnNextMob(WorldServer var0, TrialSpawnerConfig var1, int var2) {
        return var0.getGameTime() >= this.nextMobSpawnsAt && this.currentMobs.size() < var1.calculateTargetSimultaneousMobs(var2);
    }

    public int countAdditionalPlayers(BlockPosition var0) {
        if (this.detectedPlayers.isEmpty()) {
            SystemUtils.logAndPauseIfInIde("Trial Spawner at " + String.valueOf(var0) + " has no detected players");
        }
        return Math.max(0, this.detectedPlayers.size() - 1);
    }

    public void tryDetectPlayers(WorldServer var0, BlockPosition var1, TrialSpawner var2) {
        List<UUID> var7;
        boolean var5;
        boolean var32;
        boolean bl = var32 = (var1.asLong() + var0.getGameTime()) % 20L != 0L;
        if (var32) {
            return;
        }
        if (var2.getState().equals(TrialSpawnerState.COOLDOWN) && var2.isOminous()) {
            return;
        }
        List<UUID> var4 = var2.getPlayerDetector().detect(var0, var2.getEntitySelector(), var1, var2.getRequiredPlayerRange(), true);
        if (var2.isOminous() || var4.isEmpty()) {
            var5 = false;
        } else {
            Optional<Pair<EntityHuman, Holder<MobEffectList>>> var6 = TrialSpawnerData.findPlayerWithOminousEffect(var0, var4);
            var6.ifPresent(var3 -> {
                EntityHuman var4 = (EntityHuman)var3.getFirst();
                if (var3.getSecond() == MobEffects.BAD_OMEN) {
                    TrialSpawnerData.transformBadOmenIntoTrialOmen(var4);
                }
                var0.levelEvent(3020, BlockPosition.containing(var4.getEyePosition()), 0);
                var2.applyOminous(var0, var1);
            });
            var5 = var6.isPresent();
        }
        if (var2.getState().equals(TrialSpawnerState.COOLDOWN) && !var5) {
            return;
        }
        boolean var6 = var2.getData().detectedPlayers.isEmpty();
        List<UUID> list = var7 = var6 ? var4 : var2.getPlayerDetector().detect(var0, var2.getEntitySelector(), var1, var2.getRequiredPlayerRange(), false);
        if (this.detectedPlayers.addAll(var7)) {
            this.nextMobSpawnsAt = Math.max(var0.getGameTime() + 40L, this.nextMobSpawnsAt);
            if (!var5) {
                int var8 = var2.isOminous() ? 3019 : 3013;
                var0.levelEvent(var8, var1, this.detectedPlayers.size());
            }
        }
    }

    private static Optional<Pair<EntityHuman, Holder<MobEffectList>>> findPlayerWithOminousEffect(WorldServer var02, List<UUID> var1) {
        EntityHuman var2 = null;
        for (UUID var4 : var1) {
            EntityHuman var5 = var02.getPlayerByUUID(var4);
            if (var5 == null) continue;
            Holder<MobEffectList> var6 = MobEffects.TRIAL_OMEN;
            if (var5.hasEffect(var6)) {
                return Optional.of(Pair.of((Object)var5, var6));
            }
            if (!var5.hasEffect(MobEffects.BAD_OMEN)) continue;
            var2 = var5;
        }
        return Optional.ofNullable(var2).map(var0 -> Pair.of((Object)var0, MobEffects.BAD_OMEN));
    }

    public void resetAfterBecomingOminous(TrialSpawner var0, WorldServer var12) {
        this.currentMobs.stream().map(var12::getEntity).forEach(var1 -> {
            if (var1 == null) {
                return;
            }
            var12.levelEvent(3012, var1.blockPosition(), TrialSpawner.a.NORMAL.encode());
            if (var1 instanceof EntityInsentient) {
                EntityInsentient var2 = (EntityInsentient)var1;
                var2.dropPreservedEquipment();
            }
            var1.remove(Entity.RemovalReason.DISCARDED);
        });
        if (!var0.getOminousConfig().spawnPotentialsDefinition().isEmpty()) {
            this.nextSpawnData = Optional.empty();
        }
        this.totalMobsSpawned = 0;
        this.currentMobs.clear();
        this.nextMobSpawnsAt = var12.getGameTime() + (long)var0.getOminousConfig().ticksBetweenSpawn();
        var0.markUpdated();
        this.cooldownEndsAt = var12.getGameTime() + var0.getOminousConfig().ticksBetweenItemSpawners();
    }

    private static void transformBadOmenIntoTrialOmen(EntityHuman var0) {
        MobEffect var1 = var0.getEffect(MobEffects.BAD_OMEN);
        if (var1 == null) {
            return;
        }
        int var2 = var1.getAmplifier() + 1;
        int var3 = 18000 * var2;
        var0.removeEffect(MobEffects.BAD_OMEN);
        var0.addEffect(new MobEffect(MobEffects.TRIAL_OMEN, var3, 0));
    }

    public boolean isReadyToOpenShutter(WorldServer var0, float var1, int var2) {
        long var3 = this.cooldownEndsAt - (long)var2;
        return (float)var0.getGameTime() >= (float)var3 + var1;
    }

    public boolean isReadyToEjectItems(WorldServer var0, float var1, int var2) {
        long var3 = this.cooldownEndsAt - (long)var2;
        return (float)(var0.getGameTime() - var3) % var1 == 0.0f;
    }

    public boolean isCooldownFinished(WorldServer var0) {
        return var0.getGameTime() >= this.cooldownEndsAt;
    }

    public void setEntityId(TrialSpawner var0, RandomSource var1, EntityTypes<?> var2) {
        this.getOrCreateNextSpawnData(var0, var1).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(var2).toString());
    }

    protected MobSpawnerData getOrCreateNextSpawnData(TrialSpawner var0, RandomSource var1) {
        if (this.nextSpawnData.isPresent()) {
            return this.nextSpawnData.get();
        }
        SimpleWeightedRandomList<MobSpawnerData> var2 = var0.getConfig().spawnPotentialsDefinition();
        Optional<MobSpawnerData> var3 = var2.isEmpty() ? this.nextSpawnData : var2.getRandom(var1).map(WeightedEntry.b::data);
        this.nextSpawnData = Optional.of(var3.orElseGet(MobSpawnerData::new));
        var0.markUpdated();
        return this.nextSpawnData.get();
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(TrialSpawner var0, World var1, TrialSpawnerState var2) {
        NBTTagCompound var3;
        if (!var2.hasSpinningMob()) {
            return null;
        }
        if (this.displayEntity == null && (var3 = this.getOrCreateNextSpawnData(var0, var1.getRandom()).getEntityToSpawn()).contains("id", 8)) {
            this.displayEntity = EntityTypes.loadEntityRecursive(var3, var1, Function.identity());
        }
        return this.displayEntity;
    }

    public NBTTagCompound getUpdateTag(TrialSpawnerState var0) {
        NBTTagCompound var12 = new NBTTagCompound();
        if (var0 == TrialSpawnerState.ACTIVE) {
            var12.putLong(TAG_NEXT_MOB_SPAWNS_AT, this.nextMobSpawnsAt);
        }
        this.nextSpawnData.ifPresent(var1 -> var12.put(TAG_SPAWN_DATA, (NBTBase)MobSpawnerData.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var1).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData"))));
        return var12;
    }

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }

    SimpleWeightedRandomList<ItemStack> getDispensingItems(WorldServer var0, TrialSpawnerConfig var1, BlockPosition var2) {
        long var5;
        LootParams var4;
        if (this.dispensing != null) {
            return this.dispensing;
        }
        LootTable var3 = var0.getServer().reloadableRegistries().getLootTable(var1.itemsToDropWhenOminous());
        ObjectArrayList<ItemStack> var7 = var3.getRandomItems(var4 = new LootParams.a(var0).create(LootContextParameterSets.EMPTY), var5 = TrialSpawnerData.lowResolutionPosition(var0, var2));
        if (var7.isEmpty()) {
            return SimpleWeightedRandomList.empty();
        }
        SimpleWeightedRandomList.a<ItemStack> var8 = new SimpleWeightedRandomList.a<ItemStack>();
        for (ItemStack var10 : var7) {
            var8.add(var10.copyWithCount(1), var10.getCount());
        }
        this.dispensing = var8.build();
        return this.dispensing;
    }

    private static long lowResolutionPosition(WorldServer var0, BlockPosition var1) {
        BlockPosition var2 = new BlockPosition(MathHelper.floor((float)var1.getX() / 30.0f), MathHelper.floor((float)var1.getY() / 20.0f), MathHelper.floor((float)var1.getZ() / 30.0f));
        return var0.getSeed() + var2.asLong();
    }
}

