/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class ChiseledBookShelfBlock
extends BlockTileEntity {
    public static final MapCodec<ChiseledBookShelfBlock> CODEC = ChiseledBookShelfBlock.simpleCodec(ChiseledBookShelfBlock::new);
    private static final int MAX_BOOKS_IN_STORAGE = 6;
    public static final int BOOKS_PER_ROW = 3;
    public static final List<BlockStateBoolean> SLOT_OCCUPIED_PROPERTIES = List.of(BlockProperties.CHISELED_BOOKSHELF_SLOT_0_OCCUPIED, BlockProperties.CHISELED_BOOKSHELF_SLOT_1_OCCUPIED, BlockProperties.CHISELED_BOOKSHELF_SLOT_2_OCCUPIED, BlockProperties.CHISELED_BOOKSHELF_SLOT_3_OCCUPIED, BlockProperties.CHISELED_BOOKSHELF_SLOT_4_OCCUPIED, BlockProperties.CHISELED_BOOKSHELF_SLOT_5_OCCUPIED);

    public MapCodec<ChiseledBookShelfBlock> codec() {
        return CODEC;
    }

    public ChiseledBookShelfBlock(BlockBase.Info var0) {
        super(var0);
        IBlockData var1 = (IBlockData)((IBlockData)this.stateDefinition.any()).setValue(BlockFacingHorizontal.FACING, EnumDirection.NORTH);
        for (BlockStateBoolean var3 : SLOT_OCCUPIED_PROPERTIES) {
            var1 = (IBlockData)var1.setValue(var3, false);
        }
        this.registerDefaultState(var1);
    }

    @Override
    protected EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        TileEntity tileEntity = var2.getBlockEntity(var3);
        if (!(tileEntity instanceof ChiseledBookShelfBlockEntity)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        ChiseledBookShelfBlockEntity var7 = (ChiseledBookShelfBlockEntity)tileEntity;
        if (!var0.is(TagsItem.BOOKSHELF_BOOKS)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        OptionalInt var8 = this.getHitSlot(var6, var1);
        if (var8.isEmpty()) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (((Boolean)var1.getValue(SLOT_OCCUPIED_PROPERTIES.get(var8.getAsInt()))).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ChiseledBookShelfBlock.addBook(var2, var3, var4, var7, var0, var8.getAsInt());
        return ItemInteractionResult.sidedSuccess(var2.isClientSide);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (!(tileEntity instanceof ChiseledBookShelfBlockEntity)) {
            return EnumInteractionResult.PASS;
        }
        ChiseledBookShelfBlockEntity var5 = (ChiseledBookShelfBlockEntity)tileEntity;
        OptionalInt var6 = this.getHitSlot(var4, var0);
        if (var6.isEmpty()) {
            return EnumInteractionResult.PASS;
        }
        if (!((Boolean)var0.getValue(SLOT_OCCUPIED_PROPERTIES.get(var6.getAsInt()))).booleanValue()) {
            return EnumInteractionResult.CONSUME;
        }
        ChiseledBookShelfBlock.removeBook(var1, var2, var3, var5, var6.getAsInt());
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }

    public OptionalInt getHitSlot(MovingObjectPositionBlock var02, IBlockData var1) {
        return ChiseledBookShelfBlock.getRelativeHitCoordinatesForBlockFace(var02, var1.getValue(BlockFacingHorizontal.FACING)).map(var0 -> {
            int var1 = var0.y >= 0.5f ? 0 : 1;
            int var2 = ChiseledBookShelfBlock.getSection(var0.x);
            return OptionalInt.of(var2 + var1 * 3);
        }).orElseGet(OptionalInt::empty);
    }

    private static Optional<Vec2F> getRelativeHitCoordinatesForBlockFace(MovingObjectPositionBlock var0, EnumDirection var1) {
        EnumDirection var2 = var0.getDirection();
        if (var1 != var2) {
            return Optional.empty();
        }
        BlockPosition var3 = var0.getBlockPos().relative(var2);
        Vec3D var4 = var0.getLocation().subtract(var3.getX(), var3.getY(), var3.getZ());
        double var5 = var4.x();
        double var7 = var4.y();
        double var9 = var4.z();
        return switch (var2) {
            default -> throw new MatchException(null, null);
            case EnumDirection.NORTH -> Optional.of(new Vec2F((float)(1.0 - var5), (float)var7));
            case EnumDirection.SOUTH -> Optional.of(new Vec2F((float)var5, (float)var7));
            case EnumDirection.WEST -> Optional.of(new Vec2F((float)var9, (float)var7));
            case EnumDirection.EAST -> Optional.of(new Vec2F((float)(1.0 - var9), (float)var7));
            case EnumDirection.DOWN, EnumDirection.UP -> Optional.empty();
        };
    }

    public static int getSection(float var0) {
        float var1 = 0.0625f;
        float var2 = 0.375f;
        if (var0 < 0.375f) {
            return 0;
        }
        float var3 = 0.6875f;
        if (var0 < 0.6875f) {
            return 1;
        }
        return 2;
    }

    private static void addBook(World var0, BlockPosition var1, EntityHuman var2, ChiseledBookShelfBlockEntity var3, ItemStack var4, int var5) {
        if (var0.isClientSide) {
            return;
        }
        var2.awardStat(StatisticList.ITEM_USED.get(var4.getItem()));
        SoundEffect var6 = var4.is(Items.ENCHANTED_BOOK) ? SoundEffects.CHISELED_BOOKSHELF_INSERT_ENCHANTED : SoundEffects.CHISELED_BOOKSHELF_INSERT;
        var3.setItem(var5, var4.consumeAndReturn(1, var2));
        var0.playSound(null, var1, var6, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private static void removeBook(World var0, BlockPosition var1, EntityHuman var2, ChiseledBookShelfBlockEntity var3, int var4) {
        if (var0.isClientSide) {
            return;
        }
        ItemStack var5 = var3.removeItem(var4, 1);
        SoundEffect var6 = var5.is(Items.ENCHANTED_BOOK) ? SoundEffects.CHISELED_BOOKSHELF_PICKUP_ENCHANTED : SoundEffects.CHISELED_BOOKSHELF_PICKUP;
        var0.playSound(null, var1, var6, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!var2.getInventory().add(var5)) {
            var2.drop(var5, false);
        }
        var0.gameEvent((Entity)var2, GameEvent.BLOCK_CHANGE, var1);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new ChiseledBookShelfBlockEntity(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(BlockFacingHorizontal.FACING);
        SLOT_OCCUPIED_PROPERTIES.forEach(var1 -> var0.add((IBlockState<?>)var1));
    }

    @Override
    protected void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        ChiseledBookShelfBlockEntity var6;
        if (var0.is(var3.getBlock())) {
            return;
        }
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof ChiseledBookShelfBlockEntity && !(var6 = (ChiseledBookShelfBlockEntity)var5).isEmpty()) {
            for (int var7 = 0; var7 < 6; ++var7) {
                ItemStack var8 = var6.getItem(var7);
                if (var8.isEmpty()) continue;
                InventoryUtils.dropItemStack(var1, var2.getX(), var2.getY(), var2.getZ(), var8);
            }
            var6.clearContent();
            var1.updateNeighbourForOutputSignal(var2, this);
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(BlockFacingHorizontal.FACING, var0.getHorizontalDirection().getOpposite());
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(BlockFacingHorizontal.FACING, var1.rotate(var0.getValue(BlockFacingHorizontal.FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(BlockFacingHorizontal.FACING)));
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        if (var1.isClientSide()) {
            return 0;
        }
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (tileEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity var3 = (ChiseledBookShelfBlockEntity)tileEntity;
            return var3.getLastInteractedSlot() + 1;
        }
        return 0;
    }
}

