/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class CandleBlock
extends AbstractCandleBlock
implements IBlockWaterlogged {
    public static final MapCodec<CandleBlock> CODEC = CandleBlock.simpleCodec(CandleBlock::new);
    public static final int MIN_CANDLES = 1;
    public static final int MAX_CANDLES = 4;
    public static final BlockStateInteger CANDLES = BlockProperties.CANDLES;
    public static final BlockStateBoolean LIT = AbstractCandleBlock.LIT;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final ToIntFunction<IBlockData> LIGHT_EMISSION = var0 -> var0.getValue(LIT) != false ? 3 * var0.getValue(CANDLES) : 0;
    private static final Int2ObjectMap<List<Vec3D>> PARTICLE_OFFSETS = SystemUtils.make(() -> {
        Int2ObjectOpenHashMap var0 = new Int2ObjectOpenHashMap();
        var0.defaultReturnValue((Object)ImmutableList.of());
        var0.put(1, (Object)ImmutableList.of((Object)new Vec3D(0.5, 0.5, 0.5)));
        var0.put(2, (Object)ImmutableList.of((Object)new Vec3D(0.375, 0.44, 0.5), (Object)new Vec3D(0.625, 0.5, 0.44)));
        var0.put(3, (Object)ImmutableList.of((Object)new Vec3D(0.5, 0.313, 0.625), (Object)new Vec3D(0.375, 0.44, 0.5), (Object)new Vec3D(0.56, 0.5, 0.44)));
        var0.put(4, (Object)ImmutableList.of((Object)new Vec3D(0.44, 0.313, 0.56), (Object)new Vec3D(0.625, 0.44, 0.56), (Object)new Vec3D(0.375, 0.44, 0.375), (Object)new Vec3D(0.56, 0.5, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)var0);
    });
    private static final VoxelShape ONE_AABB = Block.box(7.0, 0.0, 7.0, 9.0, 6.0, 9.0);
    private static final VoxelShape TWO_AABB = Block.box(5.0, 0.0, 6.0, 11.0, 6.0, 9.0);
    private static final VoxelShape THREE_AABB = Block.box(5.0, 0.0, 6.0, 10.0, 6.0, 11.0);
    private static final VoxelShape FOUR_AABB = Block.box(5.0, 0.0, 5.0, 11.0, 6.0, 10.0);

    public MapCodec<CandleBlock> codec() {
        return CODEC;
    }

    public CandleBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(CANDLES, 1)).setValue(LIT, false)).setValue(WATERLOGGED, false));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        if (var0.isEmpty() && var4.getAbilities().mayBuild && var1.getValue(LIT).booleanValue()) {
            CandleBlock.extinguish(var4, var1, var2, var3);
            return ItemInteractionResult.sidedSuccess(var2.isClientSide);
        }
        return super.useItemOn(var0, var1, var2, var3, var4, var5, var6);
    }

    @Override
    protected boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        if (!var1.isSecondaryUseActive() && var1.getItemInHand().getItem() == this.asItem() && var0.getValue(CANDLES) < 4) {
            return true;
        }
        return super.canBeReplaced(var0, var1);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = var0.getLevel().getBlockState(var0.getClickedPos());
        if (var1.is(this)) {
            return (IBlockData)var1.cycle(CANDLES);
        }
        Fluid var2 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var3 = var2.getType() == FluidTypes.WATER;
        return (IBlockData)super.getStateForPlacement(var0).setValue(WATERLOGGED, var3);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        switch (var0.getValue(CANDLES)) {
            default: {
                return ONE_AABB;
            }
            case 2: {
                return TWO_AABB;
            }
            case 3: {
                return THREE_AABB;
            }
            case 4: 
        }
        return FOUR_AABB;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(CANDLES, LIT, WATERLOGGED);
    }

    @Override
    public boolean placeLiquid(GeneratorAccess var0, BlockPosition var1, IBlockData var2, Fluid var3) {
        if (var2.getValue(WATERLOGGED).booleanValue() || var3.getType() != FluidTypes.WATER) {
            return false;
        }
        IBlockData var4 = (IBlockData)var2.setValue(WATERLOGGED, true);
        if (var2.getValue(LIT).booleanValue()) {
            CandleBlock.extinguish(null, var4, var0, var1);
        } else {
            var0.setBlock(var1, var4, 3);
        }
        var0.scheduleTick(var1, var3.getType(), var3.getType().getTickDelay(var0));
        return true;
    }

    public static boolean canLight(IBlockData var02) {
        return var02.is(TagsBlock.CANDLES, var0 -> var0.hasProperty(LIT) && var0.hasProperty(WATERLOGGED)) && var02.getValue(LIT) == false && var02.getValue(WATERLOGGED) == false;
    }

    @Override
    protected Iterable<Vec3D> getParticleOffsets(IBlockData var0) {
        return (Iterable)PARTICLE_OFFSETS.get(var0.getValue(CANDLES).intValue());
    }

    @Override
    protected boolean canBeLit(IBlockData var0) {
        return var0.getValue(WATERLOGGED) == false && super.canBeLit(var0);
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return Block.canSupportCenter(var1, var2.below(), EnumDirection.UP);
    }
}

