/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockLectern
extends BlockTileEntity {
    public static final MapCodec<BlockLectern> CODEC = BlockLectern.simpleCodec(BlockLectern::new);
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateBoolean HAS_BOOK = BlockProperties.HAS_BOOK;
    public static final VoxelShape SHAPE_BASE = Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    public static final VoxelShape SHAPE_POST = Block.box(4.0, 2.0, 4.0, 12.0, 14.0, 12.0);
    public static final VoxelShape SHAPE_COMMON = VoxelShapes.or(SHAPE_BASE, SHAPE_POST);
    public static final VoxelShape SHAPE_TOP_PLATE = Block.box(0.0, 15.0, 0.0, 16.0, 15.0, 16.0);
    public static final VoxelShape SHAPE_COLLISION = VoxelShapes.or(SHAPE_COMMON, SHAPE_TOP_PLATE);
    public static final VoxelShape SHAPE_WEST = VoxelShapes.or(Block.box(1.0, 10.0, 0.0, 5.333333, 14.0, 16.0), Block.box(5.333333, 12.0, 0.0, 9.666667, 16.0, 16.0), Block.box(9.666667, 14.0, 0.0, 14.0, 18.0, 16.0), SHAPE_COMMON);
    public static final VoxelShape SHAPE_NORTH = VoxelShapes.or(Block.box(0.0, 10.0, 1.0, 16.0, 14.0, 5.333333), Block.box(0.0, 12.0, 5.333333, 16.0, 16.0, 9.666667), Block.box(0.0, 14.0, 9.666667, 16.0, 18.0, 14.0), SHAPE_COMMON);
    public static final VoxelShape SHAPE_EAST = VoxelShapes.or(Block.box(10.666667, 10.0, 0.0, 15.0, 14.0, 16.0), Block.box(6.333333, 12.0, 0.0, 10.666667, 16.0, 16.0), Block.box(2.0, 14.0, 0.0, 6.333333, 18.0, 16.0), SHAPE_COMMON);
    public static final VoxelShape SHAPE_SOUTH = VoxelShapes.or(Block.box(0.0, 10.0, 10.666667, 16.0, 14.0, 15.0), Block.box(0.0, 12.0, 6.333333, 16.0, 16.0, 10.666667), Block.box(0.0, 14.0, 2.0, 16.0, 18.0, 6.333333), SHAPE_COMMON);
    private static final int PAGE_CHANGE_IMPULSE_TICKS = 2;

    public MapCodec<BlockLectern> codec() {
        return CODEC;
    }

    protected BlockLectern(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(POWERED, false)).setValue(HAS_BOOK, false));
    }

    @Override
    protected EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    protected VoxelShape getOcclusionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return SHAPE_COMMON;
    }

    @Override
    protected boolean useShapeForLightOcclusion(IBlockData var0) {
        return true;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        CustomData var5;
        World var1 = var0.getLevel();
        ItemStack var2 = var0.getItemInHand();
        EntityHuman var3 = var0.getPlayer();
        boolean var4 = false;
        if (!var1.isClientSide && var3 != null && var3.canUseGameMasterBlocks() && (var5 = var2.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY)).contains("Book")) {
            var4 = true;
        }
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite())).setValue(HAS_BOOK, var4);
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE_COLLISION;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        switch (var0.getValue(FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_COMMON;
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, POWERED, HAS_BOOK);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityLectern(var0, var1);
    }

    public static boolean tryPlaceBook(@Nullable EntityLiving var0, World var1, BlockPosition var2, IBlockData var3, ItemStack var4) {
        if (!var3.getValue(HAS_BOOK).booleanValue()) {
            if (!var1.isClientSide) {
                BlockLectern.placeBook(var0, var1, var2, var3, var4);
            }
            return true;
        }
        return false;
    }

    private static void placeBook(@Nullable EntityLiving var0, World var1, BlockPosition var2, IBlockData var3, ItemStack var4) {
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof TileEntityLectern) {
            TileEntityLectern var6 = (TileEntityLectern)var5;
            var6.setBook(var4.consumeAndReturn(1, var0));
            BlockLectern.resetBookState(var0, var1, var2, var3, true);
            var1.playSound(null, var2, SoundEffects.BOOK_PUT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void resetBookState(@Nullable Entity var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        IBlockData var5 = (IBlockData)((IBlockData)var3.setValue(POWERED, false)).setValue(HAS_BOOK, var4);
        var1.setBlock(var2, var5, 3);
        var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var0, var5));
        BlockLectern.updateBelow(var1, var2, var3);
    }

    public static void signalPageChange(World var0, BlockPosition var1, IBlockData var2) {
        BlockLectern.changePowered(var0, var1, var2, true);
        var0.scheduleTick(var1, var2.getBlock(), 2);
        var0.levelEvent(1043, var1, 0);
    }

    private static void changePowered(World var0, BlockPosition var1, IBlockData var2, boolean var3) {
        var0.setBlock(var1, (IBlockData)var2.setValue(POWERED, var3), 3);
        BlockLectern.updateBelow(var0, var1, var2);
    }

    private static void updateBelow(World var0, BlockPosition var1, IBlockData var2) {
        var0.updateNeighborsAt(var1.below(), var2.getBlock());
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        BlockLectern.changePowered(var1, var2, var0, false);
    }

    @Override
    protected void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        if (var0.getValue(HAS_BOOK).booleanValue()) {
            this.popBook(var0, var1, var2);
        }
        if (var0.getValue(POWERED).booleanValue()) {
            var1.updateNeighborsAt(var2.below(), this);
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    private void popBook(IBlockData var0, World var1, BlockPosition var2) {
        TileEntity var3 = var1.getBlockEntity(var2);
        if (var3 instanceof TileEntityLectern) {
            TileEntityLectern var4 = (TileEntityLectern)var3;
            EnumDirection var5 = var0.getValue(FACING);
            ItemStack var6 = var4.getBook().copy();
            float var7 = 0.25f * (float)var5.getStepX();
            float var8 = 0.25f * (float)var5.getStepZ();
            EntityItem var9 = new EntityItem(var1, (double)var2.getX() + 0.5 + (double)var7, var2.getY() + 1, (double)var2.getZ() + 0.5 + (double)var8, var6);
            var9.setDefaultPickUpDelay();
            var1.addFreshEntity(var9);
            var4.clearContent();
        }
    }

    @Override
    protected boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    protected int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var3 == EnumDirection.UP && var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        TileEntity var3;
        if (var0.getValue(HAS_BOOK).booleanValue() && (var3 = var1.getBlockEntity(var2)) instanceof TileEntityLectern) {
            return ((TileEntityLectern)var3).getRedstoneSignal();
        }
        return 0;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        if (var1.getValue(HAS_BOOK).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (var0.is(TagsItem.LECTERN_BOOKS)) {
            return BlockLectern.tryPlaceBook(var4, var2, var3, var1, var0) ? ItemInteractionResult.sidedSuccess(var2.isClientSide) : ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (var0.isEmpty() && var5 == EnumHand.MAIN_HAND) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (var0.getValue(HAS_BOOK).booleanValue()) {
            if (!var1.isClientSide) {
                this.openScreen(var1, var2, var3);
            }
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.CONSUME;
    }

    @Override
    @Nullable
    protected ITileInventory getMenuProvider(IBlockData var0, World var1, BlockPosition var2) {
        if (!var0.getValue(HAS_BOOK).booleanValue()) {
            return null;
        }
        return super.getMenuProvider(var0, var1, var2);
    }

    private void openScreen(World var0, BlockPosition var1, EntityHuman var2) {
        TileEntity var3 = var0.getBlockEntity(var1);
        if (var3 instanceof TileEntityLectern) {
            var2.openMenu((TileEntityLectern)var3);
            var2.awardStat(StatisticList.INTERACT_WITH_LECTERN);
        }
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

