/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockDragonEgg
extends BlockFalling {
    public static final MapCodec<BlockDragonEgg> CODEC = BlockDragonEgg.simpleCodec(BlockDragonEgg::new);
    protected static final VoxelShape SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    public MapCodec<BlockDragonEgg> codec() {
        return CODEC;
    }

    public BlockDragonEgg(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        this.teleport(var0, var1, var2);
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }

    @Override
    protected void attack(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        this.teleport(var0, var1, var2);
    }

    private void teleport(IBlockData var0, World var1, BlockPosition var2) {
        WorldBorder var3 = var1.getWorldBorder();
        for (int var4 = 0; var4 < 1000; ++var4) {
            BlockPosition var5 = var2.offset(var1.random.nextInt(16) - var1.random.nextInt(16), var1.random.nextInt(8) - var1.random.nextInt(8), var1.random.nextInt(16) - var1.random.nextInt(16));
            if (!var1.getBlockState(var5).isAir() || !var3.isWithinBounds(var5)) continue;
            if (var1.isClientSide) {
                for (int var6 = 0; var6 < 128; ++var6) {
                    double var7 = var1.random.nextDouble();
                    float var9 = (var1.random.nextFloat() - 0.5f) * 0.2f;
                    float var10 = (var1.random.nextFloat() - 0.5f) * 0.2f;
                    float var11 = (var1.random.nextFloat() - 0.5f) * 0.2f;
                    double var12 = MathHelper.lerp(var7, (double)var5.getX(), (double)var2.getX()) + (var1.random.nextDouble() - 0.5) + 0.5;
                    double var14 = MathHelper.lerp(var7, (double)var5.getY(), (double)var2.getY()) + var1.random.nextDouble() - 0.5;
                    double var16 = MathHelper.lerp(var7, (double)var5.getZ(), (double)var2.getZ()) + (var1.random.nextDouble() - 0.5) + 0.5;
                    var1.addParticle(Particles.PORTAL, var12, var14, var16, var9, var10, var11);
                }
            } else {
                var1.setBlock(var5, var0, 2);
                var1.removeBlock(var2, false);
            }
            return;
        }
    }

    @Override
    protected int getDelayAfterPlace() {
        return 5;
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

