/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventoryHolder;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockComposter
extends Block
implements IInventoryHolder {
    public static final MapCodec<BlockComposter> CODEC = BlockComposter.simpleCodec(BlockComposter::new);
    public static final int READY = 8;
    public static final int MIN_LEVEL = 0;
    public static final int MAX_LEVEL = 7;
    public static final BlockStateInteger LEVEL = BlockProperties.LEVEL_COMPOSTER;
    public static final Object2FloatMap<IMaterial> COMPOSTABLES = new Object2FloatOpenHashMap();
    private static final int AABB_SIDE_THICKNESS = 2;
    private static final VoxelShape OUTER_SHAPE = VoxelShapes.block();
    private static final VoxelShape[] SHAPES = SystemUtils.make(new VoxelShape[9], var0 -> {
        for (int var1 = 0; var1 < 8; ++var1) {
            var0[var1] = VoxelShapes.join(OUTER_SHAPE, Block.box(2.0, Math.max(2, 1 + var1 * 2), 2.0, 14.0, 16.0, 14.0), OperatorBoolean.ONLY_FIRST);
        }
        var0[8] = var0[7];
    });

    public MapCodec<BlockComposter> codec() {
        return CODEC;
    }

    public static void bootStrap() {
        COMPOSTABLES.defaultReturnValue(-1.0f);
        float var0 = 0.3f;
        float var1 = 0.5f;
        float var2 = 0.65f;
        float var3 = 0.85f;
        float var4 = 1.0f;
        BlockComposter.add(0.3f, Items.JUNGLE_LEAVES);
        BlockComposter.add(0.3f, Items.OAK_LEAVES);
        BlockComposter.add(0.3f, Items.SPRUCE_LEAVES);
        BlockComposter.add(0.3f, Items.DARK_OAK_LEAVES);
        BlockComposter.add(0.3f, Items.ACACIA_LEAVES);
        BlockComposter.add(0.3f, Items.CHERRY_LEAVES);
        BlockComposter.add(0.3f, Items.BIRCH_LEAVES);
        BlockComposter.add(0.3f, Items.AZALEA_LEAVES);
        BlockComposter.add(0.3f, Items.MANGROVE_LEAVES);
        BlockComposter.add(0.3f, Items.OAK_SAPLING);
        BlockComposter.add(0.3f, Items.SPRUCE_SAPLING);
        BlockComposter.add(0.3f, Items.BIRCH_SAPLING);
        BlockComposter.add(0.3f, Items.JUNGLE_SAPLING);
        BlockComposter.add(0.3f, Items.ACACIA_SAPLING);
        BlockComposter.add(0.3f, Items.CHERRY_SAPLING);
        BlockComposter.add(0.3f, Items.DARK_OAK_SAPLING);
        BlockComposter.add(0.3f, Items.MANGROVE_PROPAGULE);
        BlockComposter.add(0.3f, Items.BEETROOT_SEEDS);
        BlockComposter.add(0.3f, Items.DRIED_KELP);
        BlockComposter.add(0.3f, Items.SHORT_GRASS);
        BlockComposter.add(0.3f, Items.KELP);
        BlockComposter.add(0.3f, Items.MELON_SEEDS);
        BlockComposter.add(0.3f, Items.PUMPKIN_SEEDS);
        BlockComposter.add(0.3f, Items.SEAGRASS);
        BlockComposter.add(0.3f, Items.SWEET_BERRIES);
        BlockComposter.add(0.3f, Items.GLOW_BERRIES);
        BlockComposter.add(0.3f, Items.WHEAT_SEEDS);
        BlockComposter.add(0.3f, Items.MOSS_CARPET);
        BlockComposter.add(0.3f, Items.PINK_PETALS);
        BlockComposter.add(0.3f, Items.SMALL_DRIPLEAF);
        BlockComposter.add(0.3f, Items.HANGING_ROOTS);
        BlockComposter.add(0.3f, Items.MANGROVE_ROOTS);
        BlockComposter.add(0.3f, Items.TORCHFLOWER_SEEDS);
        BlockComposter.add(0.3f, Items.PITCHER_POD);
        BlockComposter.add(0.5f, Items.DRIED_KELP_BLOCK);
        BlockComposter.add(0.5f, Items.TALL_GRASS);
        BlockComposter.add(0.5f, Items.FLOWERING_AZALEA_LEAVES);
        BlockComposter.add(0.5f, Items.CACTUS);
        BlockComposter.add(0.5f, Items.SUGAR_CANE);
        BlockComposter.add(0.5f, Items.VINE);
        BlockComposter.add(0.5f, Items.NETHER_SPROUTS);
        BlockComposter.add(0.5f, Items.WEEPING_VINES);
        BlockComposter.add(0.5f, Items.TWISTING_VINES);
        BlockComposter.add(0.5f, Items.MELON_SLICE);
        BlockComposter.add(0.5f, Items.GLOW_LICHEN);
        BlockComposter.add(0.65f, Items.SEA_PICKLE);
        BlockComposter.add(0.65f, Items.LILY_PAD);
        BlockComposter.add(0.65f, Items.PUMPKIN);
        BlockComposter.add(0.65f, Items.CARVED_PUMPKIN);
        BlockComposter.add(0.65f, Items.MELON);
        BlockComposter.add(0.65f, Items.APPLE);
        BlockComposter.add(0.65f, Items.BEETROOT);
        BlockComposter.add(0.65f, Items.CARROT);
        BlockComposter.add(0.65f, Items.COCOA_BEANS);
        BlockComposter.add(0.65f, Items.POTATO);
        BlockComposter.add(0.65f, Items.WHEAT);
        BlockComposter.add(0.65f, Items.BROWN_MUSHROOM);
        BlockComposter.add(0.65f, Items.RED_MUSHROOM);
        BlockComposter.add(0.65f, Items.MUSHROOM_STEM);
        BlockComposter.add(0.65f, Items.CRIMSON_FUNGUS);
        BlockComposter.add(0.65f, Items.WARPED_FUNGUS);
        BlockComposter.add(0.65f, Items.NETHER_WART);
        BlockComposter.add(0.65f, Items.CRIMSON_ROOTS);
        BlockComposter.add(0.65f, Items.WARPED_ROOTS);
        BlockComposter.add(0.65f, Items.SHROOMLIGHT);
        BlockComposter.add(0.65f, Items.DANDELION);
        BlockComposter.add(0.65f, Items.POPPY);
        BlockComposter.add(0.65f, Items.BLUE_ORCHID);
        BlockComposter.add(0.65f, Items.ALLIUM);
        BlockComposter.add(0.65f, Items.AZURE_BLUET);
        BlockComposter.add(0.65f, Items.RED_TULIP);
        BlockComposter.add(0.65f, Items.ORANGE_TULIP);
        BlockComposter.add(0.65f, Items.WHITE_TULIP);
        BlockComposter.add(0.65f, Items.PINK_TULIP);
        BlockComposter.add(0.65f, Items.OXEYE_DAISY);
        BlockComposter.add(0.65f, Items.CORNFLOWER);
        BlockComposter.add(0.65f, Items.LILY_OF_THE_VALLEY);
        BlockComposter.add(0.65f, Items.WITHER_ROSE);
        BlockComposter.add(0.65f, Items.FERN);
        BlockComposter.add(0.65f, Items.SUNFLOWER);
        BlockComposter.add(0.65f, Items.LILAC);
        BlockComposter.add(0.65f, Items.ROSE_BUSH);
        BlockComposter.add(0.65f, Items.PEONY);
        BlockComposter.add(0.65f, Items.LARGE_FERN);
        BlockComposter.add(0.65f, Items.SPORE_BLOSSOM);
        BlockComposter.add(0.65f, Items.AZALEA);
        BlockComposter.add(0.65f, Items.MOSS_BLOCK);
        BlockComposter.add(0.65f, Items.BIG_DRIPLEAF);
        BlockComposter.add(0.85f, Items.HAY_BLOCK);
        BlockComposter.add(0.85f, Items.BROWN_MUSHROOM_BLOCK);
        BlockComposter.add(0.85f, Items.RED_MUSHROOM_BLOCK);
        BlockComposter.add(0.85f, Items.NETHER_WART_BLOCK);
        BlockComposter.add(0.85f, Items.WARPED_WART_BLOCK);
        BlockComposter.add(0.85f, Items.FLOWERING_AZALEA);
        BlockComposter.add(0.85f, Items.BREAD);
        BlockComposter.add(0.85f, Items.BAKED_POTATO);
        BlockComposter.add(0.85f, Items.COOKIE);
        BlockComposter.add(0.85f, Items.TORCHFLOWER);
        BlockComposter.add(0.85f, Items.PITCHER_PLANT);
        BlockComposter.add(1.0f, Items.CAKE);
        BlockComposter.add(1.0f, Items.PUMPKIN_PIE);
    }

    private static void add(float var0, IMaterial var1) {
        COMPOSTABLES.put((Object)var1.asItem(), var0);
    }

    public BlockComposter(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(LEVEL, 0));
    }

    public static void handleFill(World var0, BlockPosition var1, boolean var2) {
        IBlockData var3 = var0.getBlockState(var1);
        var0.playLocalSound(var1, var2 ? SoundEffects.COMPOSTER_FILL_SUCCESS : SoundEffects.COMPOSTER_FILL, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        double var4 = var3.getShape(var0, var1).max(EnumDirection.EnumAxis.Y, 0.5, 0.5) + 0.03125;
        double var6 = 0.13125f;
        double var8 = 0.7375f;
        RandomSource var10 = var0.getRandom();
        for (int var11 = 0; var11 < 10; ++var11) {
            double var12 = var10.nextGaussian() * 0.02;
            double var14 = var10.nextGaussian() * 0.02;
            double var16 = var10.nextGaussian() * 0.02;
            var0.addParticle(Particles.COMPOSTER, (double)var1.getX() + (double)0.13125f + (double)0.7375f * (double)var10.nextFloat(), (double)var1.getY() + var4 + (double)var10.nextFloat() * (1.0 - var4), (double)var1.getZ() + (double)0.13125f + (double)0.7375f * (double)var10.nextFloat(), var12, var14, var16);
        }
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES[var0.getValue(LEVEL)];
    }

    @Override
    protected VoxelShape getInteractionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return OUTER_SHAPE;
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES[0];
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.getValue(LEVEL) == 7) {
            var1.scheduleTick(var2, var0.getBlock(), 20);
        }
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        int var7 = var1.getValue(LEVEL);
        if (var7 < 8 && COMPOSTABLES.containsKey((Object)var0.getItem())) {
            if (var7 < 7 && !var2.isClientSide) {
                IBlockData var8 = BlockComposter.addItem(var4, var1, var2, var3, var0);
                var2.levelEvent(1500, var3, var1 != var8 ? 1 : 0);
                var4.awardStat(StatisticList.ITEM_USED.get(var0.getItem()));
                var0.consume(1, var4);
            }
            return ItemInteractionResult.sidedSuccess(var2.isClientSide);
        }
        return super.useItemOn(var0, var1, var2, var3, var4, var5, var6);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        int var5 = var0.getValue(LEVEL);
        if (var5 == 8) {
            BlockComposter.extractProduce(var3, var0, var1, var2);
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    public static IBlockData insertItem(Entity var0, IBlockData var1, WorldServer var2, ItemStack var3, BlockPosition var4) {
        int var5 = var1.getValue(LEVEL);
        if (var5 < 7 && COMPOSTABLES.containsKey((Object)var3.getItem())) {
            IBlockData var6 = BlockComposter.addItem(var0, var1, var2, var4, var3);
            var3.shrink(1);
            return var6;
        }
        return var1;
    }

    public static IBlockData extractProduce(Entity var0, IBlockData var1, World var2, BlockPosition var3) {
        Object var4;
        if (!var2.isClientSide) {
            var4 = Vec3D.atLowerCornerWithOffset(var3, 0.5, 1.01, 0.5).offsetRandom(var2.random, 0.7f);
            EntityItem var5 = new EntityItem(var2, ((Vec3D)var4).x(), ((Vec3D)var4).y(), ((Vec3D)var4).z(), new ItemStack(Items.BONE_MEAL));
            var5.setDefaultPickUpDelay();
            var2.addFreshEntity(var5);
        }
        var4 = BlockComposter.empty(var0, var1, var2, var3);
        var2.playSound(null, var3, SoundEffects.COMPOSTER_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return var4;
    }

    static IBlockData empty(@Nullable Entity var0, IBlockData var1, GeneratorAccess var2, BlockPosition var3) {
        IBlockData var4 = (IBlockData)var1.setValue(LEVEL, 0);
        var2.setBlock(var3, var4, 3);
        var2.gameEvent(GameEvent.BLOCK_CHANGE, var3, GameEvent.a.of(var0, var4));
        return var4;
    }

    static IBlockData addItem(@Nullable Entity var0, IBlockData var1, GeneratorAccess var2, BlockPosition var3, ItemStack var4) {
        int var5 = var1.getValue(LEVEL);
        float var6 = COMPOSTABLES.getFloat((Object)var4.getItem());
        if (var5 == 0 && var6 > 0.0f || var2.getRandom().nextDouble() < (double)var6) {
            int var7 = var5 + 1;
            IBlockData var8 = (IBlockData)var1.setValue(LEVEL, var7);
            var2.setBlock(var3, var8, 3);
            var2.gameEvent(GameEvent.BLOCK_CHANGE, var3, GameEvent.a.of(var0, var8));
            if (var7 == 7) {
                var2.scheduleTick(var3, var1.getBlock(), 20);
            }
            return var8;
        }
        return var1;
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var0.getValue(LEVEL) == 7) {
            var1.setBlock(var2, (IBlockData)var0.cycle(LEVEL), 3);
            var1.playSound(null, var2, SoundEffects.COMPOSTER_READY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        return var0.getValue(LEVEL);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(LEVEL);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }

    @Override
    public IWorldInventory getContainer(IBlockData var0, GeneratorAccess var1, BlockPosition var2) {
        int var3 = var0.getValue(LEVEL);
        if (var3 == 8) {
            return new ContainerOutput(var0, var1, var2, new ItemStack(Items.BONE_MEAL));
        }
        if (var3 < 7) {
            return new ContainerInput(var0, var1, var2);
        }
        return new ContainerEmpty();
    }

    public static class ContainerOutput
    extends InventorySubcontainer
    implements IWorldInventory {
        private final IBlockData state;
        private final GeneratorAccess level;
        private final BlockPosition pos;
        private boolean changed;

        public ContainerOutput(IBlockData var0, GeneratorAccess var1, BlockPosition var2, ItemStack var3) {
            super(var3);
            this.state = var0;
            this.level = var1;
            this.pos = var2;
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public int[] getSlotsForFace(EnumDirection var0) {
            int[] nArray;
            if (var0 == EnumDirection.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        @Override
        public boolean canPlaceItemThroughFace(int var0, ItemStack var1, @Nullable EnumDirection var2) {
            return false;
        }

        @Override
        public boolean canTakeItemThroughFace(int var0, ItemStack var1, EnumDirection var2) {
            return !this.changed && var2 == EnumDirection.DOWN && var1.is(Items.BONE_MEAL);
        }

        @Override
        public void setChanged() {
            BlockComposter.empty(null, this.state, this.level, this.pos);
            this.changed = true;
        }
    }

    public static class ContainerInput
    extends InventorySubcontainer
    implements IWorldInventory {
        private final IBlockData state;
        private final GeneratorAccess level;
        private final BlockPosition pos;
        private boolean changed;

        public ContainerInput(IBlockData var0, GeneratorAccess var1, BlockPosition var2) {
            super(1);
            this.state = var0;
            this.level = var1;
            this.pos = var2;
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public int[] getSlotsForFace(EnumDirection var0) {
            int[] nArray;
            if (var0 == EnumDirection.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        @Override
        public boolean canPlaceItemThroughFace(int var0, ItemStack var1, @Nullable EnumDirection var2) {
            return !this.changed && var2 == EnumDirection.UP && COMPOSTABLES.containsKey((Object)var1.getItem());
        }

        @Override
        public boolean canTakeItemThroughFace(int var0, ItemStack var1, EnumDirection var2) {
            return false;
        }

        @Override
        public void setChanged() {
            ItemStack var0 = this.getItem(0);
            if (!var0.isEmpty()) {
                this.changed = true;
                IBlockData var1 = BlockComposter.addItem(null, this.state, this.level, this.pos, var0);
                this.level.levelEvent(1500, this.pos, var1 != this.state ? 1 : 0);
                this.removeItemNoUpdate(0);
            }
        }
    }

    public static class ContainerEmpty
    extends InventorySubcontainer
    implements IWorldInventory {
        public ContainerEmpty() {
            super(0);
        }

        @Override
        public int[] getSlotsForFace(EnumDirection var0) {
            return new int[0];
        }

        @Override
        public boolean canPlaceItemThroughFace(int var0, ItemStack var1, @Nullable EnumDirection var2) {
            return false;
        }

        @Override
        public boolean canTakeItemThroughFace(int var0, ItemStack var1, EnumDirection var2) {
            return false;
        }
    }
}

