/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.TileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockAnvil
extends BlockFalling {
    public static final MapCodec<BlockAnvil> CODEC = BlockAnvil.simpleCodec(BlockAnvil::new);
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    private static final VoxelShape BASE = Block.box(2.0, 0.0, 2.0, 14.0, 4.0, 14.0);
    private static final VoxelShape X_LEG1 = Block.box(3.0, 4.0, 4.0, 13.0, 5.0, 12.0);
    private static final VoxelShape X_LEG2 = Block.box(4.0, 5.0, 6.0, 12.0, 10.0, 10.0);
    private static final VoxelShape X_TOP = Block.box(0.0, 10.0, 3.0, 16.0, 16.0, 13.0);
    private static final VoxelShape Z_LEG1 = Block.box(4.0, 4.0, 3.0, 12.0, 5.0, 13.0);
    private static final VoxelShape Z_LEG2 = Block.box(6.0, 5.0, 4.0, 10.0, 10.0, 12.0);
    private static final VoxelShape Z_TOP = Block.box(3.0, 10.0, 0.0, 13.0, 16.0, 16.0);
    private static final VoxelShape X_AXIS_AABB = VoxelShapes.or(BASE, X_LEG1, X_LEG2, X_TOP);
    private static final VoxelShape Z_AXIS_AABB = VoxelShapes.or(BASE, Z_LEG1, Z_LEG2, Z_TOP);
    private static final IChatBaseComponent CONTAINER_TITLE = IChatBaseComponent.translatable("container.repair");
    private static final float FALL_DAMAGE_PER_DISTANCE = 2.0f;
    private static final int FALL_DAMAGE_MAX = 40;

    public MapCodec<BlockAnvil> codec() {
        return CODEC;
    }

    public BlockAnvil(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getClockWise());
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (var1.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        var3.openMenu(var0.getMenuProvider(var1, var2));
        var3.awardStat(StatisticList.INTERACT_WITH_ANVIL);
        return EnumInteractionResult.CONSUME;
    }

    @Override
    @Nullable
    protected ITileInventory getMenuProvider(IBlockData var0, World var1, BlockPosition var22) {
        return new TileInventory((var2, var3, var4) -> new ContainerAnvil(var2, var3, ContainerAccess.create(var1, var22)), CONTAINER_TITLE);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        EnumDirection var4 = var0.getValue(FACING);
        if (var4.getAxis() == EnumDirection.EnumAxis.X) {
            return X_AXIS_AABB;
        }
        return Z_AXIS_AABB;
    }

    @Override
    protected void falling(EntityFallingBlock var0) {
        var0.setHurtsEntities(2.0f, 40);
    }

    @Override
    public void onLand(World var0, BlockPosition var1, IBlockData var2, IBlockData var3, EntityFallingBlock var4) {
        if (!var4.isSilent()) {
            var0.levelEvent(1031, var1, 0);
        }
    }

    @Override
    public void onBrokenAfterFall(World var0, BlockPosition var1, EntityFallingBlock var2) {
        if (!var2.isSilent()) {
            var0.levelEvent(1029, var1, 0);
        }
    }

    @Override
    public DamageSource getFallDamageSource(Entity var0) {
        return var0.damageSources().anvil(var0);
    }

    @Nullable
    public static IBlockData damage(IBlockData var0) {
        if (var0.is(Blocks.ANVIL)) {
            return (IBlockData)Blocks.CHIPPED_ANVIL.defaultBlockState().setValue(FACING, var0.getValue(FACING));
        }
        if (var0.is(Blocks.CHIPPED_ANVIL)) {
            return (IBlockData)Blocks.DAMAGED_ANVIL.defaultBlockState().setValue(FACING, var0.getValue(FACING));
        }
        return null;
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }

    @Override
    public int getDustColor(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.getMapColor((IBlockAccess)var1, (BlockPosition)var2).col;
    }
}

