/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.AllOf;
import net.minecraft.world.item.enchantment.effects.ApplyMobEffect;
import net.minecraft.world.item.enchantment.effects.DamageEntity;
import net.minecraft.world.item.enchantment.effects.DamageItem;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.ExplodeEffect;
import net.minecraft.world.item.enchantment.effects.Ignite;
import net.minecraft.world.item.enchantment.effects.PlaySoundEffect;
import net.minecraft.world.item.enchantment.effects.ReplaceBlock;
import net.minecraft.world.item.enchantment.effects.ReplaceDisk;
import net.minecraft.world.item.enchantment.effects.RunFunction;
import net.minecraft.world.item.enchantment.effects.SetBlockProperties;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.item.enchantment.effects.SummonEntityEffect;
import net.minecraft.world.phys.Vec3D;

public interface EnchantmentEntityEffect
extends EnchantmentLocationBasedEffect {
    public static final Codec<EnchantmentEntityEffect> CODEC = BuiltInRegistries.ENCHANTMENT_ENTITY_EFFECT_TYPE.byNameCodec().dispatch(EnchantmentEntityEffect::codec, Function.identity());

    public static MapCodec<? extends EnchantmentEntityEffect> bootstrap(IRegistry<MapCodec<? extends EnchantmentEntityEffect>> var0) {
        IRegistry.register(var0, "all_of", AllOf.a.CODEC);
        IRegistry.register(var0, "apply_mob_effect", ApplyMobEffect.CODEC);
        IRegistry.register(var0, "damage_entity", DamageEntity.CODEC);
        IRegistry.register(var0, "damage_item", DamageItem.CODEC);
        IRegistry.register(var0, "explode", ExplodeEffect.CODEC);
        IRegistry.register(var0, "ignite", Ignite.CODEC);
        IRegistry.register(var0, "play_sound", PlaySoundEffect.CODEC);
        IRegistry.register(var0, "replace_block", ReplaceBlock.CODEC);
        IRegistry.register(var0, "replace_disk", ReplaceDisk.CODEC);
        IRegistry.register(var0, "run_function", RunFunction.CODEC);
        IRegistry.register(var0, "set_block_properties", SetBlockProperties.CODEC);
        IRegistry.register(var0, "spawn_particles", SpawnParticlesEffect.CODEC);
        return IRegistry.register(var0, "summon_entity", SummonEntityEffect.CODEC);
    }

    public void apply(WorldServer var1, int var2, EnchantedItemInUse var3, Entity var4, Vec3D var5);

    @Override
    default public void onChangedBlock(WorldServer var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3D var4, boolean var5) {
        this.apply(var0, var1, var2, var3, var4);
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec();
}

