/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class ShapelessRecipes
implements RecipeCrafting {
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final NonNullList<RecipeItemStack> ingredients;

    public ShapelessRecipes(String var0, CraftingBookCategory var1, ItemStack var2, NonNullList<RecipeItemStack> var3) {
        this.group = var0;
        this.category = var1;
        this.result = var2;
        this.ingredients = var3;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHAPELESS_RECIPE;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.a var0) {
        return this.result;
    }

    @Override
    public NonNullList<RecipeItemStack> getIngredients() {
        return this.ingredients;
    }

    @Override
    public boolean matches(CraftingInput var0, World var1) {
        if (var0.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        if (var0.size() == 1 && this.ingredients.size() == 1) {
            return ((RecipeItemStack)this.ingredients.getFirst()).test(var0.getItem(0));
        }
        return var0.stackedContents().canCraft(this, null);
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.a var1) {
        return this.result.copy();
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= this.ingredients.size();
    }

    public static class a
    implements RecipeSerializer<ShapelessRecipes> {
        private static final MapCodec<ShapelessRecipes> CODEC = RecordCodecBuilder.mapCodec(var03 -> var03.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(var0 -> var0.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(var0 -> var0.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(var0 -> var0.result), (App)RecipeItemStack.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(var02 -> {
            RecipeItemStack[] var1 = (RecipeItemStack[])var02.stream().filter(var0 -> !var0.isEmpty()).toArray(RecipeItemStack[]::new);
            if (var1.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            if (var1.length > 9) {
                return DataResult.error(() -> "Too many ingredients for shapeless recipe");
            }
            return DataResult.success(NonNullList.of(RecipeItemStack.EMPTY, var1));
        }, DataResult::success).forGetter(var0 -> var0.ingredients)).apply((Applicative)var03, ShapelessRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipes> STREAM_CODEC = StreamCodec.of(a::toNetwork, a::fromNetwork);

        @Override
        public MapCodec<ShapelessRecipes> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipes> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapelessRecipes fromNetwork(RegistryFriendlyByteBuf var0) {
            String var12 = var0.readUtf();
            CraftingBookCategory var2 = var0.readEnum(CraftingBookCategory.class);
            int var3 = var0.readVarInt();
            NonNullList<RecipeItemStack> var4 = NonNullList.withSize(var3, RecipeItemStack.EMPTY);
            var4.replaceAll(var1 -> (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(var0));
            ItemStack var5 = (ItemStack)ItemStack.STREAM_CODEC.decode(var0);
            return new ShapelessRecipes(var12, var2, var5, var4);
        }

        private static void toNetwork(RegistryFriendlyByteBuf var0, ShapelessRecipes var1) {
            var0.writeUtf(var1.group);
            var0.writeEnum(var1.category);
            var0.writeVarInt(var1.ingredients.size());
            for (RecipeItemStack var3 : var1.ingredients) {
                RecipeItemStack.CONTENTS_STREAM_CODEC.encode(var0, var3);
            }
            ItemStack.STREAM_CODEC.encode(var0, var1.result);
        }
    }
}

