/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import org.slf4j.Logger;

public class CraftingManager
extends ResourceDataJson {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final HolderLookup.a registries;
    public Multimap<Recipes<?>, RecipeHolder<?>> byType = ImmutableMultimap.of();
    private Map<MinecraftKey, RecipeHolder<?>> byName = ImmutableMap.of();
    private boolean hasErrors;

    public CraftingManager(HolderLookup.a var0) {
        super(GSON, Registries.elementsDirPath(Registries.RECIPE));
        this.registries = var0;
    }

    @Override
    protected void apply(Map<MinecraftKey, JsonElement> var0, IResourceManager var1, GameProfilerFiller var2) {
        this.hasErrors = false;
        ImmutableMultimap.Builder var3 = ImmutableMultimap.builder();
        ImmutableMap.Builder var4 = ImmutableMap.builder();
        RegistryOps var5 = this.registries.createSerializationContext(JsonOps.INSTANCE);
        for (Map.Entry<MinecraftKey, JsonElement> var7 : var0.entrySet()) {
            MinecraftKey var8 = var7.getKey();
            try {
                IRecipe var9 = (IRecipe)IRecipe.CODEC.parse(var5, (Object)var7.getValue()).getOrThrow(JsonParseException::new);
                RecipeHolder<IRecipe> var10 = new RecipeHolder<IRecipe>(var8, var9);
                var3.put(var9.getType(), var10);
                var4.put((Object)var8, var10);
            }
            catch (JsonParseException | IllegalArgumentException var9) {
                LOGGER.error("Parsing error loading recipe {}", (Object)var8, (Object)var9);
            }
        }
        this.byType = var3.build();
        this.byName = var4.build();
        LOGGER.info("Loaded {} recipes", (Object)this.byType.size());
    }

    public boolean hadErrorsLoading() {
        return this.hasErrors;
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> getRecipeFor(Recipes<T> var0, I var1, World var2) {
        return this.getRecipeFor(var0, var1, var2, (RecipeHolder)null);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> getRecipeFor(Recipes<T> var0, I var1, World var2, @Nullable MinecraftKey var3) {
        RecipeHolder<T> var4 = var3 != null ? this.byKeyTyped(var0, var3) : null;
        return this.getRecipeFor(var0, var1, var2, var4);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> getRecipeFor(Recipes<T> var0, I var1, World var22, @Nullable RecipeHolder<T> var3) {
        if (var1.isEmpty()) {
            return Optional.empty();
        }
        if (var3 != null && var3.value().matches(var1, var22)) {
            return Optional.of(var3);
        }
        return this.byType(var0).stream().filter(var2 -> var2.value().matches((RecipeInput)var1, var22)).findFirst();
    }

    public <I extends RecipeInput, T extends IRecipe<I>> List<RecipeHolder<T>> getAllRecipesFor(Recipes<T> var0) {
        return List.copyOf(this.byType(var0));
    }

    public <I extends RecipeInput, T extends IRecipe<I>> List<RecipeHolder<T>> getRecipesFor(Recipes<T> var0, I var12, World var22) {
        return this.byType(var0).stream().filter(var2 -> var2.value().matches((RecipeInput)var12, var22)).sorted(Comparator.comparing(var1 -> var1.value().getResultItem(var22.registryAccess()).getDescriptionId())).collect(Collectors.toList());
    }

    private <I extends RecipeInput, T extends IRecipe<I>> Collection<RecipeHolder<T>> byType(Recipes<T> var0) {
        return this.byType.get(var0);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> NonNullList<ItemStack> getRemainingItemsFor(Recipes<T> var0, I var1, World var2) {
        Optional<RecipeHolder<T>> var3 = this.getRecipeFor(var0, var1, var2);
        if (var3.isPresent()) {
            return var3.get().value().getRemainingItems(var1);
        }
        NonNullList<ItemStack> var4 = NonNullList.withSize(var1.size(), ItemStack.EMPTY);
        for (int var5 = 0; var5 < var4.size(); ++var5) {
            var4.set(var5, var1.getItem(var5));
        }
        return var4;
    }

    public Optional<RecipeHolder<?>> byKey(MinecraftKey var0) {
        return Optional.ofNullable(this.byName.get(var0));
    }

    @Nullable
    private <T extends IRecipe<?>> RecipeHolder<T> byKeyTyped(Recipes<T> var0, MinecraftKey var1) {
        RecipeHolder<?> var2 = this.byName.get(var1);
        if (var2 != null && var2.value().getType().equals(var0)) {
            return var2;
        }
        return null;
    }

    public Collection<RecipeHolder<?>> getOrderedRecipes() {
        return this.byType.values();
    }

    public Collection<RecipeHolder<?>> getRecipes() {
        return this.byName.values();
    }

    public Stream<MinecraftKey> getRecipeIds() {
        return this.byName.keySet().stream();
    }

    @VisibleForTesting
    protected static RecipeHolder<?> fromJson(MinecraftKey var0, JsonObject var1, HolderLookup.a var2) {
        IRecipe var3 = (IRecipe)IRecipe.CODEC.parse(var2.createSerializationContext(JsonOps.INSTANCE), (Object)var1).getOrThrow(JsonParseException::new);
        return new RecipeHolder<IRecipe>(var0, var3);
    }

    public void replaceRecipes(Iterable<RecipeHolder<?>> var0) {
        this.hasErrors = false;
        ImmutableMultimap.Builder var1 = ImmutableMultimap.builder();
        ImmutableMap.Builder var2 = ImmutableMap.builder();
        for (RecipeHolder<?> var4 : var0) {
            Recipes<?> var5 = var4.value().getType();
            var1.put(var5, var4);
            var2.put((Object)var4.id(), var4);
        }
        this.byType = var1.build();
        this.byName = var2.build();
    }

    public static <I extends RecipeInput, T extends IRecipe<I>> a<I, T> createCheck(final Recipes<T> var0) {
        return new a<I, T>(){
            @Nullable
            private MinecraftKey lastRecipe;

            @Override
            public Optional<RecipeHolder<T>> getRecipeFor(I var02, World var1) {
                CraftingManager var2 = var1.getRecipeManager();
                Optional var3 = var2.getRecipeFor(var0, var02, var1, this.lastRecipe);
                if (var3.isPresent()) {
                    RecipeHolder var4 = var3.get();
                    this.lastRecipe = var4.id();
                    return Optional.of(var4);
                }
                return Optional.empty();
            }
        };
    }

    public static interface a<I extends RecipeInput, T extends IRecipe<I>> {
        public Optional<RecipeHolder<T>> getRecipeFor(I var1, World var2);
    }
}

