/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class MaceItem
extends Item {
    private static final int DEFAULT_ATTACK_DAMAGE = 5;
    private static final float DEFAULT_ATTACK_SPEED = -3.4f;
    public static final float SMASH_ATTACK_FALL_THRESHOLD = 1.5f;
    private static final float SMASH_ATTACK_HEAVY_THRESHOLD = 5.0f;
    public static final float SMASH_ATTACK_KNOCKBACK_RADIUS = 3.5f;
    private static final float SMASH_ATTACK_KNOCKBACK_POWER = 0.7f;

    public MaceItem(Item.Info var0) {
        super(var0);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(GenericAttributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(GenericAttributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -3.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean canAttackBlock(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        return !var3.isCreative();
    }

    @Override
    public int getEnchantmentValue() {
        return 15;
    }

    @Override
    public boolean hurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
        EntityPlayer var3;
        if (var2 instanceof EntityPlayer && MaceItem.canSmashAttack(var3 = (EntityPlayer)var2)) {
            WorldServer var4 = (WorldServer)var2.level();
            if (var3.isIgnoringFallDamageFromCurrentImpulse() && var3.currentImpulseImpactPos != null) {
                if (var3.currentImpulseImpactPos.y > var3.position().y) {
                    var3.currentImpulseImpactPos = var3.position();
                }
            } else {
                var3.currentImpulseImpactPos = var3.position();
            }
            var3.setIgnoreFallDamageFromCurrentImpulse(true);
            var3.setDeltaMovement(var3.getDeltaMovement().with(EnumDirection.EnumAxis.Y, 0.01f));
            var3.connection.send(new PacketPlayOutEntityVelocity(var3));
            if (var1.onGround()) {
                var3.setSpawnExtraParticlesOnFall(true);
                SoundEffect var5 = var3.fallDistance > 5.0f ? SoundEffects.MACE_SMASH_GROUND_HEAVY : SoundEffects.MACE_SMASH_GROUND;
                var4.playSound(null, var3.getX(), var3.getY(), var3.getZ(), var5, var3.getSoundSource(), 1.0f, 1.0f);
            } else {
                var4.playSound(null, var3.getX(), var3.getY(), var3.getZ(), SoundEffects.MACE_SMASH_AIR, var3.getSoundSource(), 1.0f, 1.0f);
            }
            MaceItem.knockback(var4, var3, var1);
        }
        return true;
    }

    @Override
    public void postHurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
        var0.hurtAndBreak(1, var2, EnumItemSlot.MAINHAND);
        if (MaceItem.canSmashAttack(var2)) {
            var2.resetFallDistance();
        }
    }

    @Override
    public boolean isValidRepairItem(ItemStack var0, ItemStack var1) {
        return var1.is(Items.BREEZE_ROD);
    }

    @Override
    public float getAttackDamageBonus(Entity var0, float var1, DamageSource var2) {
        Entity entity = var2.getDirectEntity();
        if (!(entity instanceof EntityLiving)) {
            return 0.0f;
        }
        EntityLiving var3 = (EntityLiving)entity;
        if (!MaceItem.canSmashAttack(var3)) {
            return 0.0f;
        }
        float var4 = 3.0f;
        float var5 = 8.0f;
        float var6 = var3.fallDistance;
        float var7 = var6 <= 3.0f ? 4.0f * var6 : (var6 <= 8.0f ? 12.0f + 2.0f * (var6 - 3.0f) : 22.0f + var6 - 8.0f);
        World world = var3.level();
        if (world instanceof WorldServer) {
            WorldServer var8 = (WorldServer)world;
            return var7 + EnchantmentManager.modifyFallBasedDamage(var8, var3.getWeaponItem(), var0, var2, 0.0f) * var6;
        }
        return var7;
    }

    private static void knockback(World var0, EntityHuman var1, Entity var22) {
        var0.levelEvent(2013, var22.getOnPos(), 750);
        var0.getEntitiesOfClass(EntityLiving.class, var22.getBoundingBox().inflate(3.5), MaceItem.knockbackPredicate(var1, var22)).forEach(var2 -> {
            Vec3D var3 = var2.position().subtract(var22.position());
            double var4 = MaceItem.getKnockbackPower(var1, var2, var3);
            Vec3D var6 = var3.normalize().scale(var4);
            if (var4 > 0.0) {
                var2.push(var6.x, 0.7f, var6.z);
                if (var2 instanceof EntityPlayer) {
                    EntityPlayer var7 = (EntityPlayer)var2;
                    var7.connection.send(new PacketPlayOutEntityVelocity(var7));
                }
            }
        });
    }

    private static Predicate<EntityLiving> knockbackPredicate(EntityHuman var0, Entity var1) {
        return var2 -> {
            EntityArmorStand var8;
            EntityTameableAnimal var7;
            boolean var3 = !var2.isSpectator();
            boolean var4 = var2 != var0 && var2 != var1;
            boolean var5 = !var0.isAlliedTo((Entity)var2);
            boolean var6 = !(var2 instanceof EntityTameableAnimal && (var7 = (EntityTameableAnimal)var2).isTame() && var0.getUUID().equals(var7.getOwnerUUID()));
            boolean var9 = !(var2 instanceof EntityArmorStand) || !(var8 = (EntityArmorStand)var2).isMarker();
            boolean var10 = var1.distanceToSqr((Entity)var2) <= Math.pow(3.5, 2.0);
            return var3 && var4 && var5 && var6 && var9 && var10;
        };
    }

    private static double getKnockbackPower(EntityHuman var0, EntityLiving var1, Vec3D var2) {
        return (3.5 - var2.length()) * (double)0.7f * (double)(var0.fallDistance > 5.0f ? 2 : 1) * (1.0 - var1.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE));
    }

    public static boolean canSmashAttack(EntityLiving var0) {
        return var0.fallDistance > 1.5f && !var0.isFallFlying();
    }
}

