/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;

public class ItemShield
extends Item
implements Equipable {
    public static final int EFFECTIVE_BLOCK_DELAY = 5;
    public static final float MINIMUM_DURABILITY_DAMAGE = 3.0f;

    public ItemShield(Item.Info var0) {
        super(var0);
        BlockDispenser.registerBehavior(this, ItemArmor.DISPENSE_ITEM_BEHAVIOR);
    }

    @Override
    public String getDescriptionId(ItemStack var0) {
        EnumColor var1 = var0.get(DataComponents.BASE_COLOR);
        if (var1 != null) {
            return this.getDescriptionId() + "." + var1.getName();
        }
        return super.getDescriptionId(var0);
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        ItemBanner.appendHoverTextFromBannerBlockEntityTag(var0, var2);
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.BLOCK;
    }

    @Override
    public int getUseDuration(ItemStack var0, EntityLiving var1) {
        return 72000;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        var1.startUsingItem(var2);
        return InteractionResultWrapper.consume(var3);
    }

    @Override
    public boolean isValidRepairItem(ItemStack var0, ItemStack var1) {
        return var1.is(TagsItem.PLANKS) || super.isValidRepairItem(var0, var1);
    }

    @Override
    public EnumItemSlot getEquipmentSlot() {
        return EnumItemSlot.OFFHAND;
    }
}

