/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.World;

public class ItemPotionThrowable
extends ItemPotion
implements ProjectileItem {
    public ItemPotionThrowable(Item.Info var0) {
        super(var0);
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (!var0.isClientSide) {
            EntityPotion var4 = new EntityPotion(var0, var1);
            var4.setItem(var3);
            var4.shootFromRotation(var1, var1.getXRot(), var1.getYRot(), -20.0f, 0.5f, 1.0f);
            var0.addFreshEntity(var4);
        }
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        var3.consume(1, var1);
        return InteractionResultWrapper.sidedSuccess(var3, var0.isClientSide());
    }

    @Override
    public IProjectile asProjectile(World var0, IPosition var1, ItemStack var2, EnumDirection var3) {
        EntityPotion var4 = new EntityPotion(var0, var1.x(), var1.y(), var1.z());
        var4.setItem(var2);
        return var4;
    }

    @Override
    public ProjectileItem.a createDispenseConfig() {
        return ProjectileItem.a.builder().uncertainty(ProjectileItem.a.DEFAULT.uncertainty() * 0.5f).power(ProjectileItem.a.DEFAULT.power() * 1.25f).build();
    }
}

