/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemHanging
extends Item {
    private static final IChatBaseComponent TOOLTIP_RANDOM_VARIANT = IChatBaseComponent.translatable("painting.random").withStyle(EnumChatFormat.GRAY);
    private final EntityTypes<? extends EntityHanging> type;

    public ItemHanging(EntityTypes<? extends EntityHanging> var0, Item.Info var1) {
        super(var1);
        this.type = var0;
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        EntityHanging var7;
        Optional<EntityPainting> var8;
        BlockPosition var1 = var0.getClickedPos();
        EnumDirection var2 = var0.getClickedFace();
        BlockPosition var3 = var1.relative(var2);
        EntityHuman var4 = var0.getPlayer();
        ItemStack var5 = var0.getItemInHand();
        if (var4 != null && !this.mayPlace(var4, var2, var5, var3)) {
            return EnumInteractionResult.FAIL;
        }
        World var6 = var0.getLevel();
        if (this.type == EntityTypes.PAINTING) {
            var8 = EntityPainting.create(var6, var3, var2);
            if (var8.isEmpty()) {
                return EnumInteractionResult.CONSUME;
            }
            var7 = var8.get();
        } else if (this.type == EntityTypes.ITEM_FRAME) {
            var7 = new EntityItemFrame(var6, var3, var2);
        } else if (this.type == EntityTypes.GLOW_ITEM_FRAME) {
            var7 = new GlowItemFrame(var6, var3, var2);
        } else {
            return EnumInteractionResult.sidedSuccess(var6.isClientSide);
        }
        var8 = var5.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        if (!((CustomData)((Object)var8)).isEmpty()) {
            EntityTypes.updateCustomEntityTag(var6, var4, var7, (CustomData)((Object)var8));
        }
        if (var7.survives()) {
            if (!var6.isClientSide) {
                var7.playPlacementSound();
                var6.gameEvent((Entity)var4, GameEvent.ENTITY_PLACE, var7.position());
                var6.addFreshEntity(var7);
            }
            var5.shrink(1);
            return EnumInteractionResult.sidedSuccess(var6.isClientSide);
        }
        return EnumInteractionResult.CONSUME;
    }

    protected boolean mayPlace(EntityHuman var0, EnumDirection var1, ItemStack var2, BlockPosition var3) {
        return !var1.getAxis().isVertical() && var0.mayUseItemAt(var3, var1, var2);
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        HolderLookup.a var4 = var1.registries();
        if (var4 != null && this.type == EntityTypes.PAINTING) {
            CustomData var5 = var0.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
            if (!var5.isEmpty()) {
                var5.read((DynamicOps<NBTBase>)var4.createSerializationContext(DynamicOpsNBT.INSTANCE), EntityPainting.VARIANT_MAP_CODEC).result().ifPresentOrElse(var12 -> {
                    var12.unwrapKey().ifPresent(var1 -> {
                        var2.add(IChatBaseComponent.translatable(var1.location().toLanguageKey("painting", "title")).withStyle(EnumChatFormat.YELLOW));
                        var2.add(IChatBaseComponent.translatable(var1.location().toLanguageKey("painting", "author")).withStyle(EnumChatFormat.GRAY));
                    });
                    var2.add(IChatBaseComponent.translatable("painting.dimensions", ((PaintingVariant)var12.value()).width(), ((PaintingVariant)var12.value()).height()));
                }, () -> var2.add(TOOLTIP_RANDOM_VARIANT));
            } else if (var3.isCreative()) {
                var2.add(TOOLTIP_RANDOM_VARIANT);
            }
        }
    }
}

