/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class ItemBoat
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = IEntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final EntityBoat.EnumBoatType type;
    private final boolean hasChest;

    public ItemBoat(boolean var0, EntityBoat.EnumBoatType var1, Item.Info var2) {
        super(var2);
        this.hasChest = var0;
        this.type = var1;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        Object var9;
        ItemStack var3 = var1.getItemInHand(var2);
        MovingObjectPositionBlock var4 = ItemBoat.getPlayerPOVHitResult(var0, var1, RayTrace.FluidCollisionOption.ANY);
        if (((MovingObjectPosition)var4).getType() == MovingObjectPosition.EnumMovingObjectType.MISS) {
            return InteractionResultWrapper.pass(var3);
        }
        Vec3D var5 = var1.getViewVector(1.0f);
        double var6 = 5.0;
        List<Entity> var8 = var0.getEntities(var1, var1.getBoundingBox().expandTowards(var5.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!var8.isEmpty()) {
            var9 = var1.getEyePosition();
            for (Entity var11 : var8) {
                AxisAlignedBB var12 = var11.getBoundingBox().inflate(var11.getPickRadius());
                if (!var12.contains((Vec3D)var9)) continue;
                return InteractionResultWrapper.pass(var3);
            }
        }
        if (((MovingObjectPosition)var4).getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            var9 = this.getBoat(var0, var4, var3, var1);
            ((EntityBoat)var9).setVariant(this.type);
            ((Entity)var9).setYRot(var1.getYRot());
            if (!var0.noCollision((Entity)var9, ((Entity)var9).getBoundingBox())) {
                return InteractionResultWrapper.fail(var3);
            }
            if (!var0.isClientSide) {
                var0.addFreshEntity((Entity)var9);
                var0.gameEvent((Entity)var1, GameEvent.ENTITY_PLACE, var4.getLocation());
                var3.consume(1, var1);
            }
            var1.awardStat(StatisticList.ITEM_USED.get(this));
            return InteractionResultWrapper.sidedSuccess(var3, var0.isClientSide());
        }
        return InteractionResultWrapper.pass(var3);
    }

    private EntityBoat getBoat(World var0, MovingObjectPosition var1, ItemStack var2, EntityHuman var3) {
        EntityBoat var5;
        Vec3D var4 = var1.getLocation();
        EntityBoat entityBoat = var5 = this.hasChest ? new ChestBoat(var0, var4.x, var4.y, var4.z) : new EntityBoat(var0, var4.x, var4.y, var4.z);
        if (var0 instanceof WorldServer) {
            WorldServer var6 = (WorldServer)var0;
            EntityTypes.createDefaultStackConfig(var6, var2, var3).accept((ChestBoat)var5);
        }
        return var5;
    }
}

