/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class Item
implements FeatureElement,
IMaterial {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<Block, Item> BY_BLOCK = Maps.newHashMap();
    public static final MinecraftKey BASE_ATTACK_DAMAGE_ID = MinecraftKey.withDefaultNamespace("base_attack_damage");
    public static final MinecraftKey BASE_ATTACK_SPEED_ID = MinecraftKey.withDefaultNamespace("base_attack_speed");
    public static final int DEFAULT_MAX_STACK_SIZE = 64;
    public static final int ABSOLUTE_MAX_STACK_SIZE = 99;
    public static final int MAX_BAR_WIDTH = 13;
    private final Holder.c<Item> builtInRegistryHolder = BuiltInRegistries.ITEM.createIntrusiveHolder(this);
    private final DataComponentMap components;
    @Nullable
    private final Item craftingRemainingItem;
    @Nullable
    private String descriptionId;
    private final FeatureFlagSet requiredFeatures;

    public static int getId(Item var0) {
        return var0 == null ? 0 : BuiltInRegistries.ITEM.getId(var0);
    }

    public static Item byId(int var0) {
        return BuiltInRegistries.ITEM.byId(var0);
    }

    @Deprecated
    public static Item byBlock(Block var0) {
        return BY_BLOCK.getOrDefault(var0, Items.AIR);
    }

    public Item(Info var0) {
        String var1;
        this.components = var0.buildAndValidateComponents();
        this.craftingRemainingItem = var0.craftingRemainingItem;
        this.requiredFeatures = var0.requiredFeatures;
        if (SharedConstants.IS_RUNNING_IN_IDE && !(var1 = this.getClass().getSimpleName()).endsWith("Item")) {
            LOGGER.error("Item classes should end with Item and {} doesn't.", (Object)var1);
        }
    }

    @Deprecated
    public Holder.c<Item> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    public DataComponentMap components() {
        return this.components;
    }

    public int getDefaultMaxStackSize() {
        return this.components.getOrDefault(DataComponents.MAX_STACK_SIZE, 1);
    }

    public void onUseTick(World var0, EntityLiving var1, ItemStack var2, int var3) {
    }

    public void onDestroyed(EntityItem var0) {
    }

    public void verifyComponentsAfterLoad(ItemStack var0) {
    }

    public boolean canAttackBlock(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        return true;
    }

    @Override
    public Item asItem() {
        return this;
    }

    public EnumInteractionResult useOn(ItemActionContext var0) {
        return EnumInteractionResult.PASS;
    }

    public float getDestroySpeed(ItemStack var0, IBlockData var1) {
        Tool var2 = var0.get(DataComponents.TOOL);
        return var2 != null ? var2.getMiningSpeed(var1) : 1.0f;
    }

    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        FoodInfo var4 = var3.get(DataComponents.FOOD);
        if (var4 != null) {
            if (var1.canEat(var4.canAlwaysEat())) {
                var1.startUsingItem(var2);
                return InteractionResultWrapper.consume(var3);
            }
            return InteractionResultWrapper.fail(var3);
        }
        return InteractionResultWrapper.pass(var1.getItemInHand(var2));
    }

    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var2) {
        FoodInfo var3 = var0.get(DataComponents.FOOD);
        if (var3 != null) {
            return var2.eat(var1, var0, var3);
        }
        return var0;
    }

    public boolean isBarVisible(ItemStack var0) {
        return var0.isDamaged();
    }

    public int getBarWidth(ItemStack var0) {
        return MathHelper.clamp(Math.round(13.0f - (float)var0.getDamageValue() * 13.0f / (float)var0.getMaxDamage()), 0, 13);
    }

    public int getBarColor(ItemStack var0) {
        int var1 = var0.getMaxDamage();
        float var2 = Math.max(0.0f, ((float)var1 - (float)var0.getDamageValue()) / (float)var1);
        return MathHelper.hsvToRgb(var2 / 3.0f, 1.0f, 1.0f);
    }

    public boolean overrideStackedOnOther(ItemStack var0, Slot var1, ClickAction var2, EntityHuman var3) {
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack var0, ItemStack var1, Slot var2, ClickAction var3, EntityHuman var4, SlotAccess var5) {
        return false;
    }

    public float getAttackDamageBonus(Entity var0, float var1, DamageSource var2) {
        return 0.0f;
    }

    public boolean hurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
        return false;
    }

    public void postHurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
    }

    public boolean mineBlock(ItemStack var0, World var1, IBlockData var2, BlockPosition var3, EntityLiving var4) {
        Tool var5 = var0.get(DataComponents.TOOL);
        if (var5 == null) {
            return false;
        }
        if (!var1.isClientSide && var2.getDestroySpeed(var1, var3) != 0.0f && var5.damagePerBlock() > 0) {
            var0.hurtAndBreak(var5.damagePerBlock(), var4, EnumItemSlot.MAINHAND);
        }
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack var0, IBlockData var1) {
        Tool var2 = var0.get(DataComponents.TOOL);
        return var2 != null && var2.isCorrectForDrops(var1);
    }

    public EnumInteractionResult interactLivingEntity(ItemStack var0, EntityHuman var1, EntityLiving var2, EnumHand var3) {
        return EnumInteractionResult.PASS;
    }

    public IChatBaseComponent getDescription() {
        return IChatBaseComponent.translatable(this.getDescriptionId());
    }

    public String toString() {
        return BuiltInRegistries.ITEM.wrapAsHolder(this).getRegisteredName();
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = SystemUtils.makeDescriptionId("item", BuiltInRegistries.ITEM.getKey(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public String getDescriptionId(ItemStack var0) {
        return this.getDescriptionId();
    }

    @Nullable
    public final Item getCraftingRemainingItem() {
        return this.craftingRemainingItem;
    }

    public boolean hasCraftingRemainingItem() {
        return this.craftingRemainingItem != null;
    }

    public void inventoryTick(ItemStack var0, World var1, Entity var2, int var3, boolean var4) {
    }

    public void onCraftedBy(ItemStack var0, World var1, EntityHuman var2) {
        this.onCraftedPostProcess(var0, var1);
    }

    public void onCraftedPostProcess(ItemStack var0, World var1) {
    }

    public boolean isComplex() {
        return false;
    }

    public EnumAnimation getUseAnimation(ItemStack var0) {
        return var0.has(DataComponents.FOOD) ? EnumAnimation.EAT : EnumAnimation.NONE;
    }

    public int getUseDuration(ItemStack var0, EntityLiving var1) {
        FoodInfo var2 = var0.get(DataComponents.FOOD);
        if (var2 != null) {
            return var2.eatDurationTicks();
        }
        return 0;
    }

    public void releaseUsing(ItemStack var0, World var1, EntityLiving var2, int var3) {
    }

    public void appendHoverText(ItemStack var0, b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack var0) {
        return Optional.empty();
    }

    public IChatBaseComponent getName(ItemStack var0) {
        return IChatBaseComponent.translatable(this.getDescriptionId(var0));
    }

    public boolean isFoil(ItemStack var0) {
        return var0.isEnchanted();
    }

    public boolean isEnchantable(ItemStack var0) {
        return var0.getMaxStackSize() == 1 && var0.has(DataComponents.MAX_DAMAGE);
    }

    protected static MovingObjectPositionBlock getPlayerPOVHitResult(World var0, EntityHuman var1, RayTrace.FluidCollisionOption var2) {
        Vec3D var3 = var1.getEyePosition();
        Vec3D var4 = var3.add(var1.calculateViewVector(var1.getXRot(), var1.getYRot()).scale(var1.blockInteractionRange()));
        return var0.clip(new RayTrace(var3, var4, RayTrace.BlockCollisionOption.OUTLINE, var2, var1));
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isValidRepairItem(ItemStack var0, ItemStack var1) {
        return false;
    }

    @Deprecated
    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return ItemAttributeModifiers.EMPTY;
    }

    public boolean useOnRelease(ItemStack var0) {
        return false;
    }

    public ItemStack getDefaultInstance() {
        return new ItemStack(this);
    }

    public SoundEffect getDrinkingSound() {
        return SoundEffects.GENERIC_DRINK;
    }

    public SoundEffect getEatingSound() {
        return SoundEffects.GENERIC_EAT;
    }

    public SoundEffect getBreakingSound() {
        return SoundEffects.ITEM_BREAK;
    }

    public boolean canFitInsideContainerItems() {
        return true;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.requiredFeatures;
    }

    public static class Info {
        private static final Interner<DataComponentMap> COMPONENT_INTERNER = Interners.newStrongInterner();
        @Nullable
        private DataComponentMap.a components;
        @Nullable
        Item craftingRemainingItem;
        FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;

        public Info food(FoodInfo var0) {
            return this.component(DataComponents.FOOD, var0);
        }

        public Info stacksTo(int var0) {
            return this.component(DataComponents.MAX_STACK_SIZE, var0);
        }

        public Info durability(int var0) {
            this.component(DataComponents.MAX_DAMAGE, var0);
            this.component(DataComponents.MAX_STACK_SIZE, 1);
            this.component(DataComponents.DAMAGE, 0);
            return this;
        }

        public Info craftRemainder(Item var0) {
            this.craftingRemainingItem = var0;
            return this;
        }

        public Info rarity(EnumItemRarity var0) {
            return this.component(DataComponents.RARITY, var0);
        }

        public Info fireResistant() {
            return this.component(DataComponents.FIRE_RESISTANT, Unit.INSTANCE);
        }

        public Info jukeboxPlayable(ResourceKey<JukeboxSong> var0) {
            return this.component(DataComponents.JUKEBOX_PLAYABLE, new JukeboxPlayable(new EitherHolder<JukeboxSong>(var0), true));
        }

        public Info requiredFeatures(FeatureFlag ... var0) {
            this.requiredFeatures = FeatureFlags.REGISTRY.subset(var0);
            return this;
        }

        public <T> Info component(DataComponentType<T> var0, T var1) {
            if (this.components == null) {
                this.components = DataComponentMap.builder().addAll(DataComponents.COMMON_ITEM_COMPONENTS);
            }
            this.components.set(var0, var1);
            return this;
        }

        public Info attributes(ItemAttributeModifiers var0) {
            return this.component(DataComponents.ATTRIBUTE_MODIFIERS, var0);
        }

        DataComponentMap buildAndValidateComponents() {
            DataComponentMap var0 = this.buildComponents();
            if (var0.has(DataComponents.DAMAGE) && var0.getOrDefault(DataComponents.MAX_STACK_SIZE, 1) > 1) {
                throw new IllegalStateException("Item cannot have both durability and be stackable");
            }
            return var0;
        }

        private DataComponentMap buildComponents() {
            if (this.components == null) {
                return DataComponents.COMMON_ITEM_COMPONENTS;
            }
            return (DataComponentMap)COMPONENT_INTERNER.intern((Object)this.components.build());
        }
    }

    public static interface b {
        public static final b EMPTY = new b(){

            @Override
            @Nullable
            public HolderLookup.a registries() {
                return null;
            }

            @Override
            public float tickRate() {
                return 20.0f;
            }

            @Override
            @Nullable
            public WorldMap mapData(MapId var0) {
                return null;
            }
        };

        @Nullable
        public HolderLookup.a registries();

        public float tickRate();

        @Nullable
        public WorldMap mapData(MapId var1);

        public static b of(final @Nullable World var0) {
            if (var0 == null) {
                return EMPTY;
            }
            return new b(){

                @Override
                public HolderLookup.a registries() {
                    return var0.registryAccess();
                }

                @Override
                public float tickRate() {
                    return var0.tickRateManager().tickrate();
                }

                @Override
                public WorldMap mapData(MapId var02) {
                    return var0.getMapData(var02);
                }
            };
        }

        public static b of(final HolderLookup.a var0) {
            return new b(){

                @Override
                public HolderLookup.a registries() {
                    return var0;
                }

                @Override
                public float tickRate() {
                    return 20.0f;
                }

                @Override
                @Nullable
                public WorldMap mapData(MapId var02) {
                    return null;
                }
            };
        }
    }
}

