/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;

public class ContainerWorkbench
extends ContainerRecipeBook<CraftingInput, RecipeCrafting> {
    public static final int RESULT_SLOT = 0;
    private static final int CRAFT_SLOT_START = 1;
    private static final int CRAFT_SLOT_END = 10;
    private static final int INV_SLOT_START = 10;
    private static final int INV_SLOT_END = 37;
    private static final int USE_ROW_SLOT_START = 37;
    private static final int USE_ROW_SLOT_END = 46;
    public final InventoryCrafting craftSlots = new TransientCraftingContainer(this, 3, 3);
    public final InventoryCraftResult resultSlots = new InventoryCraftResult();
    public final ContainerAccess access;
    private final EntityHuman player;
    private boolean placingRecipe;

    public ContainerWorkbench(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerWorkbench(int var0, PlayerInventory var1, ContainerAccess var2) {
        super(Containers.CRAFTING, var0);
        int var4;
        int var3;
        this.access = var2;
        this.player = var1.player;
        this.addSlot(new SlotResult(var1.player, this.craftSlots, this.resultSlots, 0, 124, 35));
        for (var3 = 0; var3 < 3; ++var3) {
            for (var4 = 0; var4 < 3; ++var4) {
                this.addSlot(new Slot(this.craftSlots, var4 + var3 * 3, 30 + var4 * 18, 17 + var3 * 18));
            }
        }
        for (var3 = 0; var3 < 3; ++var3) {
            for (var4 = 0; var4 < 9; ++var4) {
                this.addSlot(new Slot(var1, var4 + var3 * 9 + 9, 8 + var4 * 18, 84 + var3 * 18));
            }
        }
        for (var3 = 0; var3 < 9; ++var3) {
            this.addSlot(new Slot(var1, var3, 8 + var3 * 18, 142));
        }
    }

    protected static void slotChangedCraftingGrid(Container var0, World var1, EntityHuman var2, InventoryCrafting var3, InventoryCraftResult var4, @Nullable RecipeHolder<RecipeCrafting> var5) {
        if (var1.isClientSide) {
            return;
        }
        CraftingInput var6 = var3.asCraftInput();
        EntityPlayer var7 = (EntityPlayer)var2;
        ItemStack var8 = ItemStack.EMPTY;
        Optional<RecipeHolder<RecipeCrafting>> var9 = var1.getServer().getRecipeManager().getRecipeFor(Recipes.CRAFTING, var6, var1, var5);
        if (var9.isPresent()) {
            ItemStack var12;
            RecipeHolder<RecipeCrafting> var10 = var9.get();
            RecipeCrafting var11 = var10.value();
            if (var4.setRecipeUsed(var1, var7, var10) && (var12 = var11.assemble(var6, var1.registryAccess())).isItemEnabled(var1.enabledFeatures())) {
                var8 = var12;
            }
        }
        var4.setItem(0, var8);
        var0.setRemoteSlot(0, var8);
        var7.connection.send(new PacketPlayOutSetSlot(var0.containerId, var0.incrementStateId(), 0, var8));
    }

    @Override
    public void slotsChanged(IInventory var02) {
        if (!this.placingRecipe) {
            this.access.execute((var0, var1) -> ContainerWorkbench.slotChangedCraftingGrid(this, var0, this.player, this.craftSlots, this.resultSlots, null));
        }
    }

    @Override
    public void beginPlacingRecipe() {
        this.placingRecipe = true;
    }

    @Override
    public void finishPlacingRecipe(RecipeHolder<RecipeCrafting> var0) {
        this.placingRecipe = false;
        this.access.execute((var1, var2) -> ContainerWorkbench.slotChangedCraftingGrid(this, var1, this.player, this.craftSlots, this.resultSlots, var0));
    }

    @Override
    public void fillCraftSlotsStackedContents(AutoRecipeStackManager var0) {
        this.craftSlots.fillStackedContents(var0);
    }

    @Override
    public void clearCraftingContent() {
        this.craftSlots.clearContent();
        this.resultSlots.clearContent();
    }

    @Override
    public boolean recipeMatches(RecipeHolder<RecipeCrafting> var0) {
        return var0.value().matches(this.craftSlots.asCraftInput(), this.player.level());
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.access.execute((var1, var2) -> this.clearContainer(var0, this.craftSlots));
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return ContainerWorkbench.stillValid(this.access, var0, Blocks.CRAFTING_TABLE);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var22 = ItemStack.EMPTY;
        Slot var32 = (Slot)this.slots.get(var1);
        if (var32 != null && var32.hasItem()) {
            ItemStack var4 = var32.getItem();
            var22 = var4.copy();
            if (var1 == 0) {
                this.access.execute((var2, var3) -> var4.getItem().onCraftedBy(var4, (World)var2, var0));
                if (!this.moveItemStackTo(var4, 10, 46, true)) {
                    return ItemStack.EMPTY;
                }
                var32.onQuickCraft(var4, var22);
            } else if (var1 >= 10 && var1 < 46 ? !this.moveItemStackTo(var4, 1, 10, false) && (var1 < 37 ? !this.moveItemStackTo(var4, 37, 46, false) : !this.moveItemStackTo(var4, 10, 37, false)) : !this.moveItemStackTo(var4, 10, 46, false)) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var32.setByPlayer(ItemStack.EMPTY);
            } else {
                var32.setChanged();
            }
            if (var4.getCount() == var22.getCount()) {
                return ItemStack.EMPTY;
            }
            var32.onTake(var0, var4);
            if (var1 == 0) {
                var0.drop(var4, false);
            }
        }
        return var22;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack var0, Slot var1) {
        return var1.container != this.resultSlots && super.canTakeItemForPickAll(var0, var1);
    }

    @Override
    public int getResultSlotIndex() {
        return 0;
    }

    @Override
    public int getGridWidth() {
        return this.craftSlots.getWidth();
    }

    @Override
    public int getGridHeight() {
        return this.craftSlots.getHeight();
    }

    @Override
    public int getSize() {
        return 10;
    }

    @Override
    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    @Override
    public boolean shouldMoveToInventory(int var0) {
        return var0 != this.getResultSlotIndex();
    }
}

