/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvilAbstract;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class ContainerSmithing
extends ContainerAnvilAbstract {
    public static final int TEMPLATE_SLOT = 0;
    public static final int BASE_SLOT = 1;
    public static final int ADDITIONAL_SLOT = 2;
    public static final int RESULT_SLOT = 3;
    public static final int TEMPLATE_SLOT_X_PLACEMENT = 8;
    public static final int BASE_SLOT_X_PLACEMENT = 26;
    public static final int ADDITIONAL_SLOT_X_PLACEMENT = 44;
    private static final int RESULT_SLOT_X_PLACEMENT = 98;
    public static final int SLOT_Y_PLACEMENT = 48;
    private final World level;
    @Nullable
    private RecipeHolder<SmithingRecipe> selectedRecipe;
    private final List<RecipeHolder<SmithingRecipe>> recipes;

    public ContainerSmithing(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerSmithing(int var0, PlayerInventory var1, ContainerAccess var2) {
        super(Containers.SMITHING, var0, var1, var2);
        this.level = var1.player.level();
        this.recipes = this.level.getRecipeManager().getAllRecipesFor(Recipes.SMITHING);
    }

    @Override
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 8, 48, var0 -> this.recipes.stream().anyMatch(var1 -> ((SmithingRecipe)var1.value()).isTemplateIngredient((ItemStack)var0))).withSlot(1, 26, 48, var0 -> this.recipes.stream().anyMatch(var1 -> ((SmithingRecipe)var1.value()).isBaseIngredient((ItemStack)var0))).withSlot(2, 44, 48, var0 -> this.recipes.stream().anyMatch(var1 -> ((SmithingRecipe)var1.value()).isAdditionIngredient((ItemStack)var0))).withResultSlot(3, 98, 48).build();
    }

    @Override
    protected boolean isValidBlock(IBlockData var0) {
        return var0.is(Blocks.SMITHING_TABLE);
    }

    @Override
    protected boolean mayPickup(EntityHuman var0, boolean var1) {
        return this.selectedRecipe != null && this.selectedRecipe.value().matches(this.createRecipeInput(), this.level);
    }

    @Override
    protected void onTake(EntityHuman var02, ItemStack var12) {
        var12.onCraftedBy(var02.level(), var02, var12.getCount());
        this.resultSlots.awardUsedRecipes(var02, this.getRelevantItems());
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.shrinkStackInSlot(2);
        this.access.execute((var0, var1) -> var0.levelEvent(1044, (BlockPosition)var1, 0));
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.inputSlots.getItem(0), this.inputSlots.getItem(1), this.inputSlots.getItem(2));
    }

    private SmithingRecipeInput createRecipeInput() {
        return new SmithingRecipeInput(this.inputSlots.getItem(0), this.inputSlots.getItem(1), this.inputSlots.getItem(2));
    }

    private void shrinkStackInSlot(int var0) {
        ItemStack var1 = this.inputSlots.getItem(var0);
        if (!var1.isEmpty()) {
            var1.shrink(1);
            this.inputSlots.setItem(var0, var1);
        }
    }

    @Override
    public void createResult() {
        SmithingRecipeInput var0 = this.createRecipeInput();
        List<RecipeHolder<SmithingRecipe>> var1 = this.level.getRecipeManager().getRecipesFor(Recipes.SMITHING, var0, this.level);
        if (var1.isEmpty()) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        } else {
            RecipeHolder<SmithingRecipe> var2 = var1.get(0);
            ItemStack var3 = var2.value().assemble(var0, this.level.registryAccess());
            if (var3.isItemEnabled(this.level.enabledFeatures())) {
                this.selectedRecipe = var2;
                this.resultSlots.setRecipeUsed(var2);
                this.resultSlots.setItem(0, var3);
            }
        }
    }

    @Override
    public int getSlotToQuickMoveTo(ItemStack var0) {
        return this.findSlotToQuickMoveTo(var0).orElse(0);
    }

    private static OptionalInt findSlotMatchingIngredient(SmithingRecipe var0, ItemStack var1) {
        if (var0.isTemplateIngredient(var1)) {
            return OptionalInt.of(0);
        }
        if (var0.isBaseIngredient(var1)) {
            return OptionalInt.of(1);
        }
        if (var0.isAdditionIngredient(var1)) {
            return OptionalInt.of(2);
        }
        return OptionalInt.empty();
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack var0, Slot var1) {
        return var1.container != this.resultSlots && super.canTakeItemForPickAll(var0, var1);
    }

    @Override
    public boolean canMoveIntoInputSlots(ItemStack var0) {
        return this.findSlotToQuickMoveTo(var0).isPresent();
    }

    private OptionalInt findSlotToQuickMoveTo(ItemStack var02) {
        return this.recipes.stream().flatMapToInt(var1 -> ContainerSmithing.findSlotMatchingIngredient((SmithingRecipe)var1.value(), var02).stream()).filter(var0 -> !this.getSlot(var0).hasItem()).findFirst();
    }
}

