/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityFlying;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityGhast
extends EntityFlying
implements IMonster {
    private static final DataWatcherObject<Boolean> DATA_IS_CHARGING = DataWatcher.defineId(EntityGhast.class, DataWatcherRegistry.BOOLEAN);
    private int explosionPower = 1;

    public EntityGhast(EntityTypes<? extends EntityGhast> var0, World var1) {
        super((EntityTypes<? extends EntityFlying>)var0, var1);
        this.xpReward = 5;
        this.moveControl = new ControllerGhast(this);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(5, new PathfinderGoalGhastIdleMove(this));
        this.goalSelector.addGoal(7, new PathfinderGoalGhastMoveTowardsTarget(this));
        this.goalSelector.addGoal(7, new PathfinderGoalGhastAttackTarget(this));
        this.targetSelector.addGoal(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, var0 -> Math.abs(var0.getY() - this.getY()) <= 4.0));
    }

    public boolean isCharging() {
        return this.entityData.get(DATA_IS_CHARGING);
    }

    public void setCharging(boolean var0) {
        this.entityData.set(DATA_IS_CHARGING, var0);
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    @Override
    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    private static boolean isReflectedFireball(DamageSource var0) {
        return var0.getDirectEntity() instanceof EntityLargeFireball && var0.getEntity() instanceof EntityHuman;
    }

    @Override
    public boolean isInvulnerableTo(DamageSource var0) {
        return this.isInvulnerable() && !var0.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || !EntityGhast.isReflectedFireball(var0) && super.isInvulnerableTo(var0);
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (EntityGhast.isReflectedFireball(var0)) {
            super.hurt(var0, 1000.0f);
            return true;
        }
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        return super.hurt(var0, var1);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_IS_CHARGING, false);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 10.0).add(GenericAttributes.FOLLOW_RANGE, 100.0);
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.GHAST_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.GHAST_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.GHAST_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public static boolean checkGhastSpawnRules(EntityTypes<EntityGhast> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        return var1.getDifficulty() != EnumDifficulty.PEACEFUL && var4.nextInt(20) == 0 && EntityGhast.checkMobSpawnRules(var0, var1, var2, var3, var4);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putByte("ExplosionPower", (byte)this.explosionPower);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("ExplosionPower", 99)) {
            this.explosionPower = var0.getByte("ExplosionPower");
        }
    }

    static class ControllerGhast
    extends ControllerMove {
        private final EntityGhast ghast;
        private int floatDuration;

        public ControllerGhast(EntityGhast var0) {
            super(var0);
            this.ghast = var0;
        }

        @Override
        public void tick() {
            if (this.operation != ControllerMove.Operation.MOVE_TO) {
                return;
            }
            if (this.floatDuration-- <= 0) {
                this.floatDuration += this.ghast.getRandom().nextInt(5) + 2;
                Vec3D var0 = new Vec3D(this.wantedX - this.ghast.getX(), this.wantedY - this.ghast.getY(), this.wantedZ - this.ghast.getZ());
                double var1 = var0.length();
                if (this.canReach(var0 = var0.normalize(), MathHelper.ceil(var1))) {
                    this.ghast.setDeltaMovement(this.ghast.getDeltaMovement().add(var0.scale(0.1)));
                } else {
                    this.operation = ControllerMove.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3D var0, int var1) {
            AxisAlignedBB var2 = this.ghast.getBoundingBox();
            for (int var3 = 1; var3 < var1; ++var3) {
                var2 = var2.move(var0);
                if (this.ghast.level().noCollision(this.ghast, var2)) continue;
                return false;
            }
            return true;
        }
    }

    static class PathfinderGoalGhastIdleMove
    extends PathfinderGoal {
        private final EntityGhast ghast;

        public PathfinderGoalGhastIdleMove(EntityGhast var0) {
            this.ghast = var0;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            double var5;
            double var3;
            ControllerMove var0 = this.ghast.getMoveControl();
            if (!var0.hasWanted()) {
                return true;
            }
            double var1 = var0.getWantedX() - this.ghast.getX();
            double var7 = var1 * var1 + (var3 = var0.getWantedY() - this.ghast.getY()) * var3 + (var5 = var0.getWantedZ() - this.ghast.getZ()) * var5;
            return var7 < 1.0 || var7 > 3600.0;
        }

        @Override
        public boolean canContinueToUse() {
            return false;
        }

        @Override
        public void start() {
            RandomSource var0 = this.ghast.getRandom();
            double var1 = this.ghast.getX() + (double)((var0.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double var3 = this.ghast.getY() + (double)((var0.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double var5 = this.ghast.getZ() + (double)((var0.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.ghast.getMoveControl().setWantedPosition(var1, var3, var5, 1.0);
        }
    }

    static class PathfinderGoalGhastMoveTowardsTarget
    extends PathfinderGoal {
        private final EntityGhast ghast;

        public PathfinderGoalGhastMoveTowardsTarget(EntityGhast var0) {
            this.ghast = var0;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            return true;
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            if (this.ghast.getTarget() == null) {
                Vec3D var0 = this.ghast.getDeltaMovement();
                this.ghast.setYRot(-((float)MathHelper.atan2(var0.x, var0.z)) * 57.295776f);
                this.ghast.yBodyRot = this.ghast.getYRot();
            } else {
                EntityLiving var0 = this.ghast.getTarget();
                double var1 = 64.0;
                if (var0.distanceToSqr(this.ghast) < 4096.0) {
                    double var3 = var0.getX() - this.ghast.getX();
                    double var5 = var0.getZ() - this.ghast.getZ();
                    this.ghast.setYRot(-((float)MathHelper.atan2(var3, var5)) * 57.295776f);
                    this.ghast.yBodyRot = this.ghast.getYRot();
                }
            }
        }
    }

    static class PathfinderGoalGhastAttackTarget
    extends PathfinderGoal {
        private final EntityGhast ghast;
        public int chargeTime;

        public PathfinderGoalGhastAttackTarget(EntityGhast var0) {
            this.ghast = var0;
        }

        @Override
        public boolean canUse() {
            return this.ghast.getTarget() != null;
        }

        @Override
        public void start() {
            this.chargeTime = 0;
        }

        @Override
        public void stop() {
            this.ghast.setCharging(false);
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            EntityLiving var0 = this.ghast.getTarget();
            if (var0 == null) {
                return;
            }
            double var1 = 64.0;
            if (var0.distanceToSqr(this.ghast) < 4096.0 && this.ghast.hasLineOfSight(var0)) {
                World var3 = this.ghast.level();
                ++this.chargeTime;
                if (this.chargeTime == 10 && !this.ghast.isSilent()) {
                    var3.levelEvent(null, 1015, this.ghast.blockPosition(), 0);
                }
                if (this.chargeTime == 20) {
                    double var4 = 4.0;
                    Vec3D var6 = this.ghast.getViewVector(1.0f);
                    double var7 = var0.getX() - (this.ghast.getX() + var6.x * 4.0);
                    double var9 = var0.getY(0.5) - (0.5 + this.ghast.getY(0.5));
                    double var11 = var0.getZ() - (this.ghast.getZ() + var6.z * 4.0);
                    Vec3D var13 = new Vec3D(var7, var9, var11);
                    if (!this.ghast.isSilent()) {
                        var3.levelEvent(null, 1016, this.ghast.blockPosition(), 0);
                    }
                    EntityLargeFireball var14 = new EntityLargeFireball(var3, (EntityLiving)this.ghast, var13.normalize(), this.ghast.getExplosionPower());
                    var14.setPos(this.ghast.getX() + var6.x * 4.0, this.ghast.getY(0.5) + 0.5, var14.getZ() + var6.z * 4.0);
                    var3.addFreshEntity(var14);
                    this.chargeTime = -40;
                }
            } else if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            this.ghast.setCharging(this.chargeTime > 10);
        }
    }
}

