/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.pathfinder.PathEntity;

public class BehaviorLeaveJob {
    public static BehaviorControl<EntityVillager> create(float var0) {
        return BehaviorBuilder.create(var1 -> var1.group(var1.present(MemoryModuleType.POTENTIAL_JOB_SITE), var1.absent(MemoryModuleType.JOB_SITE), var1.present(MemoryModuleType.NEAREST_LIVING_ENTITIES), var1.registered(MemoryModuleType.WALK_TARGET), var1.registered(MemoryModuleType.LOOK_TARGET)).apply((Applicative)var1, (var2, var3, var4, var5, var6) -> (var62, var7, var8) -> {
            if (var7.isBaby()) {
                return false;
            }
            if (var7.getVillagerData().getProfession() != VillagerProfession.NONE) {
                return false;
            }
            BlockPosition var10 = ((GlobalPos)var1.get(var2)).pos();
            Optional<Holder<VillagePlaceType>> var11 = var62.getPoiManager().getType(var10);
            if (var11.isEmpty()) {
                return true;
            }
            ((List)var1.get(var4)).stream().filter(var1 -> var1 instanceof EntityVillager && var1 != var7).map(var0 -> (EntityVillager)var0).filter(EntityLiving::isAlive).filter(var2 -> BehaviorLeaveJob.nearbyWantsJobsite((Holder)var11.get(), var2, var10)).findFirst().ifPresent(var6 -> {
                var5.erase();
                var6.erase();
                var2.erase();
                if (var6.getBrain().getMemory(MemoryModuleType.JOB_SITE).isEmpty()) {
                    BehaviorUtil.setWalkAndLookTargetMemories((EntityLiving)var6, var10, var0, 1);
                    var6.getBrain().setMemory(MemoryModuleType.POTENTIAL_JOB_SITE, GlobalPos.of(var62.dimension(), var10));
                    PacketDebug.sendPoiTicketCountPacket(var62, var10);
                }
            });
            return true;
        }));
    }

    private static boolean nearbyWantsJobsite(Holder<VillagePlaceType> var0, EntityVillager var1, BlockPosition var2) {
        boolean var3 = var1.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE).isPresent();
        if (var3) {
            return false;
        }
        Optional<GlobalPos> var4 = var1.getBrain().getMemory(MemoryModuleType.JOB_SITE);
        VillagerProfession var5 = var1.getVillagerData().getProfession();
        if (var5.heldJobSite().test(var0)) {
            if (var4.isEmpty()) {
                return BehaviorLeaveJob.canReachPos(var1, var2, var0.value());
            }
            return var4.get().pos().equals(var2);
        }
        return false;
    }

    private static boolean canReachPos(EntityCreature var0, BlockPosition var1, VillagePlaceType var2) {
        PathEntity var3 = var0.getNavigation().createPath(var1, var2.validRange());
        return var3 != null && var3.canReach();
    }
}

