/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.pathfinder.PathEntity;
import org.apache.commons.lang3.mutable.MutableLong;

public class BehaviorFindPosition {
    public static final int SCAN_RANGE = 48;

    public static BehaviorControl<EntityCreature> create(Predicate<Holder<VillagePlaceType>> var0, MemoryModuleType<GlobalPos> var1, boolean var2, Optional<Byte> var3) {
        return BehaviorFindPosition.create(var0, var1, var1, var2, var3);
    }

    public static BehaviorControl<EntityCreature> create(Predicate<Holder<VillagePlaceType>> var0, MemoryModuleType<GlobalPos> var1, MemoryModuleType<GlobalPos> var22, boolean var3, Optional<Byte> var4) {
        int var5 = 5;
        int var6 = 20;
        MutableLong var7 = new MutableLong(0L);
        Long2ObjectOpenHashMap var8 = new Long2ObjectOpenHashMap();
        OneShot<EntityCreature> var9 = BehaviorBuilder.create(arg_0 -> BehaviorFindPosition.a(var22, var3, var7, (Long2ObjectMap)var8, var0, var4, arg_0));
        if (var22 == var1) {
            return var9;
        }
        return BehaviorBuilder.create(var2 -> var2.group(var2.absent(var1)).apply((Applicative)var2, var1 -> var9));
    }

    @Nullable
    public static PathEntity findPathToPois(EntityInsentient var0, Set<Pair<Holder<VillagePlaceType>, BlockPosition>> var1) {
        if (var1.isEmpty()) {
            return null;
        }
        HashSet<BlockPosition> var2 = new HashSet<BlockPosition>();
        int var3 = 1;
        for (Pair<Holder<VillagePlaceType>, BlockPosition> var5 : var1) {
            var3 = Math.max(var3, ((VillagePlaceType)((Holder)var5.getFirst()).value()).validRange());
            var2.add((BlockPosition)var5.getSecond());
        }
        return var0.getNavigation().createPath(var2, var3);
    }

    private static /* synthetic */ App a(MemoryModuleType var0, boolean var1, MutableLong var2, Long2ObjectMap var3, Predicate var4, Optional var52, BehaviorBuilder.b var6) {
        return var6.group(var6.absent(var0)).apply((Applicative)var6, var5 -> (var6, var7, var82) -> {
            if (var1 && var7.isBaby()) {
                return false;
            }
            if (var2.getValue() == 0L) {
                var2.setValue(var6.getGameTime() + (long)var6.random.nextInt(20));
                return false;
            }
            if (var6.getGameTime() < var2.getValue()) {
                return false;
            }
            var2.setValue(var82 + 20L + (long)var6.getRandom().nextInt(20));
            VillagePlace var10 = var6.getPoiManager();
            var3.long2ObjectEntrySet().removeIf(var2 -> !((a)var2.getValue()).isStillValid(var82));
            Predicate<BlockPosition> var11 = var3 -> {
                a var4 = (a)var3.get(var3.asLong());
                if (var4 == null) {
                    return true;
                }
                if (!var4.shouldRetry(var82)) {
                    return false;
                }
                var4.markAttempt(var82);
                return true;
            };
            Set<Pair<Holder<VillagePlaceType>, BlockPosition>> var12 = var10.findAllClosestFirstWithType(var4, var11, var7.blockPosition(), 48, VillagePlace.Occupancy.HAS_SPACE).limit(5L).collect(Collectors.toSet());
            PathEntity var13 = BehaviorFindPosition.findPathToPois(var7, var12);
            if (var13 != null && var13.canReach()) {
                BlockPosition var14 = var13.getTarget();
                var10.getType(var14).ifPresent(var8 -> {
                    var10.take(var4, (var1, var2) -> var2.equals(var14), var14, 1);
                    var5.set(GlobalPos.of(var6.dimension(), var14));
                    var52.ifPresent(var2 -> var6.broadcastEntityEvent(var7, (byte)var2));
                    var3.clear();
                    PacketDebug.sendPoiTicketCountPacket(var6, var14);
                });
            } else {
                for (Pair<Holder<VillagePlaceType>, BlockPosition> var15 : var12) {
                    var3.computeIfAbsent(((BlockPosition)var15.getSecond()).asLong(), var3 -> new a(var0.random, var82));
                }
            }
            return true;
        });
    }

    static class a {
        private static final int MIN_INTERVAL_INCREASE = 40;
        private static final int MAX_INTERVAL_INCREASE = 80;
        private static final int MAX_RETRY_PATHFINDING_INTERVAL = 400;
        private final RandomSource random;
        private long previousAttemptTimestamp;
        private long nextScheduledAttemptTimestamp;
        private int currentDelay;

        a(RandomSource var0, long var1) {
            this.random = var0;
            this.markAttempt(var1);
        }

        public void markAttempt(long var0) {
            this.previousAttemptTimestamp = var0;
            int var2 = this.currentDelay + this.random.nextInt(40) + 40;
            this.currentDelay = Math.min(var2, 400);
            this.nextScheduledAttemptTimestamp = var0 + (long)this.currentDelay;
        }

        public boolean isStillValid(long var0) {
            return var0 - this.previousAttemptTimestamp < 400L;
        }

        public boolean shouldRetry(long var0) {
            return var0 >= this.nextScheduledAttemptTimestamp;
        }

        public String toString() {
            return "RetryMarker{, previousAttemptAt=" + this.previousAttemptTimestamp + ", nextScheduledAttemptAt=" + this.nextScheduledAttemptTimestamp + ", currentDelay=" + this.currentDelay + "}";
        }
    }
}

