/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeModifiable {
    private static final String BASE_FIELD = "base";
    private static final String MODIFIERS_FIELD = "modifiers";
    public static final String ID_FIELD = "id";
    private final Holder<AttributeBase> attribute;
    private final Map<AttributeModifier.Operation, Map<MinecraftKey, AttributeModifier>> modifiersByOperation = Maps.newEnumMap(AttributeModifier.Operation.class);
    private final Map<MinecraftKey, AttributeModifier> modifierById = new Object2ObjectArrayMap();
    private final Map<MinecraftKey, AttributeModifier> permanentModifiers = new Object2ObjectArrayMap();
    private double baseValue;
    private boolean dirty = true;
    private double cachedValue;
    private final Consumer<AttributeModifiable> onDirty;

    public AttributeModifiable(Holder<AttributeBase> var0, Consumer<AttributeModifiable> var1) {
        this.attribute = var0;
        this.onDirty = var1;
        this.baseValue = var0.value().getDefaultValue();
    }

    public Holder<AttributeBase> getAttribute() {
        return this.attribute;
    }

    public double getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(double var0) {
        if (var0 == this.baseValue) {
            return;
        }
        this.baseValue = var0;
        this.setDirty();
    }

    @VisibleForTesting
    Map<MinecraftKey, AttributeModifier> getModifiers(AttributeModifier.Operation var02) {
        return this.modifiersByOperation.computeIfAbsent(var02, var0 -> new Object2ObjectOpenHashMap());
    }

    public Set<AttributeModifier> getModifiers() {
        return ImmutableSet.copyOf(this.modifierById.values());
    }

    @Nullable
    public AttributeModifier getModifier(MinecraftKey var0) {
        return this.modifierById.get(var0);
    }

    public boolean hasModifier(MinecraftKey var0) {
        return this.modifierById.get(var0) != null;
    }

    private void addModifier(AttributeModifier var0) {
        AttributeModifier var1 = this.modifierById.putIfAbsent(var0.id(), var0);
        if (var1 != null) {
            throw new IllegalArgumentException("Modifier is already applied on this attribute!");
        }
        this.getModifiers(var0.operation()).put(var0.id(), var0);
        this.setDirty();
    }

    public void addOrUpdateTransientModifier(AttributeModifier var0) {
        AttributeModifier var1 = this.modifierById.put(var0.id(), var0);
        if (var0 == var1) {
            return;
        }
        this.getModifiers(var0.operation()).put(var0.id(), var0);
        this.setDirty();
    }

    public void addTransientModifier(AttributeModifier var0) {
        this.addModifier(var0);
    }

    public void addOrReplacePermanentModifier(AttributeModifier var0) {
        this.removeModifier(var0.id());
        this.addModifier(var0);
        this.permanentModifiers.put(var0.id(), var0);
    }

    public void addPermanentModifier(AttributeModifier var0) {
        this.addModifier(var0);
        this.permanentModifiers.put(var0.id(), var0);
    }

    protected void setDirty() {
        this.dirty = true;
        this.onDirty.accept(this);
    }

    public void removeModifier(AttributeModifier var0) {
        this.removeModifier(var0.id());
    }

    public boolean removeModifier(MinecraftKey var0) {
        AttributeModifier var1 = this.modifierById.remove(var0);
        if (var1 == null) {
            return false;
        }
        this.getModifiers(var1.operation()).remove(var0);
        this.permanentModifiers.remove(var0);
        this.setDirty();
        return true;
    }

    public void removeModifiers() {
        for (AttributeModifier var1 : this.getModifiers()) {
            this.removeModifier(var1);
        }
    }

    public double getValue() {
        if (this.dirty) {
            this.cachedValue = this.calculateValue();
            this.dirty = false;
        }
        return this.cachedValue;
    }

    private double calculateValue() {
        double var0 = this.getBaseValue();
        for (AttributeModifier var3 : this.getModifiersOrEmpty(AttributeModifier.Operation.ADD_VALUE)) {
            var0 += var3.amount();
        }
        double var2 = var0;
        for (AttributeModifier var5 : this.getModifiersOrEmpty(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
            var2 += var0 * var5.amount();
        }
        for (AttributeModifier var5 : this.getModifiersOrEmpty(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
            var2 *= 1.0 + var5.amount();
        }
        return this.attribute.value().sanitizeValue(var2);
    }

    private Collection<AttributeModifier> getModifiersOrEmpty(AttributeModifier.Operation var0) {
        return this.modifiersByOperation.getOrDefault(var0, Map.of()).values();
    }

    public void replaceFrom(AttributeModifiable var02) {
        this.baseValue = var02.baseValue;
        this.modifierById.clear();
        this.modifierById.putAll(var02.modifierById);
        this.permanentModifiers.clear();
        this.permanentModifiers.putAll(var02.permanentModifiers);
        this.modifiersByOperation.clear();
        var02.modifiersByOperation.forEach((var0, var1) -> this.getModifiers((AttributeModifier.Operation)var0).putAll((Map<MinecraftKey, AttributeModifier>)var1));
        this.setDirty();
    }

    public NBTTagCompound save() {
        NBTTagCompound var0 = new NBTTagCompound();
        ResourceKey<AttributeBase> var1 = this.attribute.unwrapKey().orElseThrow(() -> new IllegalStateException("Tried to serialize unregistered attribute"));
        var0.putString(ID_FIELD, var1.location().toString());
        var0.putDouble(BASE_FIELD, this.baseValue);
        if (!this.permanentModifiers.isEmpty()) {
            NBTTagList var2 = new NBTTagList();
            for (AttributeModifier var4 : this.permanentModifiers.values()) {
                var2.add(var4.save());
            }
            var0.put(MODIFIERS_FIELD, var2);
        }
        return var0;
    }

    public void load(NBTTagCompound var0) {
        this.baseValue = var0.getDouble(BASE_FIELD);
        if (var0.contains(MODIFIERS_FIELD, 9)) {
            NBTTagList var1 = var0.getList(MODIFIERS_FIELD, 10);
            for (int var2 = 0; var2 < var1.size(); ++var2) {
                AttributeModifier var3 = AttributeModifier.load(var1.getCompound(var2));
                if (var3 == null) continue;
                this.modifierById.put(var3.id(), var3);
                this.getModifiers(var3.operation()).put(var3.id(), var3);
                this.permanentModifiers.put(var3.id(), var3);
            }
        }
        this.setDirty();
    }
}

