/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBow;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;

public abstract class EntityInsentient
extends EntityLiving
implements EquipmentUser,
Leashable,
Targeting {
    private static final DataWatcherObject<Byte> DATA_MOB_FLAGS_ID = DataWatcher.defineId(EntityInsentient.class, DataWatcherRegistry.BYTE);
    private static final int MOB_FLAG_NO_AI = 1;
    private static final int MOB_FLAG_LEFTHANDED = 2;
    private static final int MOB_FLAG_AGGRESSIVE = 4;
    protected static final int PICKUP_REACH = 1;
    private static final BaseBlockPosition ITEM_PICKUP_REACH = new BaseBlockPosition(1, 0, 1);
    public static final float MAX_WEARING_ARMOR_CHANCE = 0.15f;
    public static final float MAX_PICKUP_LOOT_CHANCE = 0.55f;
    public static final float MAX_ENCHANTED_ARMOR_CHANCE = 0.5f;
    public static final float MAX_ENCHANTED_WEAPON_CHANCE = 0.25f;
    public static final float DEFAULT_EQUIPMENT_DROP_CHANCE = 0.085f;
    public static final float PRESERVE_ITEM_DROP_CHANCE_THRESHOLD = 1.0f;
    public static final int PRESERVE_ITEM_DROP_CHANCE = 2;
    public static final int UPDATE_GOAL_SELECTOR_EVERY_N_TICKS = 2;
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
    protected static final MinecraftKey RANDOM_SPAWN_BONUS_ID = MinecraftKey.withDefaultNamespace("random_spawn_bonus");
    public int ambientSoundTime;
    protected int xpReward;
    protected ControllerLook lookControl;
    protected ControllerMove moveControl;
    protected ControllerJump jumpControl;
    private final EntityAIBodyControl bodyRotationControl;
    protected NavigationAbstract navigation;
    public PathfinderGoalSelector goalSelector;
    public PathfinderGoalSelector targetSelector;
    @Nullable
    private EntityLiving target;
    private final EntitySenses sensing;
    private final NonNullList<ItemStack> handItems = NonNullList.withSize(2, ItemStack.EMPTY);
    public final float[] handDropChances = new float[2];
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize(4, ItemStack.EMPTY);
    public final float[] armorDropChances = new float[4];
    private ItemStack bodyArmorItem = ItemStack.EMPTY;
    protected float bodyArmorDropChance;
    private boolean canPickUpLoot;
    private boolean persistenceRequired;
    private final Map<PathType, Float> pathfindingMalus = Maps.newEnumMap(PathType.class);
    @Nullable
    public ResourceKey<LootTable> lootTable;
    public long lootTableSeed;
    @Nullable
    private Leashable.a leashData;
    private BlockPosition restrictCenter = BlockPosition.ZERO;
    private float restrictRadius = -1.0f;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> var0, World var1) {
        super((EntityTypes<? extends EntityLiving>)var0, var1);
        this.goalSelector = new PathfinderGoalSelector(var1.getProfilerSupplier());
        this.targetSelector = new PathfinderGoalSelector(var1.getProfilerSupplier());
        this.lookControl = new ControllerLook(this);
        this.moveControl = new ControllerMove(this);
        this.jumpControl = new ControllerJump(this);
        this.bodyRotationControl = this.createBodyControl();
        this.navigation = this.createNavigation(var1);
        this.sensing = new EntitySenses(this);
        Arrays.fill(this.armorDropChances, 0.085f);
        Arrays.fill(this.handDropChances, 0.085f);
        this.bodyArmorDropChance = 0.085f;
        if (var1 != null && !var1.isClientSide) {
            this.registerGoals();
        }
    }

    protected void registerGoals() {
    }

    public static AttributeProvider.Builder createMobAttributes() {
        return EntityLiving.createLivingAttributes().add(GenericAttributes.FOLLOW_RANGE, 16.0);
    }

    protected NavigationAbstract createNavigation(World var0) {
        return new Navigation(this, var0);
    }

    protected boolean shouldPassengersInheritMalus() {
        return false;
    }

    public float getPathfindingMalus(PathType var0) {
        Object var2;
        Entity entity = this.getControlledVehicle();
        Object var1 = entity instanceof EntityInsentient && ((EntityInsentient)(var2 = (EntityInsentient)entity)).shouldPassengersInheritMalus() ? var2 : this;
        var2 = ((EntityInsentient)var1).pathfindingMalus.get((Object)var0);
        return var2 == null ? var0.getMalus() : ((Float)var2).floatValue();
    }

    public void setPathfindingMalus(PathType var0, float var1) {
        this.pathfindingMalus.put(var0, Float.valueOf(var1));
    }

    public void onPathfindingStart() {
    }

    public void onPathfindingDone() {
    }

    protected EntityAIBodyControl createBodyControl() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook getLookControl() {
        return this.lookControl;
    }

    public ControllerMove getMoveControl() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof EntityInsentient) {
            EntityInsentient var0 = (EntityInsentient)entity;
            return var0.getMoveControl();
        }
        return this.moveControl;
    }

    public ControllerJump getJumpControl() {
        return this.jumpControl;
    }

    public NavigationAbstract getNavigation() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof EntityInsentient) {
            EntityInsentient var0 = (EntityInsentient)entity;
            return var0.getNavigation();
        }
        return this.navigation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public EntityLiving getControllingPassenger() {
        Entity var0 = this.getFirstPassenger();
        if (this.isNoAi()) return null;
        if (!(var0 instanceof EntityInsentient)) return null;
        EntityInsentient var1 = (EntityInsentient)var0;
        if (!var0.canControlVehicle()) return null;
        EntityInsentient entityInsentient = var1;
        return entityInsentient;
    }

    public EntitySenses getSensing() {
        return this.sensing;
    }

    @Override
    @Nullable
    public EntityLiving getTarget() {
        return this.target;
    }

    @Nullable
    protected final EntityLiving getTargetFromBrain() {
        return this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public void setTarget(@Nullable EntityLiving var0) {
        this.target = var0;
    }

    @Override
    public boolean canAttackType(EntityTypes<?> var0) {
        return var0 != EntityTypes.GHAST;
    }

    public boolean canFireProjectileWeapon(ItemProjectileWeapon var0) {
        return false;
    }

    public void ate() {
        this.gameEvent(GameEvent.EAT);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_MOB_FLAGS_ID, (byte)0);
    }

    public int getAmbientSoundInterval() {
        return 80;
    }

    public void playAmbientSound() {
        this.makeSound(this.getAmbientSound());
    }

    @Override
    public void baseTick() {
        super.baseTick();
        this.level().getProfiler().push("mobBaseTick");
        if (this.isAlive() && this.random.nextInt(1000) < this.ambientSoundTime++) {
            this.resetAmbientSoundTime();
            this.playAmbientSound();
        }
        this.level().getProfiler().pop();
    }

    @Override
    protected void playHurtSound(DamageSource var0) {
        this.resetAmbientSoundTime();
        super.playHurtSound(var0);
    }

    private void resetAmbientSoundTime() {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
    }

    @Override
    protected int getBaseExperienceReward() {
        if (this.xpReward > 0) {
            int var1;
            int var0 = this.xpReward;
            for (var1 = 0; var1 < this.armorItems.size(); ++var1) {
                if (this.armorItems.get(var1).isEmpty() || !(this.armorDropChances[var1] <= 1.0f)) continue;
                var0 += 1 + this.random.nextInt(3);
            }
            for (var1 = 0; var1 < this.handItems.size(); ++var1) {
                if (this.handItems.get(var1).isEmpty() || !(this.handDropChances[var1] <= 1.0f)) continue;
                var0 += 1 + this.random.nextInt(3);
            }
            if (!this.bodyArmorItem.isEmpty() && this.bodyArmorDropChance <= 1.0f) {
                var0 += 1 + this.random.nextInt(3);
            }
            return var0;
        }
        return this.xpReward;
    }

    public void spawnAnim() {
        if (this.level().isClientSide) {
            for (int var0 = 0; var0 < 20; ++var0) {
                double var1 = this.random.nextGaussian() * 0.02;
                double var3 = this.random.nextGaussian() * 0.02;
                double var5 = this.random.nextGaussian() * 0.02;
                double var7 = 10.0;
                this.level().addParticle(Particles.POOF, this.getX(1.0) - var1 * 10.0, this.getRandomY() - var3 * 10.0, this.getRandomZ(1.0) - var5 * 10.0, var1, var3, var5);
            }
        } else {
            this.level().broadcastEntityEvent(this, (byte)20);
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 20) {
            this.spawnAnim();
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.tickCount % 5 == 0) {
            this.updateControlFlags();
        }
    }

    protected void updateControlFlags() {
        boolean var0 = !(this.getControllingPassenger() instanceof EntityInsentient);
        boolean var1 = !(this.getVehicle() instanceof EntityBoat);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.MOVE, var0);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.JUMP, var0 && var1);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.LOOK, var0);
    }

    @Override
    protected float tickHeadTurn(float var0, float var1) {
        this.bodyRotationControl.clientTick();
        return var1;
    }

    @Nullable
    protected SoundEffect getAmbientSound() {
        return null;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("CanPickUpLoot", this.canPickUpLoot());
        var0.putBoolean("PersistenceRequired", this.persistenceRequired);
        NBTTagList var1 = new NBTTagList();
        for (ItemStack itemStack : this.armorItems) {
            if (!itemStack.isEmpty()) {
                var1.add(itemStack.save(this.registryAccess()));
                continue;
            }
            var1.add(new NBTTagCompound());
        }
        var0.put("ArmorItems", var1);
        NBTTagList var2 = new NBTTagList();
        for (float var6 : this.armorDropChances) {
            var2.add(NBTTagFloat.valueOf(var6));
        }
        var0.put("ArmorDropChances", var2);
        NBTTagList nBTTagList = new NBTTagList();
        for (ItemStack var5 : this.handItems) {
            if (!var5.isEmpty()) {
                nBTTagList.add(var5.save(this.registryAccess()));
                continue;
            }
            nBTTagList.add(new NBTTagCompound());
        }
        var0.put("HandItems", nBTTagList);
        NBTTagList var4 = new NBTTagList();
        for (float var8 : this.handDropChances) {
            var4.add(NBTTagFloat.valueOf(var8));
        }
        var0.put("HandDropChances", var4);
        if (!this.bodyArmorItem.isEmpty()) {
            var0.put("body_armor_item", this.bodyArmorItem.save(this.registryAccess()));
            var0.putFloat("body_armor_drop_chance", this.bodyArmorDropChance);
        }
        this.writeLeashData(var0, this.leashData);
        var0.putBoolean("LeftHanded", this.isLeftHanded());
        if (this.lootTable != null) {
            var0.putString("DeathLootTable", this.lootTable.location().toString());
            if (this.lootTableSeed != 0L) {
                var0.putLong("DeathLootTableSeed", this.lootTableSeed);
            }
        }
        if (this.isNoAi()) {
            var0.putBoolean("NoAI", this.isNoAi());
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        NBTTagCompound var3;
        int var2;
        NBTTagList var1;
        super.readAdditionalSaveData(var0);
        if (var0.contains("CanPickUpLoot", 1)) {
            this.setCanPickUpLoot(var0.getBoolean("CanPickUpLoot"));
        }
        this.persistenceRequired = var0.getBoolean("PersistenceRequired");
        if (var0.contains("ArmorItems", 9)) {
            var1 = var0.getList("ArmorItems", 10);
            for (var2 = 0; var2 < this.armorItems.size(); ++var2) {
                var3 = var1.getCompound(var2);
                this.armorItems.set(var2, ItemStack.parseOptional(this.registryAccess(), var3));
            }
        }
        if (var0.contains("ArmorDropChances", 9)) {
            var1 = var0.getList("ArmorDropChances", 5);
            for (var2 = 0; var2 < var1.size(); ++var2) {
                this.armorDropChances[var2] = var1.getFloat(var2);
            }
        }
        if (var0.contains("HandItems", 9)) {
            var1 = var0.getList("HandItems", 10);
            for (var2 = 0; var2 < this.handItems.size(); ++var2) {
                var3 = var1.getCompound(var2);
                this.handItems.set(var2, ItemStack.parseOptional(this.registryAccess(), var3));
            }
        }
        if (var0.contains("HandDropChances", 9)) {
            var1 = var0.getList("HandDropChances", 5);
            for (var2 = 0; var2 < var1.size(); ++var2) {
                this.handDropChances[var2] = var1.getFloat(var2);
            }
        }
        if (var0.contains("body_armor_item", 10)) {
            this.bodyArmorItem = ItemStack.parse(this.registryAccess(), var0.getCompound("body_armor_item")).orElse(ItemStack.EMPTY);
            this.bodyArmorDropChance = var0.getFloat("body_armor_drop_chance");
        } else {
            this.bodyArmorItem = ItemStack.EMPTY;
        }
        this.leashData = this.readLeashData(var0);
        this.setLeftHanded(var0.getBoolean("LeftHanded"));
        if (var0.contains("DeathLootTable", 8)) {
            this.lootTable = ResourceKey.create(Registries.LOOT_TABLE, MinecraftKey.parse(var0.getString("DeathLootTable")));
            this.lootTableSeed = var0.getLong("DeathLootTableSeed");
        }
        this.setNoAi(var0.getBoolean("NoAI"));
    }

    @Override
    protected void dropFromLootTable(DamageSource var0, boolean var1) {
        super.dropFromLootTable(var0, var1);
        this.lootTable = null;
    }

    @Override
    public final ResourceKey<LootTable> getLootTable() {
        return this.lootTable == null ? this.getDefaultLootTable() : this.lootTable;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return super.getLootTable();
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setZza(float var0) {
        this.zza = var0;
    }

    public void setYya(float var0) {
        this.yya = var0;
    }

    public void setXxa(float var0) {
        this.xxa = var0;
    }

    @Override
    public void setSpeed(float var0) {
        super.setSpeed(var0);
        this.setZza(var0);
    }

    public void stopInPlace() {
        this.getNavigation().stop();
        this.setXxa(0.0f);
        this.setYya(0.0f);
        this.setSpeed(0.0f);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.level().getProfiler().push("looting");
        if (!this.level().isClientSide && this.canPickUpLoot() && this.isAlive() && !this.dead && this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            BaseBlockPosition var0 = this.getPickupReach();
            List<EntityItem> var1 = this.level().getEntitiesOfClass(EntityItem.class, this.getBoundingBox().inflate(var0.getX(), var0.getY(), var0.getZ()));
            for (EntityItem var3 : var1) {
                if (var3.isRemoved() || var3.getItem().isEmpty() || var3.hasPickUpDelay() || !this.wantsToPickUp(var3.getItem())) continue;
                this.pickUpItem(var3);
            }
        }
        this.level().getProfiler().pop();
    }

    protected BaseBlockPosition getPickupReach() {
        return ITEM_PICKUP_REACH;
    }

    protected void pickUpItem(EntityItem var0) {
        ItemStack var1 = var0.getItem();
        ItemStack var2 = this.equipItemIfPossible(var1.copy());
        if (!var2.isEmpty()) {
            this.onItemPickup(var0);
            this.take(var0, var2.getCount());
            var1.shrink(var2.getCount());
            if (var1.isEmpty()) {
                var0.discard();
            }
        }
    }

    public ItemStack equipItemIfPossible(ItemStack var0) {
        EnumItemSlot var1 = this.getEquipmentSlotForItem(var0);
        ItemStack var2 = this.getItemBySlot(var1);
        boolean var3 = this.canReplaceCurrentItem(var0, var2);
        if (var1.isArmor() && !var3) {
            var1 = EnumItemSlot.MAINHAND;
            var2 = this.getItemBySlot(var1);
            var3 = var2.isEmpty();
        }
        if (var3 && this.canHoldItem(var0)) {
            double var4 = this.getEquipmentDropChance(var1);
            if (!var2.isEmpty() && (double)Math.max(this.random.nextFloat() - 0.1f, 0.0f) < var4) {
                this.spawnAtLocation(var2);
            }
            ItemStack var6 = var1.limit(var0);
            this.setItemSlotAndDropWhenKilled(var1, var6);
            return var6;
        }
        return ItemStack.EMPTY;
    }

    protected void setItemSlotAndDropWhenKilled(EnumItemSlot var0, ItemStack var1) {
        this.setItemSlot(var0, var1);
        this.setGuaranteedDrop(var0);
        this.persistenceRequired = true;
    }

    public void setGuaranteedDrop(EnumItemSlot var0) {
        switch (var0.getType()) {
            case HAND: {
                this.handDropChances[var0.getIndex()] = 2.0f;
                break;
            }
            case HUMANOID_ARMOR: {
                this.armorDropChances[var0.getIndex()] = 2.0f;
                break;
            }
            case ANIMAL_ARMOR: {
                this.bodyArmorDropChance = 2.0f;
            }
        }
    }

    protected boolean canReplaceCurrentItem(ItemStack var0, ItemStack var1) {
        if (var1.isEmpty()) {
            return true;
        }
        if (var0.getItem() instanceof ItemSword) {
            double var5;
            if (!(var1.getItem() instanceof ItemSword)) {
                return true;
            }
            double var3 = this.getApproximateAttackDamageWithItem(var0);
            if (var3 != (var5 = this.getApproximateAttackDamageWithItem(var1))) {
                return var3 > var5;
            }
            return this.canReplaceEqualItem(var0, var1);
        }
        if (var0.getItem() instanceof ItemBow && var1.getItem() instanceof ItemBow) {
            return this.canReplaceEqualItem(var0, var1);
        }
        if (var0.getItem() instanceof ItemCrossbow && var1.getItem() instanceof ItemCrossbow) {
            return this.canReplaceEqualItem(var0, var1);
        }
        Item var3 = var0.getItem();
        if (var3 instanceof ItemArmor) {
            ItemArmor var2 = (ItemArmor)var3;
            if (EnchantmentManager.has(var1, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
                return false;
            }
            if (!(var1.getItem() instanceof ItemArmor)) {
                return true;
            }
            var3 = (ItemArmor)var1.getItem();
            if (var2.getDefense() != ((ItemArmor)var3).getDefense()) {
                return var2.getDefense() > ((ItemArmor)var3).getDefense();
            }
            if (var2.getToughness() != ((ItemArmor)var3).getToughness()) {
                return var2.getToughness() > ((ItemArmor)var3).getToughness();
            }
            return this.canReplaceEqualItem(var0, var1);
        }
        if (var0.getItem() instanceof ItemTool) {
            if (var1.getItem() instanceof ItemBlock) {
                return true;
            }
            if (var1.getItem() instanceof ItemTool) {
                double var5;
                double var32 = this.getApproximateAttackDamageWithItem(var0);
                if (var32 != (var5 = this.getApproximateAttackDamageWithItem(var1))) {
                    return var32 > var5;
                }
                return this.canReplaceEqualItem(var0, var1);
            }
        }
        return false;
    }

    private double getApproximateAttackDamageWithItem(ItemStack var0) {
        ItemAttributeModifiers var1 = var0.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        return var1.compute(this.getAttributeBaseValue(GenericAttributes.ATTACK_DAMAGE), EnumItemSlot.MAINHAND);
    }

    public boolean canReplaceEqualItem(ItemStack var0, ItemStack var1) {
        if (var0.getDamageValue() < var1.getDamageValue()) {
            return true;
        }
        return EntityInsentient.hasAnyComponentExceptDamage(var0) && !EntityInsentient.hasAnyComponentExceptDamage(var1);
    }

    private static boolean hasAnyComponentExceptDamage(ItemStack var0) {
        DataComponentMap var1 = var0.getComponents();
        int var2 = var1.size();
        return var2 > 1 || var2 == 1 && !var1.has(DataComponents.DAMAGE);
    }

    public boolean canHoldItem(ItemStack var0) {
        return true;
    }

    public boolean wantsToPickUp(ItemStack var0) {
        return this.canHoldItem(var0);
    }

    public boolean removeWhenFarAway(double var0) {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return this.isPassenger();
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == EnumDifficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
            return;
        }
        if (this.isPersistenceRequired() || this.requiresCustomPersistence()) {
            this.noActionTime = 0;
            return;
        }
        EntityHuman var0 = this.level().getNearestPlayer(this, -1.0);
        if (var0 != null) {
            int var3;
            int var4;
            double var1 = var0.distanceToSqr(this);
            if (var1 > (double)(var4 = (var3 = this.getType().getCategory().getDespawnDistance()) * var3) && this.removeWhenFarAway(var1)) {
                this.discard();
            }
            int var5 = this.getType().getCategory().getNoDespawnDistance();
            int var6 = var5 * var5;
            if (this.noActionTime > 600 && this.random.nextInt(800) == 0 && var1 > (double)var6 && this.removeWhenFarAway(var1)) {
                this.discard();
            } else if (var1 < (double)var6) {
                this.noActionTime = 0;
            }
        }
    }

    @Override
    protected final void serverAiStep() {
        ++this.noActionTime;
        GameProfilerFiller var0 = this.level().getProfiler();
        var0.push("sensing");
        this.sensing.tick();
        var0.pop();
        int var1 = this.tickCount + this.getId();
        if (var1 % 2 == 0 || this.tickCount <= 1) {
            var0.push("targetSelector");
            this.targetSelector.tick();
            var0.pop();
            var0.push("goalSelector");
            this.goalSelector.tick();
            var0.pop();
        } else {
            var0.push("targetSelector");
            this.targetSelector.tickRunningGoals(false);
            var0.pop();
            var0.push("goalSelector");
            this.goalSelector.tickRunningGoals(false);
            var0.pop();
        }
        var0.push("navigation");
        this.navigation.tick();
        var0.pop();
        var0.push("mob tick");
        this.customServerAiStep();
        var0.pop();
        var0.push("controls");
        var0.push("move");
        this.moveControl.tick();
        var0.popPush("look");
        this.lookControl.tick();
        var0.popPush("jump");
        this.jumpControl.tick();
        var0.pop();
        var0.pop();
        this.sendDebugPackets();
    }

    protected void sendDebugPackets() {
        PacketDebug.sendGoalSelector(this.level(), this, this.goalSelector);
    }

    protected void customServerAiStep() {
    }

    public int getMaxHeadXRot() {
        return 40;
    }

    public int getMaxHeadYRot() {
        return 75;
    }

    protected void clampHeadRotationToBody() {
        float var0 = this.getMaxHeadYRot();
        float var1 = this.getYHeadRot();
        float var2 = MathHelper.wrapDegrees(this.yBodyRot - var1);
        float var3 = MathHelper.clamp(MathHelper.wrapDegrees(this.yBodyRot - var1), -var0, var0);
        float var4 = var1 + var2 - var3;
        this.setYHeadRot(var4);
    }

    public int getHeadRotSpeed() {
        return 10;
    }

    public void lookAt(Entity var0, float var1, float var2) {
        double var5;
        double var3 = var0.getX() - this.getX();
        double var7 = var0.getZ() - this.getZ();
        if (var0 instanceof EntityLiving) {
            EntityLiving var9 = (EntityLiving)var0;
            var5 = var9.getEyeY() - this.getEyeY();
        } else {
            var5 = (var0.getBoundingBox().minY + var0.getBoundingBox().maxY) / 2.0 - this.getEyeY();
        }
        double var9 = Math.sqrt(var3 * var3 + var7 * var7);
        float var11 = (float)(MathHelper.atan2(var7, var3) * 57.2957763671875) - 90.0f;
        float var12 = (float)(-(MathHelper.atan2(var5, var9) * 57.2957763671875));
        this.setXRot(this.rotlerp(this.getXRot(), var12, var2));
        this.setYRot(this.rotlerp(this.getYRot(), var11, var1));
    }

    private float rotlerp(float var0, float var1, float var2) {
        float var3 = MathHelper.wrapDegrees(var1 - var0);
        if (var3 > var2) {
            var3 = var2;
        }
        if (var3 < -var2) {
            var3 = -var2;
        }
        return var0 + var3;
    }

    public static boolean checkMobSpawnRules(EntityTypes<? extends EntityInsentient> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        BlockPosition var5 = var3.below();
        return var2 == EnumMobSpawn.SPAWNER || var1.getBlockState(var5).isValidSpawn(var1, var5, var0);
    }

    public boolean checkSpawnRules(GeneratorAccess var0, EnumMobSpawn var1) {
        return true;
    }

    public boolean checkSpawnObstruction(IWorldReader var0) {
        return !var0.containsAnyLiquid(this.getBoundingBox()) && var0.isUnobstructed(this);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    public boolean isMaxGroupSizeReached(int var0) {
        return false;
    }

    @Override
    public int getMaxFallDistance() {
        if (this.getTarget() == null) {
            return this.getComfortableFallDistance(0.0f);
        }
        int var0 = (int)(this.getHealth() - this.getMaxHealth() * 0.33f);
        if ((var0 -= (3 - this.level().getDifficulty().getId()) * 4) < 0) {
            var0 = 0;
        }
        return this.getComfortableFallDistance(var0);
    }

    @Override
    public Iterable<ItemStack> getHandSlots() {
        return this.handItems;
    }

    @Override
    public Iterable<ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    public ItemStack getBodyArmorItem() {
        return this.bodyArmorItem;
    }

    @Override
    public boolean canUseSlot(EnumItemSlot var0) {
        return var0 != EnumItemSlot.BODY;
    }

    public boolean isWearingBodyArmor() {
        return !this.getItemBySlot(EnumItemSlot.BODY).isEmpty();
    }

    public boolean isBodyArmorItem(ItemStack var0) {
        return false;
    }

    public void setBodyArmorItem(ItemStack var0) {
        this.setItemSlotAndDropWhenKilled(EnumItemSlot.BODY, var0);
    }

    @Override
    public Iterable<ItemStack> getArmorAndBodyArmorSlots() {
        if (this.bodyArmorItem.isEmpty()) {
            return this.armorItems;
        }
        return Iterables.concat(this.armorItems, List.of(this.bodyArmorItem));
    }

    @Override
    public ItemStack getItemBySlot(EnumItemSlot var0) {
        return switch (var0.getType()) {
            default -> throw new MatchException(null, null);
            case EnumItemSlot.Function.HAND -> this.handItems.get(var0.getIndex());
            case EnumItemSlot.Function.HUMANOID_ARMOR -> this.armorItems.get(var0.getIndex());
            case EnumItemSlot.Function.ANIMAL_ARMOR -> this.bodyArmorItem;
        };
    }

    @Override
    public void setItemSlot(EnumItemSlot var0, ItemStack var1) {
        this.verifyEquippedItem(var1);
        switch (var0.getType()) {
            case HAND: {
                this.onEquipItem(var0, this.handItems.set(var0.getIndex(), var1), var1);
                break;
            }
            case HUMANOID_ARMOR: {
                this.onEquipItem(var0, this.armorItems.set(var0.getIndex(), var1), var1);
                break;
            }
            case ANIMAL_ARMOR: {
                ItemStack var2 = this.bodyArmorItem;
                this.bodyArmorItem = var1;
                this.onEquipItem(var0, var2, var1);
            }
        }
    }

    @Override
    protected void dropCustomDeathLoot(WorldServer var0, DamageSource var1, boolean var2) {
        super.dropCustomDeathLoot(var0, var1, var2);
        for (EnumItemSlot var6 : EnumItemSlot.values()) {
            ItemStack var7 = this.getItemBySlot(var6);
            float var8 = this.getEquipmentDropChance(var6);
            if (var8 == 0.0f) continue;
            boolean var9 = var8 > 1.0f;
            Object object = var1.getEntity();
            if (object instanceof EntityLiving) {
                EntityLiving var10 = (EntityLiving)object;
                object = this.level();
                if (object instanceof WorldServer) {
                    WorldServer var11 = (WorldServer)object;
                    var8 = EnchantmentManager.processEquipmentDropChance(var11, var10, var1, var8);
                }
            }
            if (var7.isEmpty() || EnchantmentManager.has(var7, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) || !var2 && !var9 || !(this.random.nextFloat() < var8)) continue;
            if (!var9 && var7.isDamageableItem()) {
                var7.setDamageValue(var7.getMaxDamage() - this.random.nextInt(1 + this.random.nextInt(Math.max(var7.getMaxDamage() - 3, 1))));
            }
            this.spawnAtLocation(var7);
            this.setItemSlot(var6, ItemStack.EMPTY);
        }
    }

    protected float getEquipmentDropChance(EnumItemSlot var0) {
        return switch (var0.getType()) {
            default -> throw new MatchException(null, null);
            case EnumItemSlot.Function.HAND -> this.handDropChances[var0.getIndex()];
            case EnumItemSlot.Function.HUMANOID_ARMOR -> this.armorDropChances[var0.getIndex()];
            case EnumItemSlot.Function.ANIMAL_ARMOR -> this.bodyArmorDropChance;
        };
    }

    public void dropPreservedEquipment() {
        this.dropPreservedEquipment(var0 -> true);
    }

    public Set<EnumItemSlot> dropPreservedEquipment(Predicate<ItemStack> var0) {
        HashSet<EnumItemSlot> var1 = new HashSet<EnumItemSlot>();
        for (EnumItemSlot var5 : EnumItemSlot.values()) {
            ItemStack var6 = this.getItemBySlot(var5);
            if (var6.isEmpty()) continue;
            if (!var0.test(var6)) {
                var1.add(var5);
                continue;
            }
            double var7 = this.getEquipmentDropChance(var5);
            if (!(var7 > 1.0)) continue;
            this.setItemSlot(var5, ItemStack.EMPTY);
            this.spawnAtLocation(var6);
        }
        return var1;
    }

    private LootParams createEquipmentParams(WorldServer var0) {
        return new LootParams.a(var0).withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.THIS_ENTITY, this).create(LootContextParameterSets.EQUIPMENT);
    }

    public void equip(EquipmentTable var0) {
        this.equip(var0.lootTable(), var0.slotDropChances());
    }

    public void equip(ResourceKey<LootTable> var0, Map<EnumItemSlot, Float> var1) {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            this.equip(var0, this.createEquipmentParams(var2), var1);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource var0, DifficultyDamageScaler var1) {
        if (var0.nextFloat() < 0.15f * var1.getSpecialMultiplier()) {
            float var3;
            int var2 = var0.nextInt(2);
            float f2 = var3 = this.level().getDifficulty() == EnumDifficulty.HARD ? 0.1f : 0.25f;
            if (var0.nextFloat() < 0.095f) {
                ++var2;
            }
            if (var0.nextFloat() < 0.095f) {
                ++var2;
            }
            if (var0.nextFloat() < 0.095f) {
                ++var2;
            }
            boolean var4 = true;
            for (EnumItemSlot var8 : EnumItemSlot.values()) {
                Item var10;
                if (var8.getType() != EnumItemSlot.Function.HUMANOID_ARMOR) continue;
                ItemStack var9 = this.getItemBySlot(var8);
                if (!var4 && var0.nextFloat() < var3) break;
                var4 = false;
                if (!var9.isEmpty() || (var10 = EntityInsentient.getEquipmentForSlot(var8, var2)) == null) continue;
                this.setItemSlot(var8, new ItemStack(var10));
            }
        }
    }

    @Nullable
    public static Item getEquipmentForSlot(EnumItemSlot var0, int var1) {
        switch (var0) {
            case HEAD: {
                if (var1 == 0) {
                    return Items.LEATHER_HELMET;
                }
                if (var1 == 1) {
                    return Items.GOLDEN_HELMET;
                }
                if (var1 == 2) {
                    return Items.CHAINMAIL_HELMET;
                }
                if (var1 == 3) {
                    return Items.IRON_HELMET;
                }
                if (var1 == 4) {
                    return Items.DIAMOND_HELMET;
                }
            }
            case CHEST: {
                if (var1 == 0) {
                    return Items.LEATHER_CHESTPLATE;
                }
                if (var1 == 1) {
                    return Items.GOLDEN_CHESTPLATE;
                }
                if (var1 == 2) {
                    return Items.CHAINMAIL_CHESTPLATE;
                }
                if (var1 == 3) {
                    return Items.IRON_CHESTPLATE;
                }
                if (var1 == 4) {
                    return Items.DIAMOND_CHESTPLATE;
                }
            }
            case LEGS: {
                if (var1 == 0) {
                    return Items.LEATHER_LEGGINGS;
                }
                if (var1 == 1) {
                    return Items.GOLDEN_LEGGINGS;
                }
                if (var1 == 2) {
                    return Items.CHAINMAIL_LEGGINGS;
                }
                if (var1 == 3) {
                    return Items.IRON_LEGGINGS;
                }
                if (var1 == 4) {
                    return Items.DIAMOND_LEGGINGS;
                }
            }
            case FEET: {
                if (var1 == 0) {
                    return Items.LEATHER_BOOTS;
                }
                if (var1 == 1) {
                    return Items.GOLDEN_BOOTS;
                }
                if (var1 == 2) {
                    return Items.CHAINMAIL_BOOTS;
                }
                if (var1 == 3) {
                    return Items.IRON_BOOTS;
                }
                if (var1 != 4) break;
                return Items.DIAMOND_BOOTS;
            }
        }
        return null;
    }

    protected void populateDefaultEquipmentEnchantments(WorldAccess var0, RandomSource var1, DifficultyDamageScaler var2) {
        this.enchantSpawnedWeapon(var0, var1, var2);
        for (EnumItemSlot var6 : EnumItemSlot.values()) {
            if (var6.getType() != EnumItemSlot.Function.HUMANOID_ARMOR) continue;
            this.enchantSpawnedArmor(var0, var1, var6, var2);
        }
    }

    protected void enchantSpawnedWeapon(WorldAccess var0, RandomSource var1, DifficultyDamageScaler var2) {
        this.enchantSpawnedEquipment(var0, EnumItemSlot.MAINHAND, var1, 0.25f, var2);
    }

    protected void enchantSpawnedArmor(WorldAccess var0, RandomSource var1, EnumItemSlot var2, DifficultyDamageScaler var3) {
        this.enchantSpawnedEquipment(var0, var2, var1, 0.5f, var3);
    }

    private void enchantSpawnedEquipment(WorldAccess var0, EnumItemSlot var1, RandomSource var2, float var3, DifficultyDamageScaler var4) {
        ItemStack var5 = this.getItemBySlot(var1);
        if (!var5.isEmpty() && var2.nextFloat() < var3 * var4.getSpecialMultiplier()) {
            EnchantmentManager.enchantItemFromProvider(var5, var0.registryAccess(), VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, var4, var2);
            this.setItemSlot(var1, var5);
        }
    }

    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3) {
        RandomSource var4 = var0.getRandom();
        AttributeModifiable var5 = Objects.requireNonNull(this.getAttribute(GenericAttributes.FOLLOW_RANGE));
        if (!var5.hasModifier(RANDOM_SPAWN_BONUS_ID)) {
            var5.addPermanentModifier(new AttributeModifier(RANDOM_SPAWN_BONUS_ID, var4.triangle(0.0, 0.11485000000000001), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        this.setLeftHanded(var4.nextFloat() < 0.05f);
        return var3;
    }

    public void setPersistenceRequired() {
        this.persistenceRequired = true;
    }

    @Override
    public void setDropChance(EnumItemSlot var0, float var1) {
        switch (var0.getType()) {
            case HAND: {
                this.handDropChances[var0.getIndex()] = var1;
                break;
            }
            case HUMANOID_ARMOR: {
                this.armorDropChances[var0.getIndex()] = var1;
                break;
            }
            case ANIMAL_ARMOR: {
                this.bodyArmorDropChance = var1;
            }
        }
    }

    public boolean canPickUpLoot() {
        return this.canPickUpLoot;
    }

    public void setCanPickUpLoot(boolean var0) {
        this.canPickUpLoot = var0;
    }

    @Override
    public boolean canTakeItem(ItemStack var0) {
        EnumItemSlot var1 = this.getEquipmentSlotForItem(var0);
        return this.getItemBySlot(var1).isEmpty() && this.canPickUpLoot();
    }

    public boolean isPersistenceRequired() {
        return this.persistenceRequired;
    }

    @Override
    public final EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        if (!this.isAlive()) {
            return EnumInteractionResult.PASS;
        }
        EnumInteractionResult var2 = this.checkAndHandleImportantInteractions(var0, var1);
        if (var2.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, var0);
            return var2;
        }
        EnumInteractionResult var3 = super.interact(var0, var1);
        if (var3 != EnumInteractionResult.PASS) {
            return var3;
        }
        var2 = this.mobInteract(var0, var1);
        if (var2.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, var0);
            return var2;
        }
        return EnumInteractionResult.PASS;
    }

    private EnumInteractionResult checkAndHandleImportantInteractions(EntityHuman var0, EnumHand var12) {
        Object var3;
        ItemStack var2 = var0.getItemInHand(var12);
        if (var2.is(Items.NAME_TAG) && ((EnumInteractionResult)((Object)(var3 = var2.interactLivingEntity(var0, this, var12)))).consumesAction()) {
            return var3;
        }
        if (var2.getItem() instanceof ItemMonsterEgg) {
            if (this.level() instanceof WorldServer) {
                var3 = (ItemMonsterEgg)var2.getItem();
                Optional<EntityInsentient> var4 = ((ItemMonsterEgg)var3).spawnOffspringFromSpawnEgg(var0, this, this.getType(), (WorldServer)this.level(), this.position(), var2);
                var4.ifPresent(var1 -> this.onOffspringSpawnedFromEgg(var0, (EntityInsentient)var1));
                return var4.isPresent() ? EnumInteractionResult.SUCCESS : EnumInteractionResult.PASS;
            }
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.PASS;
    }

    protected void onOffspringSpawnedFromEgg(EntityHuman var0, EntityInsentient var1) {
    }

    protected EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        return EnumInteractionResult.PASS;
    }

    public boolean isWithinRestriction() {
        return this.isWithinRestriction(this.blockPosition());
    }

    public boolean isWithinRestriction(BlockPosition var0) {
        if (this.restrictRadius == -1.0f) {
            return true;
        }
        return this.restrictCenter.distSqr(var0) < (double)(this.restrictRadius * this.restrictRadius);
    }

    public void restrictTo(BlockPosition var0, int var1) {
        this.restrictCenter = var0;
        this.restrictRadius = var1;
    }

    public BlockPosition getRestrictCenter() {
        return this.restrictCenter;
    }

    public float getRestrictRadius() {
        return this.restrictRadius;
    }

    public void clearRestriction() {
        this.restrictRadius = -1.0f;
    }

    public boolean hasRestriction() {
        return this.restrictRadius != -1.0f;
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> var0, boolean var1) {
        if (this.isRemoved()) {
            return null;
        }
        EntityInsentient var2 = (EntityInsentient)var0.create(this.level());
        if (var2 == null) {
            return null;
        }
        var2.copyPosition(this);
        var2.setBaby(this.isBaby());
        var2.setNoAi(this.isNoAi());
        if (this.hasCustomName()) {
            var2.setCustomName(this.getCustomName());
            var2.setCustomNameVisible(this.isCustomNameVisible());
        }
        if (this.isPersistenceRequired()) {
            var2.setPersistenceRequired();
        }
        var2.setInvulnerable(this.isInvulnerable());
        if (var1) {
            var2.setCanPickUpLoot(this.canPickUpLoot());
            for (EnumItemSlot var6 : EnumItemSlot.values()) {
                ItemStack var7 = this.getItemBySlot(var6);
                if (var7.isEmpty()) continue;
                var2.setItemSlot(var6, var7.copyAndClear());
                var2.setDropChance(var6, this.getEquipmentDropChance(var6));
            }
        }
        this.level().addFreshEntity(var2);
        if (this.isPassenger()) {
            Entity var3 = this.getVehicle();
            this.stopRiding();
            var2.startRiding(var3, true);
        }
        this.discard();
        return (T)var2;
    }

    @Override
    @Nullable
    public Leashable.a getLeashData() {
        return this.leashData;
    }

    @Override
    public void setLeashData(@Nullable Leashable.a var0) {
        this.leashData = var0;
    }

    @Override
    public void dropLeash(boolean var0, boolean var1) {
        Leashable.super.dropLeash(var0, var1);
        if (this.getLeashData() == null) {
            this.clearRestriction();
        }
    }

    @Override
    public void leashTooFarBehaviour() {
        Leashable.super.leashTooFarBehaviour();
        this.goalSelector.disableControlFlag(PathfinderGoal.Type.MOVE);
    }

    @Override
    public boolean canBeLeashed() {
        return !(this instanceof IMonster);
    }

    @Override
    public boolean startRiding(Entity var0, boolean var1) {
        boolean var2 = super.startRiding(var0, var1);
        if (var2 && this.isLeashed()) {
            this.dropLeash(true, true);
        }
        return var2;
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && !this.isNoAi();
    }

    public void setNoAi(boolean var0) {
        byte var1 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, var0 ? (byte)(var1 | 1) : (byte)(var1 & 0xFFFFFFFE));
    }

    public void setLeftHanded(boolean var0) {
        byte var1 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, var0 ? (byte)(var1 | 2) : (byte)(var1 & 0xFFFFFFFD));
    }

    public void setAggressive(boolean var0) {
        byte var1 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, var0 ? (byte)(var1 | 4) : (byte)(var1 & 0xFFFFFFFB));
    }

    public boolean isNoAi() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 1) != 0;
    }

    public boolean isLeftHanded() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 2) != 0;
    }

    public boolean isAggressive() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 4) != 0;
    }

    public void setBaby(boolean var0) {
    }

    @Override
    public EnumMainHand getMainArm() {
        return this.isLeftHanded() ? EnumMainHand.LEFT : EnumMainHand.RIGHT;
    }

    public boolean isWithinMeleeAttackRange(EntityLiving var0) {
        return this.getAttackBoundingBox().intersects(var0.getHitbox());
    }

    protected AxisAlignedBB getAttackBoundingBox() {
        AxisAlignedBB var0;
        Entity var1 = this.getVehicle();
        if (var1 != null) {
            AxisAlignedBB var2 = var1.getBoundingBox();
            AxisAlignedBB var3 = this.getBoundingBox();
            var0 = new AxisAlignedBB(Math.min(var3.minX, var2.minX), var3.minY, Math.min(var3.minZ, var2.minZ), Math.max(var3.maxX, var2.maxX), var3.maxY, Math.max(var3.maxZ, var2.maxZ));
        } else {
            var0 = this.getBoundingBox();
        }
        return var0.inflate(DEFAULT_ATTACK_REACH, 0.0, DEFAULT_ATTACK_REACH);
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        boolean var3;
        float var1 = (float)this.getAttributeValue(GenericAttributes.ATTACK_DAMAGE);
        DamageSource var2 = this.damageSources().mobAttack(this);
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var32 = (WorldServer)world;
            var1 = EnchantmentManager.modifyDamage(var32, this.getWeaponItem(), var0, var2, var1);
        }
        if (var3 = var0.hurt(var2, var1)) {
            World world2;
            Object var5;
            float var4 = this.getKnockback(var0, var2);
            if (var4 > 0.0f && var0 instanceof EntityLiving) {
                var5 = (EntityLiving)var0;
                ((EntityLiving)var5).knockback(var4 * 0.5f, MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)), -MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((world2 = this.level()) instanceof WorldServer) {
                var5 = (WorldServer)world2;
                EnchantmentManager.doPostAttackEffects((WorldServer)var5, var0, var2);
            }
            this.setLastHurtMob(var0);
            this.playAttackSound();
        }
        return var3;
    }

    protected void playAttackSound() {
    }

    protected boolean isSunBurnTick() {
        if (this.level().isDay() && !this.level().isClientSide) {
            boolean var2;
            float var0 = this.getLightLevelDependentMagicValue();
            BlockPosition var1 = BlockPosition.containing(this.getX(), this.getEyeY(), this.getZ());
            boolean bl = var2 = this.isInWaterRainOrBubble() || this.isInPowderSnow || this.wasInPowderSnow;
            if (var0 > 0.5f && this.random.nextFloat() * 30.0f < (var0 - 0.4f) * 2.0f && !var2 && this.level().canSeeSky(var1)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void jumpInLiquid(TagKey<FluidType> var0) {
        if (this.getNavigation().canFloat()) {
            super.jumpInLiquid(var0);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void removeFreeWill() {
        this.removeAllGoals(var0 -> true);
        this.getBrain().removeAllBehaviors();
    }

    public void removeAllGoals(Predicate<PathfinderGoal> var0) {
        this.goalSelector.removeAllGoals(var0);
    }

    @Override
    protected void removeAfterChangingDimensions() {
        super.removeAfterChangingDimensions();
        this.getAllSlots().forEach(var0 -> {
            if (!var0.isEmpty()) {
                var0.setCount(0);
            }
        });
    }

    @Override
    @Nullable
    public ItemStack getPickResult() {
        ItemMonsterEgg var0 = ItemMonsterEgg.byId(this.getType());
        if (var0 == null) {
            return null;
        }
        return new ItemStack(var0);
    }
}

