/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class ItemStackCustomNameToOverrideComponentFix
extends DataFix {
    private static final Set<String> MAP_NAMES = Set.of("filled_map.buried_treasure", "filled_map.explorer_jungle", "filled_map.explorer_swamp", "filled_map.mansion", "filled_map.monument", "filled_map.trial_chambers", "filled_map.village_desert", "filled_map.village_plains", "filled_map.village_savanna", "filled_map.village_snowy", "filled_map.village_taiga");

    public ItemStackCustomNameToOverrideComponentFix(Schema var0) {
        super(var0, false);
    }

    public final TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.ITEM_STACK);
        OpticFinder var1 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.ITEM_NAME.typeName(), DataConverterSchemaNamed.namespacedString()));
        OpticFinder var22 = var0.findField("components");
        return this.fixTypeEverywhereTyped("ItemStack custom_name to item_name component fix", var0, var2 -> {
            Optional var3 = var2.getOptional(var1);
            Optional<String> var4 = var3.map(Pair::getSecond);
            if (var4.filter(var0 -> var0.equals("minecraft:white_banner")).isPresent()) {
                return var2.updateTyped(var22, var0 -> var0.update(DSL.remainderFinder(), ItemStackCustomNameToOverrideComponentFix::fixBanner));
            }
            if (var4.filter(var0 -> var0.equals("minecraft:filled_map")).isPresent()) {
                return var2.updateTyped(var22, var0 -> var0.update(DSL.remainderFinder(), ItemStackCustomNameToOverrideComponentFix::fixMap));
            }
            return var2;
        });
    }

    private static <T> Dynamic<T> fixMap(Dynamic<T> var0) {
        return ItemStackCustomNameToOverrideComponentFix.fixCustomName(var0, MAP_NAMES::contains);
    }

    private static <T> Dynamic<T> fixBanner(Dynamic<T> var02) {
        return ItemStackCustomNameToOverrideComponentFix.fixCustomName(var02, var0 -> var0.equals("block.minecraft.ominous_banner"));
    }

    private static <T> Dynamic<T> fixCustomName(Dynamic<T> var0, Predicate<String> var1) {
        OptionalDynamic var2 = var0.get("minecraft:custom_name");
        Optional<String> var3 = var2.asString().result().flatMap(ComponentDataFixUtils::extractTranslationString).filter(var1);
        if (var3.isPresent()) {
            return var0.renameField("minecraft:custom_name", "minecraft:item_name");
        }
        return var0;
    }
}

