/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Locale;
import java.util.UUID;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.util.ColorUtil;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.math.Fraction;
import org.apache.commons.lang3.math.NumberUtils;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class MathHelper {
    private static final long UUID_VERSION = 61440L;
    private static final long UUID_VERSION_TYPE_4 = 16384L;
    private static final long UUID_VARIANT = -4611686018427387904L;
    private static final long UUID_VARIANT_2 = Long.MIN_VALUE;
    public static final float PI = (float)java.lang.Math.PI;
    public static final float HALF_PI = 1.5707964f;
    public static final float TWO_PI = (float)java.lang.Math.PI * 2;
    public static final float DEG_TO_RAD = (float)java.lang.Math.PI / 180;
    public static final float RAD_TO_DEG = 57.295776f;
    public static final float EPSILON = 1.0E-5f;
    public static final float SQRT_OF_TWO = MathHelper.sqrt(2.0f);
    private static final float SIN_SCALE = 10430.378f;
    public static final Vector3f Y_AXIS = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f X_AXIS = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f Z_AXIS = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final float[] SIN = SystemUtils.make(new float[65536], var0 -> {
        for (int var1 = 0; var1 < ((float[])var0).length; ++var1) {
            var0[var1] = (float)java.lang.Math.sin((double)var1 * java.lang.Math.PI * 2.0 / 65536.0);
        }
    });
    private static final RandomSource RANDOM = RandomSource.createThreadSafe();
    private static final int[] MULTIPLY_DE_BRUIJN_BIT_POSITION = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
    private static final double ONE_SIXTH = 0.16666666666666666;
    private static final int FRAC_EXP = 8;
    private static final int LUT_SIZE = 257;
    private static final double FRAC_BIAS = Double.longBitsToDouble(4805340802404319232L);
    private static final double[] ASIN_TAB = new double[257];
    private static final double[] COS_TAB = new double[257];

    public static float sin(float var0) {
        return SIN[(int)(var0 * 10430.378f) & 0xFFFF];
    }

    public static float cos(float var0) {
        return SIN[(int)(var0 * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float sqrt(float var0) {
        return (float)java.lang.Math.sqrt(var0);
    }

    public static int floor(float var0) {
        int var1 = (int)var0;
        return var0 < (float)var1 ? var1 - 1 : var1;
    }

    public static int floor(double var0) {
        int var2 = (int)var0;
        return var0 < (double)var2 ? var2 - 1 : var2;
    }

    public static long lfloor(double var0) {
        long var2 = (long)var0;
        return var0 < (double)var2 ? var2 - 1L : var2;
    }

    public static float abs(float var0) {
        return java.lang.Math.abs(var0);
    }

    public static int abs(int var0) {
        return java.lang.Math.abs(var0);
    }

    public static int ceil(float var0) {
        int var1 = (int)var0;
        return var0 > (float)var1 ? var1 + 1 : var1;
    }

    public static int ceil(double var0) {
        int var2 = (int)var0;
        return var0 > (double)var2 ? var2 + 1 : var2;
    }

    public static int clamp(int var0, int var1, int var2) {
        return java.lang.Math.min(java.lang.Math.max(var0, var1), var2);
    }

    public static long clamp(long var0, long var2, long var4) {
        return java.lang.Math.min(java.lang.Math.max(var0, var2), var4);
    }

    public static float clamp(float var0, float var1, float var2) {
        if (var0 < var1) {
            return var1;
        }
        return java.lang.Math.min(var0, var2);
    }

    public static double clamp(double var0, double var2, double var4) {
        if (var0 < var2) {
            return var2;
        }
        return java.lang.Math.min(var0, var4);
    }

    public static double clampedLerp(double var0, double var2, double var4) {
        if (var4 < 0.0) {
            return var0;
        }
        if (var4 > 1.0) {
            return var2;
        }
        return MathHelper.lerp(var4, var0, var2);
    }

    public static float clampedLerp(float var0, float var1, float var2) {
        if (var2 < 0.0f) {
            return var0;
        }
        if (var2 > 1.0f) {
            return var1;
        }
        return MathHelper.lerp(var2, var0, var1);
    }

    public static double absMax(double var0, double var2) {
        if (var0 < 0.0) {
            var0 = -var0;
        }
        if (var2 < 0.0) {
            var2 = -var2;
        }
        return java.lang.Math.max(var0, var2);
    }

    public static int floorDiv(int var0, int var1) {
        return java.lang.Math.floorDiv(var0, var1);
    }

    public static int nextInt(RandomSource var0, int var1, int var2) {
        if (var1 >= var2) {
            return var1;
        }
        return var0.nextInt(var2 - var1 + 1) + var1;
    }

    public static float nextFloat(RandomSource var0, float var1, float var2) {
        if (var1 >= var2) {
            return var1;
        }
        return var0.nextFloat() * (var2 - var1) + var1;
    }

    public static double nextDouble(RandomSource var0, double var1, double var3) {
        if (var1 >= var3) {
            return var1;
        }
        return var0.nextDouble() * (var3 - var1) + var1;
    }

    public static boolean equal(float var0, float var1) {
        return java.lang.Math.abs(var1 - var0) < 1.0E-5f;
    }

    public static boolean equal(double var0, double var2) {
        return java.lang.Math.abs(var2 - var0) < (double)1.0E-5f;
    }

    public static int positiveModulo(int var0, int var1) {
        return java.lang.Math.floorMod(var0, var1);
    }

    public static float positiveModulo(float var0, float var1) {
        return (var0 % var1 + var1) % var1;
    }

    public static double positiveModulo(double var0, double var2) {
        return (var0 % var2 + var2) % var2;
    }

    public static boolean isMultipleOf(int var0, int var1) {
        return var0 % var1 == 0;
    }

    public static int wrapDegrees(int var0) {
        int var1 = var0 % 360;
        if (var1 >= 180) {
            var1 -= 360;
        }
        if (var1 < -180) {
            var1 += 360;
        }
        return var1;
    }

    public static float wrapDegrees(float var0) {
        float var1 = var0 % 360.0f;
        if (var1 >= 180.0f) {
            var1 -= 360.0f;
        }
        if (var1 < -180.0f) {
            var1 += 360.0f;
        }
        return var1;
    }

    public static double wrapDegrees(double var0) {
        double var2 = var0 % 360.0;
        if (var2 >= 180.0) {
            var2 -= 360.0;
        }
        if (var2 < -180.0) {
            var2 += 360.0;
        }
        return var2;
    }

    public static float degreesDifference(float var0, float var1) {
        return MathHelper.wrapDegrees(var1 - var0);
    }

    public static float degreesDifferenceAbs(float var0, float var1) {
        return MathHelper.abs(MathHelper.degreesDifference(var0, var1));
    }

    public static float rotateIfNecessary(float var0, float var1, float var2) {
        float var3 = MathHelper.degreesDifference(var0, var1);
        float var4 = MathHelper.clamp(var3, -var2, var2);
        return var1 - var4;
    }

    public static float approach(float var0, float var1, float var2) {
        var2 = MathHelper.abs(var2);
        if (var0 < var1) {
            return MathHelper.clamp(var0 + var2, var0, var1);
        }
        return MathHelper.clamp(var0 - var2, var1, var0);
    }

    public static float approachDegrees(float var0, float var1, float var2) {
        float var3 = MathHelper.degreesDifference(var0, var1);
        return MathHelper.approach(var0, var0 + var3, var2);
    }

    public static int getInt(String var0, int var1) {
        return NumberUtils.toInt((String)var0, (int)var1);
    }

    public static int smallestEncompassingPowerOfTwo(int var0) {
        int var1 = var0 - 1;
        var1 |= var1 >> 1;
        var1 |= var1 >> 2;
        var1 |= var1 >> 4;
        var1 |= var1 >> 8;
        var1 |= var1 >> 16;
        return var1 + 1;
    }

    public static boolean isPowerOfTwo(int var0) {
        return var0 != 0 && (var0 & var0 - 1) == 0;
    }

    public static int ceillog2(int var0) {
        var0 = MathHelper.isPowerOfTwo(var0) ? var0 : MathHelper.smallestEncompassingPowerOfTwo(var0);
        return MULTIPLY_DE_BRUIJN_BIT_POSITION[(int)((long)var0 * 125613361L >> 27) & 0x1F];
    }

    public static int log2(int var0) {
        return MathHelper.ceillog2(var0) - (MathHelper.isPowerOfTwo(var0) ? 0 : 1);
    }

    public static int color(float var0, float var1, float var2) {
        return ColorUtil.b.color(0, MathHelper.floor(var0 * 255.0f), MathHelper.floor(var1 * 255.0f), MathHelper.floor(var2 * 255.0f));
    }

    public static float frac(float var0) {
        return var0 - (float)MathHelper.floor(var0);
    }

    public static double frac(double var0) {
        return var0 - (double)MathHelper.lfloor(var0);
    }

    @Deprecated
    public static long getSeed(BaseBlockPosition var0) {
        return MathHelper.getSeed(var0.getX(), var0.getY(), var0.getZ());
    }

    @Deprecated
    public static long getSeed(int var0, int var1, int var2) {
        long var3 = (long)(var0 * 3129871) ^ (long)var2 * 116129781L ^ (long)var1;
        var3 = var3 * var3 * 42317861L + var3 * 11L;
        return var3 >> 16;
    }

    public static UUID createInsecureUUID(RandomSource var0) {
        long var1 = var0.nextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long var3 = var0.nextLong() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(var1, var3);
    }

    public static UUID createInsecureUUID() {
        return MathHelper.createInsecureUUID(RANDOM);
    }

    public static double inverseLerp(double var0, double var2, double var4) {
        return (var0 - var2) / (var4 - var2);
    }

    public static float inverseLerp(float var0, float var1, float var2) {
        return (var0 - var1) / (var2 - var1);
    }

    public static boolean rayIntersectsAABB(Vec3D var0, Vec3D var1, AxisAlignedBB var2) {
        double var3 = (var2.minX + var2.maxX) * 0.5;
        double var5 = (var2.maxX - var2.minX) * 0.5;
        double var7 = var0.x - var3;
        if (java.lang.Math.abs(var7) > var5 && var7 * var1.x >= 0.0) {
            return false;
        }
        double var9 = (var2.minY + var2.maxY) * 0.5;
        double var11 = (var2.maxY - var2.minY) * 0.5;
        double var13 = var0.y - var9;
        if (java.lang.Math.abs(var13) > var11 && var13 * var1.y >= 0.0) {
            return false;
        }
        double var15 = (var2.minZ + var2.maxZ) * 0.5;
        double var17 = (var2.maxZ - var2.minZ) * 0.5;
        double var19 = var0.z - var15;
        if (java.lang.Math.abs(var19) > var17 && var19 * var1.z >= 0.0) {
            return false;
        }
        double var21 = java.lang.Math.abs(var1.x);
        double var23 = java.lang.Math.abs(var1.y);
        double var25 = java.lang.Math.abs(var1.z);
        double var27 = var1.y * var19 - var1.z * var13;
        if (java.lang.Math.abs(var27) > var11 * var25 + var17 * var23) {
            return false;
        }
        var27 = var1.z * var7 - var1.x * var19;
        if (java.lang.Math.abs(var27) > var5 * var25 + var17 * var21) {
            return false;
        }
        var27 = var1.x * var13 - var1.y * var7;
        return java.lang.Math.abs(var27) < var5 * var23 + var11 * var21;
    }

    public static double atan2(double var0, double var2) {
        double var9;
        boolean var8;
        boolean var7;
        boolean var6;
        double var4 = var2 * var2 + var0 * var0;
        if (Double.isNaN(var4)) {
            return Double.NaN;
        }
        boolean bl = var6 = var0 < 0.0;
        if (var6) {
            var0 = -var0;
        }
        boolean bl2 = var7 = var2 < 0.0;
        if (var7) {
            var2 = -var2;
        }
        boolean bl3 = var8 = var0 > var2;
        if (var8) {
            var9 = var2;
            var2 = var0;
            var0 = var9;
        }
        var9 = MathHelper.fastInvSqrt(var4);
        var2 *= var9;
        double var11 = FRAC_BIAS + (var0 *= var9);
        int var13 = (int)Double.doubleToRawLongBits(var11);
        double var14 = ASIN_TAB[var13];
        double var16 = COS_TAB[var13];
        double var18 = var11 - FRAC_BIAS;
        double var20 = var0 * var16 - var2 * var18;
        double var22 = (6.0 + var20 * var20) * var20 * 0.16666666666666666;
        double var24 = var14 + var22;
        if (var8) {
            var24 = 1.5707963267948966 - var24;
        }
        if (var7) {
            var24 = java.lang.Math.PI - var24;
        }
        if (var6) {
            var24 = -var24;
        }
        return var24;
    }

    public static float invSqrt(float var0) {
        return Math.invsqrt((float)var0);
    }

    public static double invSqrt(double var0) {
        return Math.invsqrt((double)var0);
    }

    @Deprecated
    public static double fastInvSqrt(double var0) {
        double var2 = 0.5 * var0;
        long var4 = Double.doubleToRawLongBits(var0);
        var4 = 6910469410427058090L - (var4 >> 1);
        var0 = Double.longBitsToDouble(var4);
        var0 *= 1.5 - var2 * var0 * var0;
        return var0;
    }

    public static float fastInvCubeRoot(float var0) {
        int var1 = Float.floatToIntBits(var0);
        var1 = 1419967116 - var1 / 3;
        float var2 = Float.intBitsToFloat(var1);
        var2 = 0.6666667f * var2 + 1.0f / (3.0f * var2 * var2 * var0);
        var2 = 0.6666667f * var2 + 1.0f / (3.0f * var2 * var2 * var0);
        return var2;
    }

    public static int hsvToRgb(float var0, float var1, float var2) {
        return MathHelper.hsvToArgb(var0, var1, var2, 0);
    }

    public static int hsvToArgb(float var0, float var1, float var2, int var3) {
        float var10;
        float var9;
        int var4 = (int)(var0 * 6.0f) % 6;
        float var5 = var0 * 6.0f - (float)var4;
        float var6 = var2 * (1.0f - var1);
        float var7 = var2 * (1.0f - var5 * var1);
        float var8 = var2 * (1.0f - (1.0f - var5) * var1);
        return ColorUtil.b.color(var3, MathHelper.clamp((int)(var9 * 255.0f), 0, 255), MathHelper.clamp((int)(var10 * 255.0f), 0, 255), MathHelper.clamp((int)((switch (var4) {
            case 0 -> {
                var9 = var2;
                var10 = var8;
                yield var6;
            }
            case 1 -> {
                var9 = var7;
                var10 = var2;
                yield var6;
            }
            case 2 -> {
                var9 = var6;
                var10 = var2;
                yield var8;
            }
            case 3 -> {
                var9 = var6;
                var10 = var7;
                yield var2;
            }
            case 4 -> {
                var9 = var8;
                var10 = var6;
                yield var2;
            }
            case 5 -> {
                var9 = var2;
                var10 = var6;
                yield var7;
            }
            default -> throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + var0 + ", " + var1 + ", " + var2);
        }) * 255.0f), 0, 255));
    }

    public static int murmurHash3Mixer(int var0) {
        var0 ^= var0 >>> 16;
        var0 *= -2048144789;
        var0 ^= var0 >>> 13;
        var0 *= -1028477387;
        var0 ^= var0 >>> 16;
        return var0;
    }

    public static int binarySearch(int var0, int var1, IntPredicate var2) {
        int var3 = var1 - var0;
        while (var3 > 0) {
            int var4 = var3 / 2;
            int var5 = var0 + var4;
            if (var2.test(var5)) {
                var3 = var4;
                continue;
            }
            var0 = var5 + 1;
            var3 -= var4 + 1;
        }
        return var0;
    }

    public static int lerpInt(float var0, int var1, int var2) {
        return var1 + MathHelper.floor(var0 * (float)(var2 - var1));
    }

    public static int lerpDiscrete(float var0, int var1, int var2) {
        int var3 = var2 - var1;
        return var1 + MathHelper.floor(var0 * (float)(var3 - 1)) + (var0 > 0.0f ? 1 : 0);
    }

    public static float lerp(float var0, float var1, float var2) {
        return var1 + var0 * (var2 - var1);
    }

    public static double lerp(double var0, double var2, double var4) {
        return var2 + var0 * (var4 - var2);
    }

    public static double lerp2(double var0, double var2, double var4, double var6, double var8, double var10) {
        return MathHelper.lerp(var2, MathHelper.lerp(var0, var4, var6), MathHelper.lerp(var0, var8, var10));
    }

    public static double lerp3(double var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20) {
        return MathHelper.lerp(var4, MathHelper.lerp2(var0, var2, var6, var8, var10, var12), MathHelper.lerp2(var0, var2, var14, var16, var18, var20));
    }

    public static float catmullrom(float var0, float var1, float var2, float var3, float var4) {
        return 0.5f * (2.0f * var2 + (var3 - var1) * var0 + (2.0f * var1 - 5.0f * var2 + 4.0f * var3 - var4) * var0 * var0 + (3.0f * var2 - var1 - 3.0f * var3 + var4) * var0 * var0 * var0);
    }

    public static double smoothstep(double var0) {
        return var0 * var0 * var0 * (var0 * (var0 * 6.0 - 15.0) + 10.0);
    }

    public static double smoothstepDerivative(double var0) {
        return 30.0 * var0 * var0 * (var0 - 1.0) * (var0 - 1.0);
    }

    public static int sign(double var0) {
        if (var0 == 0.0) {
            return 0;
        }
        return var0 > 0.0 ? 1 : -1;
    }

    public static float rotLerp(float var0, float var1, float var2) {
        return var1 + var0 * MathHelper.wrapDegrees(var2 - var1);
    }

    public static double rotLerp(double var0, double var2, double var4) {
        return var2 + var0 * MathHelper.wrapDegrees(var4 - var2);
    }

    public static float triangleWave(float var0, float var1) {
        return (java.lang.Math.abs(var0 % var1 - var1 * 0.5f) - var1 * 0.25f) / (var1 * 0.25f);
    }

    public static float square(float var0) {
        return var0 * var0;
    }

    public static double square(double var0) {
        return var0 * var0;
    }

    public static int square(int var0) {
        return var0 * var0;
    }

    public static long square(long var0) {
        return var0 * var0;
    }

    public static double clampedMap(double var0, double var2, double var4, double var6, double var8) {
        return MathHelper.clampedLerp(var6, var8, MathHelper.inverseLerp(var0, var2, var4));
    }

    public static float clampedMap(float var0, float var1, float var2, float var3, float var4) {
        return MathHelper.clampedLerp(var3, var4, MathHelper.inverseLerp(var0, var1, var2));
    }

    public static double map(double var0, double var2, double var4, double var6, double var8) {
        return MathHelper.lerp(MathHelper.inverseLerp(var0, var2, var4), var6, var8);
    }

    public static float map(float var0, float var1, float var2, float var3, float var4) {
        return MathHelper.lerp(MathHelper.inverseLerp(var0, var1, var2), var3, var4);
    }

    public static double wobble(double var0) {
        return var0 + (2.0 * RandomSource.create(MathHelper.floor(var0 * 3000.0)).nextDouble() - 1.0) * 1.0E-7 / 2.0;
    }

    public static int roundToward(int var0, int var1) {
        return MathHelper.positiveCeilDiv(var0, var1) * var1;
    }

    public static int positiveCeilDiv(int var0, int var1) {
        return -java.lang.Math.floorDiv(-var0, var1);
    }

    public static int randomBetweenInclusive(RandomSource var0, int var1, int var2) {
        return var0.nextInt(var2 - var1 + 1) + var1;
    }

    public static float randomBetween(RandomSource var0, float var1, float var2) {
        return var0.nextFloat() * (var2 - var1) + var1;
    }

    public static float normal(RandomSource var0, float var1, float var2) {
        return var1 + (float)var0.nextGaussian() * var2;
    }

    public static double lengthSquared(double var0, double var2) {
        return var0 * var0 + var2 * var2;
    }

    public static double length(double var0, double var2) {
        return java.lang.Math.sqrt(MathHelper.lengthSquared(var0, var2));
    }

    public static double lengthSquared(double var0, double var2, double var4) {
        return var0 * var0 + var2 * var2 + var4 * var4;
    }

    public static double length(double var0, double var2, double var4) {
        return java.lang.Math.sqrt(MathHelper.lengthSquared(var0, var2, var4));
    }

    public static float lengthSquared(float var0, float var1, float var2) {
        return var0 * var0 + var1 * var1 + var2 * var2;
    }

    public static int quantize(double var0, int var2) {
        return MathHelper.floor(var0 / (double)var2) * var2;
    }

    public static IntStream outFromOrigin(int var0, int var1, int var2) {
        return MathHelper.outFromOrigin(var0, var1, var2, 1);
    }

    public static IntStream outFromOrigin(int var0, int var1, int var2, int var32) {
        if (var1 > var2) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "upperbound %d expected to be > lowerBound %d", var2, var1));
        }
        if (var32 < 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "steps expected to be >= 1, was %d", var32));
        }
        if (var0 < var1 || var0 > var2) {
            return IntStream.empty();
        }
        return IntStream.iterate(var0, var3 -> {
            int var4 = java.lang.Math.abs(var0 - var3);
            return var0 - var4 >= var1 || var0 + var4 <= var2;
        }, var4 -> {
            int var8;
            boolean var7;
            boolean var5 = var4 <= var0;
            int var6 = java.lang.Math.abs(var0 - var4);
            boolean bl = var7 = var0 + var6 + var32 <= var2;
            if (!(var5 && var7 || (var8 = var0 - var6 - (var5 ? var32 : 0)) < var1)) {
                return var8;
            }
            return var0 + var6 + var32;
        });
    }

    public static Quaternionf rotationAroundAxis(Vector3f var0, Quaternionf var1, Quaternionf var2) {
        float var3 = var0.dot(var1.x, var1.y, var1.z);
        return var2.set(var0.x * var3, var0.y * var3, var0.z * var3, var1.w).normalize();
    }

    public static int mulAndTruncate(Fraction var0, int var1) {
        return var0.getNumerator() * var1 / var0.getDenominator();
    }

    static {
        for (int var02 = 0; var02 < 257; ++var02) {
            double var1 = (double)var02 / 256.0;
            double var3 = java.lang.Math.asin(var1);
            MathHelper.COS_TAB[var02] = java.lang.Math.cos(var3);
            MathHelper.ASIN_TAB[var02] = var3;
        }
    }
}

