/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RecipeBook {
    public final Set<MinecraftKey> known = Sets.newHashSet();
    protected final Set<MinecraftKey> highlight = Sets.newHashSet();
    private final RecipeBookSettings bookSettings = new RecipeBookSettings();

    public void copyOverData(RecipeBook var0) {
        this.known.clear();
        this.highlight.clear();
        this.bookSettings.replaceFrom(var0.bookSettings);
        this.known.addAll(var0.known);
        this.highlight.addAll(var0.highlight);
    }

    public void add(RecipeHolder<?> var0) {
        if (!var0.value().isSpecial()) {
            this.add(var0.id());
        }
    }

    protected void add(MinecraftKey var0) {
        this.known.add(var0);
    }

    public boolean contains(@Nullable RecipeHolder<?> var0) {
        if (var0 == null) {
            return false;
        }
        return this.known.contains(var0.id());
    }

    public boolean contains(MinecraftKey var0) {
        return this.known.contains(var0);
    }

    public void remove(RecipeHolder<?> var0) {
        this.remove(var0.id());
    }

    protected void remove(MinecraftKey var0) {
        this.known.remove(var0);
        this.highlight.remove(var0);
    }

    public boolean willHighlight(RecipeHolder<?> var0) {
        return this.highlight.contains(var0.id());
    }

    public void removeHighlight(RecipeHolder<?> var0) {
        this.highlight.remove(var0.id());
    }

    public void addHighlight(RecipeHolder<?> var0) {
        this.addHighlight(var0.id());
    }

    protected void addHighlight(MinecraftKey var0) {
        this.highlight.add(var0);
    }

    public boolean isOpen(RecipeBookType var0) {
        return this.bookSettings.isOpen(var0);
    }

    public void setOpen(RecipeBookType var0, boolean var1) {
        this.bookSettings.setOpen(var0, var1);
    }

    public boolean isFiltering(ContainerRecipeBook<?, ?> var0) {
        return this.isFiltering(var0.getRecipeBookType());
    }

    public boolean isFiltering(RecipeBookType var0) {
        return this.bookSettings.isFiltering(var0);
    }

    public void setFiltering(RecipeBookType var0, boolean var1) {
        this.bookSettings.setFiltering(var0, var1);
    }

    public void setBookSettings(RecipeBookSettings var0) {
        this.bookSettings.replaceFrom(var0);
    }

    public RecipeBookSettings getBookSettings() {
        return this.bookSettings.copy();
    }

    public void setBookSetting(RecipeBookType var0, boolean var1, boolean var2) {
        this.bookSettings.setOpen(var0, var1);
        this.bookSettings.setFiltering(var0, var2);
    }
}

