/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.slf4j.Logger;

public class LightEngineThreaded
extends LevelLightEngine
implements AutoCloseable {
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ThreadedMailbox<Runnable> taskMailbox;
    private final ObjectList<Pair<Update, Runnable>> lightTasks = new ObjectArrayList();
    private final PlayerChunkMap chunkMap;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> sorterMailbox;
    private final int taskPerBatch = 1000;
    private final AtomicBoolean scheduled = new AtomicBoolean();

    public LightEngineThreaded(ILightAccess var0, PlayerChunkMap var1, boolean var2, ThreadedMailbox<Runnable> var3, Mailbox<ChunkTaskQueueSorter.a<Runnable>> var4) {
        super(var0, true, var2);
        this.chunkMap = var1;
        this.sorterMailbox = var4;
        this.taskMailbox = var3;
    }

    @Override
    public void close() {
    }

    @Override
    public int runLightUpdates() {
        throw SystemUtils.pauseInIde(new UnsupportedOperationException("Ran automatically on a different thread!"));
    }

    @Override
    public void checkBlock(BlockPosition var0) {
        BlockPosition var1 = var0.immutable();
        this.addTask(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()), Update.PRE_UPDATE, SystemUtils.name(() -> super.checkBlock(var1), () -> "checkBlock " + String.valueOf(var1)));
    }

    protected void updateChunkStatus(ChunkCoordIntPair var0) {
        this.addTask(var0.x, var0.z, () -> 0, Update.PRE_UPDATE, SystemUtils.name(() -> {
            int var1;
            super.retainData(var0, false);
            super.setLightEnabled(var0, false);
            for (var1 = this.getMinLightSection(); var1 < this.getMaxLightSection(); ++var1) {
                super.queueSectionData(EnumSkyBlock.BLOCK, SectionPosition.of(var0, var1), null);
                super.queueSectionData(EnumSkyBlock.SKY, SectionPosition.of(var0, var1), null);
            }
            for (var1 = this.levelHeightAccessor.getMinSection(); var1 < this.levelHeightAccessor.getMaxSection(); ++var1) {
                super.updateSectionStatus(SectionPosition.of(var0, var1), true);
            }
        }, () -> "updateChunkStatus " + String.valueOf(var0) + " true"));
    }

    @Override
    public void updateSectionStatus(SectionPosition var0, boolean var1) {
        this.addTask(var0.x(), var0.z(), () -> 0, Update.PRE_UPDATE, SystemUtils.name(() -> super.updateSectionStatus(var0, var1), () -> "updateSectionStatus " + String.valueOf(var0) + " " + var1));
    }

    @Override
    public void propagateLightSources(ChunkCoordIntPair var0) {
        this.addTask(var0.x, var0.z, Update.PRE_UPDATE, SystemUtils.name(() -> super.propagateLightSources(var0), () -> "propagateLight " + String.valueOf(var0)));
    }

    @Override
    public void setLightEnabled(ChunkCoordIntPair var0, boolean var1) {
        this.addTask(var0.x, var0.z, Update.PRE_UPDATE, SystemUtils.name(() -> super.setLightEnabled(var0, var1), () -> "enableLight " + String.valueOf(var0) + " " + var1));
    }

    @Override
    public void queueSectionData(EnumSkyBlock var0, SectionPosition var1, @Nullable NibbleArray var2) {
        this.addTask(var1.x(), var1.z(), () -> 0, Update.PRE_UPDATE, SystemUtils.name(() -> super.queueSectionData(var0, var1, var2), () -> "queueData " + String.valueOf(var1)));
    }

    private void addTask(int var0, int var1, Update var2, Runnable var3) {
        this.addTask(var0, var1, this.chunkMap.getChunkQueueLevel(ChunkCoordIntPair.asLong(var0, var1)), var2, var3);
    }

    private void addTask(int var0, int var1, IntSupplier var2, Update var3, Runnable var4) {
        this.sorterMailbox.tell(ChunkTaskQueueSorter.message(() -> {
            this.lightTasks.add((Object)Pair.of((Object)((Object)var3), (Object)var4));
            if (this.lightTasks.size() >= 1000) {
                this.runUpdate();
            }
        }, ChunkCoordIntPair.asLong(var0, var1), var2));
    }

    @Override
    public void retainData(ChunkCoordIntPair var0, boolean var1) {
        this.addTask(var0.x, var0.z, () -> 0, Update.PRE_UPDATE, SystemUtils.name(() -> super.retainData(var0, var1), () -> "retainData " + String.valueOf(var0)));
    }

    public CompletableFuture<IChunkAccess> initializeLight(IChunkAccess var0, boolean var12) {
        ChunkCoordIntPair var2 = var0.getPos();
        this.addTask(var2.x, var2.z, Update.PRE_UPDATE, SystemUtils.name(() -> {
            ChunkSection[] var2 = var0.getSections();
            for (int var3 = 0; var3 < var0.getSectionsCount(); ++var3) {
                ChunkSection var4 = var2[var3];
                if (var4.hasOnlyAir()) continue;
                int var5 = this.levelHeightAccessor.getSectionYFromSectionIndex(var3);
                super.updateSectionStatus(SectionPosition.of(var2, var5), false);
            }
        }, () -> "initializeLight: " + String.valueOf(var2)));
        return CompletableFuture.supplyAsync(() -> {
            super.setLightEnabled(var2, var12);
            super.retainData(var2, false);
            return var0;
        }, var1 -> this.addTask(var0.x, var0.z, Update.POST_UPDATE, var1));
    }

    public CompletableFuture<IChunkAccess> lightChunk(IChunkAccess var0, boolean var12) {
        ChunkCoordIntPair var2 = var0.getPos();
        var0.setLightCorrect(false);
        this.addTask(var2.x, var2.z, Update.PRE_UPDATE, SystemUtils.name(() -> {
            if (!var12) {
                super.propagateLightSources(var2);
            }
        }, () -> "lightChunk " + String.valueOf(var2) + " " + var12));
        return CompletableFuture.supplyAsync(() -> {
            var0.setLightCorrect(true);
            return var0;
        }, var1 -> this.addTask(var0.x, var0.z, Update.POST_UPDATE, var1));
    }

    public void tryScheduleUpdate() {
        if ((!this.lightTasks.isEmpty() || super.hasLightWork()) && this.scheduled.compareAndSet(false, true)) {
            this.taskMailbox.tell(() -> {
                this.runUpdate();
                this.scheduled.set(false);
            });
        }
    }

    private void runUpdate() {
        Pair var3;
        int var2;
        int var0 = Math.min(this.lightTasks.size(), 1000);
        ObjectListIterator var1 = this.lightTasks.iterator();
        for (var2 = 0; var1.hasNext() && var2 < var0; ++var2) {
            var3 = (Pair)var1.next();
            if (var3.getFirst() != Update.PRE_UPDATE) continue;
            ((Runnable)var3.getSecond()).run();
        }
        var1.back(var2);
        super.runLightUpdates();
        for (var2 = 0; var1.hasNext() && var2 < var0; ++var2) {
            var3 = (Pair)var1.next();
            if (var3.getFirst() == Update.POST_UPDATE) {
                ((Runnable)var3.getSecond()).run();
            }
            var1.remove();
        }
    }

    public CompletableFuture<?> waitForPendingTasks(int var0, int var1) {
        return CompletableFuture.runAsync(() -> {}, var2 -> this.addTask(var0, var1, Update.POST_UPDATE, var2));
    }

    static final class Update
    extends Enum<Update> {
        public static final /* enum */ Update PRE_UPDATE = new Update();
        public static final /* enum */ Update POST_UPDATE = new Update();
        private static final /* synthetic */ Update[] c;

        public static Update[] values() {
            return (Update[])c.clone();
        }

        public static Update valueOf(String var0) {
            return Enum.valueOf(Update.class, var0);
        }

        private static /* synthetic */ Update[] a() {
            return new Update[]{PRE_UPDATE, POST_UPDATE};
        }

        static {
            c = Update.a();
        }
    }
}

