/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.recipebook;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.game.PacketPlayOutAutoRecipe;
import net.minecraft.recipebook.AutoRecipeAbstract;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;

public class AutoRecipe<I extends RecipeInput, R extends IRecipe<I>>
implements AutoRecipeAbstract<Integer> {
    private static final int ITEM_NOT_FOUND = -1;
    protected final AutoRecipeStackManager stackedContents = new AutoRecipeStackManager();
    protected PlayerInventory inventory;
    protected ContainerRecipeBook<I, R> menu;

    public AutoRecipe(ContainerRecipeBook<I, R> var0) {
        this.menu = var0;
    }

    public void recipeClicked(EntityPlayer var0, @Nullable RecipeHolder<R> var1, boolean var2) {
        if (var1 == null || !var0.getRecipeBook().contains(var1)) {
            return;
        }
        this.inventory = var0.getInventory();
        if (!this.testClearGrid() && !var0.isCreative()) {
            return;
        }
        this.stackedContents.clear();
        var0.getInventory().fillStackedContents(this.stackedContents);
        this.menu.fillCraftSlotsStackedContents(this.stackedContents);
        if (this.stackedContents.canCraft((IRecipe<?>)var1.value(), null)) {
            this.handleRecipeClicked(var1, var2);
        } else {
            this.clearGrid();
            var0.connection.send(new PacketPlayOutAutoRecipe(var0.containerMenu.containerId, var1));
        }
        var0.getInventory().setChanged();
    }

    protected void clearGrid() {
        for (int var0 = 0; var0 < this.menu.getSize(); ++var0) {
            if (!this.menu.shouldMoveToInventory(var0)) continue;
            ItemStack var1 = this.menu.getSlot(var0).getItem().copy();
            this.inventory.placeItemBackInInventory(var1, false);
            this.menu.getSlot(var0).set(var1);
        }
        this.menu.clearCraftingContent();
    }

    protected void handleRecipeClicked(RecipeHolder<R> var0, boolean var1) {
        Object var5;
        int var4;
        boolean var2 = this.menu.recipeMatches(var0);
        int var3 = this.stackedContents.getBiggestCraftableStack(var0, null);
        if (var2) {
            for (var4 = 0; var4 < this.menu.getGridHeight() * this.menu.getGridWidth() + 1; ++var4) {
                if (var4 == this.menu.getResultSlotIndex() || ((ItemStack)(var5 = this.menu.getSlot(var4).getItem())).isEmpty() || Math.min(var3, ((ItemStack)var5).getMaxStackSize()) >= ((ItemStack)var5).getCount() + 1) continue;
                return;
            }
        }
        var4 = this.getStackSize(var1, var3, var2);
        var5 = new IntArrayList();
        if (this.stackedContents.canCraft((IRecipe<?>)var0.value(), (IntList)var5, var4)) {
            int var6 = var4;
            IntListIterator intListIterator = var5.iterator();
            while (intListIterator.hasNext()) {
                int var10;
                int var8 = (Integer)intListIterator.next();
                ItemStack var9 = AutoRecipeStackManager.fromStackingIndex(var8);
                if (var9.isEmpty() || (var10 = var9.getMaxStackSize()) >= var6) continue;
                var6 = var10;
            }
            var4 = var6;
            if (this.stackedContents.canCraft((IRecipe<?>)var0.value(), (IntList)var5, var4)) {
                this.clearGrid();
                this.placeRecipe(this.menu.getGridWidth(), this.menu.getGridHeight(), this.menu.getResultSlotIndex(), var0, var5.iterator(), var4);
            }
        }
    }

    @Override
    public void addItemToSlot(Integer var0, int var1, int var2, int var3, int var4) {
        Slot var5 = this.menu.getSlot(var1);
        ItemStack var6 = AutoRecipeStackManager.fromStackingIndex(var0);
        if (var6.isEmpty()) {
            return;
        }
        int var7 = var2;
        while (var7 > 0) {
            if ((var7 = this.moveItemToGrid(var5, var6, var7)) != -1) continue;
            return;
        }
    }

    protected int getStackSize(boolean var0, int var1, boolean var2) {
        int var3 = 1;
        if (var0) {
            var3 = var1;
        } else if (var2) {
            var3 = Integer.MAX_VALUE;
            for (int var4 = 0; var4 < this.menu.getGridWidth() * this.menu.getGridHeight() + 1; ++var4) {
                ItemStack var5;
                if (var4 == this.menu.getResultSlotIndex() || (var5 = this.menu.getSlot(var4).getItem()).isEmpty() || var3 <= var5.getCount()) continue;
                var3 = var5.getCount();
            }
            if (var3 != Integer.MAX_VALUE) {
                ++var3;
            }
        }
        return var3;
    }

    protected int moveItemToGrid(Slot var0, ItemStack var1, int var2) {
        int var5;
        int var3 = this.inventory.findSlotMatchingUnusedItem(var1);
        if (var3 == -1) {
            return -1;
        }
        ItemStack var4 = this.inventory.getItem(var3);
        if (var2 < var4.getCount()) {
            this.inventory.removeItem(var3, var2);
            var5 = var2;
        } else {
            this.inventory.removeItemNoUpdate(var3);
            var5 = var4.getCount();
        }
        if (var0.getItem().isEmpty()) {
            var0.set(var4.copyWithCount(var5));
        } else {
            var0.getItem().grow(var5);
        }
        return var2 - var5;
    }

    private boolean testClearGrid() {
        ArrayList var0 = Lists.newArrayList();
        int var1 = this.getAmountOfFreeSlotsInInventory();
        for (int var2 = 0; var2 < this.menu.getGridWidth() * this.menu.getGridHeight() + 1; ++var2) {
            ItemStack var3;
            if (var2 == this.menu.getResultSlotIndex() || (var3 = this.menu.getSlot(var2).getItem().copy()).isEmpty()) continue;
            int var4 = this.inventory.getSlotWithRemainingSpace(var3);
            if (var4 == -1 && var0.size() <= var1) {
                for (ItemStack var6 : var0) {
                    if (!ItemStack.isSameItem(var6, var3) || var6.getCount() == var6.getMaxStackSize() || var6.getCount() + var3.getCount() > var6.getMaxStackSize()) continue;
                    var6.grow(var3.getCount());
                    var3.setCount(0);
                    break;
                }
                if (var3.isEmpty()) continue;
                if (var0.size() < var1) {
                    var0.add(var3);
                    continue;
                }
                return false;
            }
            if (var4 != -1) continue;
            return false;
        }
        return true;
    }

    private int getAmountOfFreeSlotsInInventory() {
        int var0 = 0;
        for (ItemStack var2 : this.inventory.items) {
            if (!var2.isEmpty()) continue;
            ++var0;
        }
        return var0;
    }
}

